/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.util.workflow;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * A instance of Process represents a stateful process executing a series of Tasks, 
 *  which may be:
 *  <ul>
 *  <li> user interactions
 *  <li> calls to DataSources (hence: any database or web service)
 *  <li> arbitrary code
 *  <li> other Processes
 *  </ul>
 * A Process is <i>stateful</i> in the sense that it maintains {@link com.smartgwt.client.util.workflow.Process#getState
 * state}
 *  across the different tasks that are executed.  This allows you to maintain context as you
 *  walk a user through a multi-step business process in your application, which may involve
 *  multiple operations on multiple entities.  Each Task that executes can use the Process state
 *  as inputs, and can output a result which is stored in the Process state - see
 *  {@link com.smartgwt.client.docs.TaskIO}.
 *  <P>
 *  A Process can have multiple branches, choosing the next Task to execute based on
 * {@link com.smartgwt.client.data.Criteria} - see {@link com.smartgwt.client.util.workflow.DecisionTask} and {@link
 * com.smartgwt.client.util.workflow.MultiDecisionTask}.
 *  <P>
 *  Because a Process may return to a previous Task in various situations, the data model of a
 *  Process is strictly speaking a <i>graph</i> (a set of nodes connected by arbitary
 *  interlinks). However, most processes have sequences of several tasks in a row, and the
 *  definition format allows these to be represented as simple Arrays called "sequences",
 * specified via {@link com.smartgwt.client.util.workflow.Process#getSequences sequences}.  This reduces the need to
 * manually specify IDs and
 *  interlinks for Tasks that simply proceed to the next task in a sequence.
 *  <P>
 *  Processes follow all the standard rules for encoding as {@link com.smartgwt.client.docs.ComponentXML}, however,
 * note that the &lt;Process&gt; tag allows any kind of {@link com.smartgwt.client.util.workflow.ProcessElement} (tasks,
 * decisions
 *  and sequences) to appear as a direct subelement of the &lt;Process&gt; tag without the need
 *  for an intervening &lt;elements&gt; or &lt;sequences&gt; tag.  The example below
 *  demonstrates this shorthand format.
 *  <pre>
 *  &lt;Process ID="<i>processId</i>"&gt;
 *      &lt;DSRequestTask ID="<i>dsRequestTaskId</i>" nextElement="<i>sequenceId</i>" ..&gt;
 *          &lt;inputFieldList&gt;
 *              &lt;value&gt;order.countryName&lt;/value&gt;
 *          &lt;/inputFieldList&gt;
 *          &lt;outputFieldList&gt;
 *              &lt;value&gt;order.countryName&lt;/value&gt;
 *              &lt;value&gt;order.continent&lt;/value&gt;
 *          &lt;outputFieldList&gt;
 *      &lt;/DSRequestTask&gt;
 *      &lt;sequence ID="<i>sequenceId</i>" &gt;
 *          &lt;StateTask ../&gt;
 *          &lt;StateTask ../&gt;
 *          &lt;StateTask ../&gt;
 *          &lt;StateTask nextElement="<i>userTaskId</i>" ../&gt;
 *      &lt;/sequence&gt;
 *      &lt;UserTask ID="<i>userTaskId</id>" ../&gt;
 *      ...
 *  &lt;/Process&gt;
 *  </pre>
 *  <b>NOTE:</b> you must load the standard DataBinding module before you can use <code>Process</code>.
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("Process")
public class Process extends BaseClass implements com.smartgwt.client.util.workflow.events.HasFinishedHandlers, com.smartgwt.client.util.workflow.events.HasTraceElementHandlers {

    public static Process getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        BaseClass obj = BaseClass.getRef(jsObj);
        if(obj != null) {
            return (Process) obj;
        } else {
            return new Process(jsObj);
        }
    }

    public void setJavaScriptObject(JavaScriptObject jsObj) {
        internalSetID(jsObj);
        JSOHelper.setObjectAttribute(jsObj, SC.REF, this);
        JSOHelper.setObjectAttribute(jsObj, SC.MODULE, BeanFactory.getSGWTModule());
        if (!JSOHelper.isScClassInstance(jsObj)) {
            setConfig(jsObj);
            return;
        }
        JSOHelper.setObjectAttribute(getConfig(), SC.REF, this);
        JSOHelper.setObjectAttribute(getConfig(), SC.MODULE, BeanFactory.getSGWTModule());
        this.jsObj = jsObj;
        onBind();
    }
        


    public Process(){
        scClassName = "Process";
    }

    public Process(JavaScriptObject jsObj){
        scClassName = "Process";
        setJavaScriptObject(jsObj);
    }

    public native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.core.BaseClass::getConfig()();
        var scClassName = this.@com.smartgwt.client.core.BaseClass::scClassName;
        return $wnd.isc[scClassName].create(config);
    }-*/;

    private JavaScriptObject jsObj;
    
    @Override
    public boolean isCreated(){
        return this.jsObj != null;
    }

    @Override
    public JavaScriptObject getJsObj(){
        return this.jsObj;
    }

    @Override
    public JavaScriptObject getOrCreateJsObj() {
        if (!isCreated()) {
            this.jsObj = createJsObj();
            doInit();
        }
        return this.jsObj;
    }


    // ********************* Static Attributes ***********************

    // ********************* Properties / Attributes ***********************
    

    /**
     * Identifier of canvas where UI elements created by using {@link com.smartgwt.client.util.workflow.UserTask#getInlineView
     * inline view} property should be added using addMember.
     *
     * @param containerId New containerId value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Process Process} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.GlobalId GlobalId 
     */
    public Process setContainerId(String containerId) {
        return (Process)setAttribute("containerId", containerId, true);
    }

    /**
     * Identifier of canvas where UI elements created by using {@link com.smartgwt.client.util.workflow.UserTask#getInlineView
     * inline view} property should be added using addMember.
     *
     * @return Current containerId value. Default value is null
     * @see com.smartgwt.client.docs.GlobalId GlobalId 
     */
    public String getContainerId()  {
        return getAttributeAsString("containerId");
    }
    

    /**
     * Name of the default Process subclass to use when auto-constructing plain Objects that are detected as Processes (see
     * heuristic on {@link com.smartgwt.client.util.workflow.Process#getDefaultTaskConstructor defaultTaskConstructor})
     *
     * @param defaultProcessConstructor New defaultProcessConstructor value. Default value is "Process"
     * @return {@link com.smartgwt.client.util.workflow.Process Process} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Process setDefaultProcessConstructor(String defaultProcessConstructor)  throws IllegalStateException {
        return (Process)setAttribute("defaultProcessConstructor", defaultProcessConstructor, false);
    }

    /**
     * Name of the default Process subclass to use when auto-constructing plain Objects that are detected as Processes (see
     * heuristic on {@link com.smartgwt.client.util.workflow.Process#getDefaultTaskConstructor defaultTaskConstructor})
     *
     * @return Current defaultProcessConstructor value. Default value is "Process"
     */
    public String getDefaultProcessConstructor()  {
        return getAttributeAsString("defaultProcessConstructor");
    }
    

    /**
     * Name of the default Task subclass to use when auto-constructing plain Objects found
     * in collections that accept Tasks (for example {@link com.smartgwt.client.util.workflow.Process#getTasks
     * CoTProcess.tasks}, sequence members, etc).
     *  <p>
     *  This is consulted only when the element is a plain Object (not already constructed)
     *  and does not declare its own <code>_constructor</code>. If <code>defaultTaskConstructor</code>
     *  is unset for a given <code>Process</code>, the engine uses {@link com.smartgwt.client.util.workflow.ScriptTask}.
     *  <p>
     *  <h4> Task vs nested subprocess heuristic</h4>
     *  Nested Processes are often used to encapsulate a sub-workflow.  When auto-constructing,
     *  the engine uses a heuristic to auto-detect the developer's intent to create a nested Process, as
     *  follows:
     *  <p>
     *  <ol>
     *  <li>If the element is already a constructed instance (Task or StartProcessTask), use it as-is.</li>
     *  <li>If the element declares <code>_constructor</code>, use that class directly.</li>
     *  <li><b>If the element has a <code>process</code> property</b>:
     *    <ol style="list-style-type: lower-alpha; margin-top:4px">
     * <li>Construct a {@link com.smartgwt.client.util.workflow.StartProcessTask StartProcessTask} for the element itself
     * (unless
     *          the object declares its own <code>_constructor</code> to override this).</li>
     *      <li>If <code>process</code> is a plain Object (not already constructed), auto-instantiate it
     * as a Process using {@link com.smartgwt.client.util.workflow.Process#getDefaultProcessConstructor
     * defaultProcessConstructor} and assign the instance to
     *          <code>task.process</code>.</li>
     *      <li>If <code>process</code> is already a Process instance, assign it directly to
     *          <code>task.process</code>.</li>
     *    </ol>
     *  </li>
     * <li>Otherwise, construct it as a Task using {@link com.smartgwt.client.util.workflow.Process#getDefaultTaskConstructor
     * defaultTaskConstructor} if set,
     *      otherwise {@link com.smartgwt.client.util.workflow.Task Task}.</li>
     *  </ol>
     *  <p>
     *  <h4>Examples</h4>
     *  <pre>
     *  // Plain objects default to CoTTask (AI module) unless specified otherwise.
     *  isc.Process.create({
     *    defaultTaskConstructor: "CoTTask",
     *    defaultProcessConstructor: "CoTProcess",
     *    tasks: [
     *      { ID:"decide",  title:"Decide Next" },   // -> CoTTask
     * 
     *      // Nested process via wrapper: becomes StartProcessTask; its .process is auto-created.
     *      { ID:"subflow",
     *        process: {
     *          ID:"p1",
     *          tasks:[ { ID:"leaf", title:"Leaf step" } ] // auto-instantiated as CoTProcess
     *        }
     *      },
     * 
     *      { _constructor:"MyTask", ID:"apply" }    // -> MyTask
     *    ]
     *  });
     *  </pre>
     *
     * @param defaultTaskConstructor New defaultTaskConstructor value. Default value is "ScriptTask"
     * @return {@link com.smartgwt.client.util.workflow.Process Process} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Process setDefaultTaskConstructor(String defaultTaskConstructor)  throws IllegalStateException {
        return (Process)setAttribute("defaultTaskConstructor", defaultTaskConstructor, false);
    }

    /**
     * Name of the default Task subclass to use when auto-constructing plain Objects found
     * in collections that accept Tasks (for example {@link com.smartgwt.client.util.workflow.Process#getTasks
     * CoTProcess.tasks}, sequence members, etc).
     *  <p>
     *  This is consulted only when the element is a plain Object (not already constructed)
     *  and does not declare its own <code>_constructor</code>. If <code>defaultTaskConstructor</code>
     *  is unset for a given <code>Process</code>, the engine uses {@link com.smartgwt.client.util.workflow.ScriptTask}.
     *  <p>
     *  <h4> Task vs nested subprocess heuristic</h4>
     *  Nested Processes are often used to encapsulate a sub-workflow.  When auto-constructing,
     *  the engine uses a heuristic to auto-detect the developer's intent to create a nested Process, as
     *  follows:
     *  <p>
     *  <ol>
     *  <li>If the element is already a constructed instance (Task or StartProcessTask), use it as-is.</li>
     *  <li>If the element declares <code>_constructor</code>, use that class directly.</li>
     *  <li><b>If the element has a <code>process</code> property</b>:
     *    <ol style="list-style-type: lower-alpha; margin-top:4px">
     * <li>Construct a {@link com.smartgwt.client.util.workflow.StartProcessTask StartProcessTask} for the element itself
     * (unless
     *          the object declares its own <code>_constructor</code> to override this).</li>
     *      <li>If <code>process</code> is a plain Object (not already constructed), auto-instantiate it
     * as a Process using {@link com.smartgwt.client.util.workflow.Process#getDefaultProcessConstructor
     * defaultProcessConstructor} and assign the instance to
     *          <code>task.process</code>.</li>
     *      <li>If <code>process</code> is already a Process instance, assign it directly to
     *          <code>task.process</code>.</li>
     *    </ol>
     *  </li>
     * <li>Otherwise, construct it as a Task using {@link com.smartgwt.client.util.workflow.Process#getDefaultTaskConstructor
     * defaultTaskConstructor} if set,
     *      otherwise {@link com.smartgwt.client.util.workflow.Task Task}.</li>
     *  </ol>
     *  <p>
     *  <h4>Examples</h4>
     *  <pre>
     *  // Plain objects default to CoTTask (AI module) unless specified otherwise.
     *  isc.Process.create({
     *    defaultTaskConstructor: "CoTTask",
     *    defaultProcessConstructor: "CoTProcess",
     *    tasks: [
     *      { ID:"decide",  title:"Decide Next" },   // -> CoTTask
     * 
     *      // Nested process via wrapper: becomes StartProcessTask; its .process is auto-created.
     *      { ID:"subflow",
     *        process: {
     *          ID:"p1",
     *          tasks:[ { ID:"leaf", title:"Leaf step" } ] // auto-instantiated as CoTProcess
     *        }
     *      },
     * 
     *      { _constructor:"MyTask", ID:"apply" }    // -> MyTask
     *    ]
     *  });
     *  </pre>
     *
     * @return Current defaultTaskConstructor value. Default value is "ScriptTask"
     */
    public String getDefaultTaskConstructor()  {
        return getAttributeAsString("defaultTaskConstructor");
    }
    

    /**
     * When {@link com.smartgwt.client.util.workflow.Process#getDefaultWaitFor defaultWaitFor} or task {@link
     * com.smartgwt.client.util.workflow.ProcessElement#getWaitFor waitFor} are set to "duration", how long should the wait be
     * before starting the task? A task can override the default value with task {@link
     * com.smartgwt.client.util.workflow.ProcessElement#getWaitDuration waitDuration}.
     *
     * @param defaultWaitDuration New defaultWaitDuration value. Default value is "300"
     * @return {@link com.smartgwt.client.util.workflow.Process Process} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Process setDefaultWaitDuration(Integer defaultWaitDuration)  throws IllegalStateException {
        return (Process)setAttribute("defaultWaitDuration", defaultWaitDuration, false);
    }

    /**
     * When {@link com.smartgwt.client.util.workflow.Process#getDefaultWaitFor defaultWaitFor} or task {@link
     * com.smartgwt.client.util.workflow.ProcessElement#getWaitFor waitFor} are set to "duration", how long should the wait be
     * before starting the task? A task can override the default value with task {@link
     * com.smartgwt.client.util.workflow.ProcessElement#getWaitDuration waitDuration}.
     *
     * @return Current defaultWaitDuration value. Default value is "300"
     */
    public Integer getDefaultWaitDuration()  {
        return getAttributeAsInt("defaultWaitDuration");
    }
    

    /**
     * Condition to wait for before each task is executed. Task {@link
     * com.smartgwt.client.util.workflow.ProcessElement#getWaitFor waitFor} can be specified for individual tasks to override
     * this default. <P> For a value of "duration", the delay time is set by {@link
     * com.smartgwt.client.util.workflow.Process#getDefaultWaitDuration defaultWaitDuration} and can be overridden by a task
     * {@link com.smartgwt.client.util.workflow.ProcessElement#getWaitDuration waitDuration}. <P> Note that if
     * <code>defaultWaitFor</code> is set to "systemDone" and a task overrides it with <code>waitFor</code> "locator", the
     * default "systemDone" is not performed. To apply both, as might be desired, use task <code>waitFor</code>
     * "locatorAndSystemDone". <p> A <code>defaultWaitFor</code> value of "locator" or "locatorAndSystemDone" is not valid.
     *
     * @param defaultWaitFor New defaultWaitFor value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Process Process} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Process setDefaultWaitFor(WaitForType defaultWaitFor)  throws IllegalStateException {
        return (Process)setAttribute("defaultWaitFor", defaultWaitFor == null ? null : defaultWaitFor.getValue(), false);
    }

    /**
     * Condition to wait for before each task is executed. Task {@link
     * com.smartgwt.client.util.workflow.ProcessElement#getWaitFor waitFor} can be specified for individual tasks to override
     * this default. <P> For a value of "duration", the delay time is set by {@link
     * com.smartgwt.client.util.workflow.Process#getDefaultWaitDuration defaultWaitDuration} and can be overridden by a task
     * {@link com.smartgwt.client.util.workflow.ProcessElement#getWaitDuration waitDuration}. <P> Note that if
     * <code>defaultWaitFor</code> is set to "systemDone" and a task overrides it with <code>waitFor</code> "locator", the
     * default "systemDone" is not performed. To apply both, as might be desired, use task <code>waitFor</code>
     * "locatorAndSystemDone". <p> A <code>defaultWaitFor</code> value of "locator" or "locatorAndSystemDone" is not valid.
     *
     * @return Current defaultWaitFor value. Default value is null
     */
    public WaitForType getDefaultWaitFor()  {
        return EnumUtil.getEnum(WaitForType.values(), getAttribute("defaultWaitFor"));
    }
    

    /**
     * Elements involved in this Process.  You can also group elements into {@link
     * com.smartgwt.client.util.workflow.Process#getSequences sequences} to reduce the need to explicitly define IDs for
     * elements and interlink them.
     *
     * @param elements New elements value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Process Process} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Process setElements(ProcessElement... elements)  throws IllegalStateException {
        return (Process)setAttribute("elements", elements, false);
    }
    

    /**
     * Enable mock mode on the workflow? By default, this setting does nothing but is available for individual tasks to trigger
     * special action. For example, a task that would normally fail outside of its target environment can take an alternative
     * action during testing. <p> mockMode can also be enabled or disabled for an individual task with {@link
     * com.smartgwt.client.util.workflow.ProcessElement#getMockMode ProcessElement.mockMode}.
     *
     * @param mockMode New mockMode value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Process Process} instance, for chaining setter calls
     */
    public Process setMockMode(Boolean mockMode) {
        return (Process)setAttribute("mockMode", mockMode, true);
    }

    /**
     * Enable mock mode on the workflow? By default, this setting does nothing but is available for individual tasks to trigger
     * special action. For example, a task that would normally fail outside of its target environment can take an alternative
     * action during testing. <p> mockMode can also be enabled or disabled for an individual task with {@link
     * com.smartgwt.client.util.workflow.ProcessElement#getMockMode ProcessElement.mockMode}.
     *
     * @return Current mockMode value. Default value is null
     */
    public Boolean getMockMode()  {
        return getAttributeAsBoolean("mockMode");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.Canvas#getID Canvas.ID} of the component that manages "rule context" for which this
     * process participates. The rule context can be used in {@link com.smartgwt.client.docs.TaskInputExpression
     * taskInputExpression}.
     *
     * @param ruleScope New ruleScope value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Process Process} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.widgets.Canvas#setRuleScope
     */
    public Process setRuleScope(String ruleScope)  throws IllegalStateException {
        return (Process)setAttribute("ruleScope", ruleScope, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.Canvas#getID Canvas.ID} of the component that manages "rule context" for which this
     * process participates. The rule context can be used in {@link com.smartgwt.client.docs.TaskInputExpression
     * taskInputExpression}.
     *
     * @return Current ruleScope value. Default value is null
     * @see com.smartgwt.client.widgets.Canvas#getRuleScope
     */
    public String getRuleScope()  {
        return getAttributeAsString("ruleScope");
    }
    

    /**
     * Sequences of ProcessElements.  By defining a sequences of elements you can make the
     *  {@link com.smartgwt.client.util.workflow.ProcessElement#getNextElement ProcessElement.nextElement} implicit.
     *  <P>
     * For a simple sequence of tasks, consider using {@link com.smartgwt.client.util.workflow.Process#getTasks tasks} instead.
     *  <P>
     *  
     *  
     *  Example of using sequences:
     *  <pre>
     *  Process process = new Process();
     *  process.setStartElement("firstSequence");
     *  ProcessSequence innerSequence = new ProcessSequence(incTask, add2Task, incTask);
     *  process.setSequences(
     *      new ProcessSequence("firstSequence", dsRequestTask, multiDecisionTask),
     *      new ProcessSequence("errorFlow", failureTask, userNotifyTask)
     *  );
     *  // standalone process elements not part of sequences
     *  process.setElements(new DSRequestTask(){...});
     *  Record state = new Record();
     *  state.setAttribute("someField", "someValue");
     *  process.setState(state);
     *  process.start();
     *  </pre>
     * 
     *
     * @param sequences New sequences value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Process Process} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Process setSequences(ProcessSequence... sequences)  throws IllegalStateException {
        return (Process)setAttribute("sequences", sequences, false);
    }

    /**
     * Sequences of ProcessElements.  By defining a sequences of elements you can make the
     *  {@link com.smartgwt.client.util.workflow.ProcessElement#getNextElement ProcessElement.nextElement} implicit.
     *  <P>
     * For a simple sequence of tasks, consider using {@link com.smartgwt.client.util.workflow.Process#getTasks tasks} instead.
     *  <P>
     *  
     *  
     *  Example of using sequences:
     *  <pre>
     *  Process process = new Process();
     *  process.setStartElement("firstSequence");
     *  ProcessSequence innerSequence = new ProcessSequence(incTask, add2Task, incTask);
     *  process.setSequences(
     *      new ProcessSequence("firstSequence", dsRequestTask, multiDecisionTask),
     *      new ProcessSequence("errorFlow", failureTask, userNotifyTask)
     *  );
     *  // standalone process elements not part of sequences
     *  process.setElements(new DSRequestTask(){...});
     *  Record state = new Record();
     *  state.setAttribute("someField", "someValue");
     *  process.setState(state);
     *  process.start();
     *  </pre>
     * 
     *
     * @return Current sequences value. Default value is null
     */
    public ProcessSequence[] getSequences()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfProcessSequence(getAttributeAsJavaScriptObject("sequences"));
    }
    

    /**
     * The ID of either a {@link com.smartgwt.client.util.workflow.Process#getSequences sequence} or an {@link
     * com.smartgwt.client.util.workflow.Process#getElements element} which should be the starting point of the process.  If
     * not specified, the first sequence is chosen, or if there are no sequences, the first element. - log a warning and do
     * nothing if there are neither sequences or elements
     *
     * @param startElement New startElement value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Process Process} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Process setStartElement(String startElement)  throws IllegalStateException {
        return (Process)setAttribute("startElement", startElement, false);
    }

    /**
     * The ID of either a {@link com.smartgwt.client.util.workflow.Process#getSequences sequence} or an {@link
     * com.smartgwt.client.util.workflow.Process#getElements element} which should be the starting point of the process.  If
     * not specified, the first sequence is chosen, or if there are no sequences, the first element. - log a warning and do
     * nothing if there are neither sequences or elements
     *
     * @return Current startElement value. Default value is null
     */
    public String getStartElement()  {
        return getAttributeAsString("startElement");
    }
    

    /**
     * Current state of a process.  As with Records in general, any field of a Record may contain a nested Record or Array of
     * Records, so the process state is essentially a hierarchical data structure. <p> <h4>Transient state</h4> In addition to
     * the explicit process state there is a "transient state." The transient state represents the complete output of each of
     * the last tasks of each type within the current process execution. This allows easy reference to the previous task output
     * with {@link com.smartgwt.client.docs.TaskInputExpression taskInputExpressions}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Set process state for current process
     *
     * @param state the new process state. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Process Process} instance, for chaining setter calls
     */
    public Process setState(Record state) {
        return (Process)setAttribute("state", state == null ? null : state.getJsObj(), true);
    }

    /**
     * Current state of a process.  As with Records in general, any field of a Record may contain a nested Record or Array of
     * Records, so the process state is essentially a hierarchical data structure. <p> <h4>Transient state</h4> In addition to
     * the explicit process state there is a "transient state." The transient state represents the complete output of each of
     * the last tasks of each type within the current process execution. This allows easy reference to the previous task output
     * with {@link com.smartgwt.client.docs.TaskInputExpression taskInputExpressions}.
     *
     * @return Current state value. Default value is null
     */
    public Record getState()  {
        return Record.getOrCreateRef(getAttributeAsJavaScriptObject("state"));
    }
    

    /**
     * If set to true, the process will not allow any intermediate state to be set via {@link
     * com.smartgwt.client.util.workflow.Process#setStateVariable setStateVariable()} that is not explicitly defined first.
     *
     * @param strictPaths New strictPaths value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Process Process} instance, for chaining setter calls
     */
    public Process setStrictPaths(Boolean strictPaths) {
        return (Process)setAttribute("strictPaths", strictPaths, true);
    }

    /**
     * If set to true, the process will not allow any intermediate state to be set via {@link
     * com.smartgwt.client.util.workflow.Process#setStateVariable setStateVariable()} that is not explicitly defined first.
     *
     * @return Current strictPaths value. Default value is null
     */
    public Boolean getStrictPaths()  {
        return getAttributeAsBoolean("strictPaths");
    }
    

    /**
     * Convenience form of declaring a single, linear sequence of tasks for this process. Functionally equivalent to providing
     * a one-element {@link com.smartgwt.client.util.workflow.Process#getSequences sequences} Array whose first (and only)
     * member is this list. <p> If {@link com.smartgwt.client.util.workflow.Process#getSequences sequences} is not provided,
     * <code>process.tasks</code> becomes the sole sequence. If both are provided, <code>process.tasks</code> is inserted as
     * the first sequence, followed by the declared <code>sequences</code>. <p> Each entry may be: <ul> <li>A plain Object,
     * which will be auto-instantiated as a Task or a     {@link com.smartgwt.client.util.workflow.StartProcessTask} (wrapping
     * a nested Process) using the heuristic documented     on {@link
     * com.smartgwt.client.util.workflow.Process#getDefaultTaskConstructor defaultTaskConstructor} / {@link
     * com.smartgwt.client.util.workflow.Process#getDefaultProcessConstructor defaultProcessConstructor}.</li> <li>An already
     * constructed {@link com.smartgwt.client.util.workflow.ProcessElement ProcessElement} (or subclass) instance.</li> </ul>
     *
     * @param tasks New tasks value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Process Process} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Process setTasks(ProcessElement... tasks)  throws IllegalStateException {
        return (Process)setAttribute("tasks", tasks, false);
    }
    

    /**
     * Context object to be passed to {@link com.smartgwt.client.util.workflow.Process#addTraceElementHandler
     * Process.traceElement()} during process execution.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param traceContext New traceContext value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Process Process} instance, for chaining setter calls
     */
    public Process setTraceContext(Map traceContext) {
        return (Process)setAttribute("traceContext", traceContext, true);
    }

    /**
     * Context object to be passed to {@link com.smartgwt.client.util.workflow.Process#addTraceElementHandler
     * Process.traceElement()} during process execution.
     *
     * @return Current traceContext value. Default value is null
     */
    public Map getTraceContext()  {
        return getAttributeAsMap("traceContext");
    }
    

    /**
     * If wizard is set then current workflow will be handled as wizard. Every userTask will hide associated form after user
     * finished step.
     *
     * @param wizard New wizard value. Default value is false
     * @return {@link com.smartgwt.client.util.workflow.Process Process} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Process setWizard(Boolean wizard)  throws IllegalStateException {
        return (Process)setAttribute("wizard", wizard, false);
    }

    /**
     * If wizard is set then current workflow will be handled as wizard. Every userTask will hide associated form after user
     * finished step.
     *
     * @return Current wizard value. Default value is false
     */
    public Boolean getWizard()  {
        Boolean result = getAttributeAsBoolean("wizard");
        return result == null ? false : result;
    }
    

    // ********************* Methods ***********************
	/**
     * Notification hook invoked after a Task's outputs have been committed to state and history recorded, but before routing
     * to the next element. Use for ancillary effects such as logging, metrics, or scheduling background work. This hook cannot
     * veto the commit; to inject validation or replace outputs, use {@link
     * com.smartgwt.client.util.workflow.Process#beforeTaskCommit beforeTaskCommit()}.
     * @param task The Task that just committed.
     * @param outputs The committed outputs (if any).
     */
    public native void afterTaskCommit(Task task, Map outputs) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "afterTaskCommit", "Task,Map");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.afterTaskCommit(task == null ? null : task.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()(), outputs == null ? null : @com.smartgwt.client.util.JSOHelper::convertMapToJavascriptObject(Ljava/util/Map;)(outputs));
    }-*/;

	/**
     * Apply the state updates specified by {@link com.smartgwt.client.util.workflow.Process#setStateVariable
     * setStateVariable()} to the process state.
     *  <p>
     * <code>stateUpdates</code> is a mapping from a {@link com.smartgwt.client.docs.SetterPath setterPath} to a
     * ${TaskInputExpression}
     *  or other value.
     *  <p>
     *  <code>stateUpdates</code> can declare nested structures, and <code>TaskInputExpressions</code> are allowed
     *  anywhere in the nested declaration.
     *  <pre>
     *        {
     *                "currentDS.fields[]" : "$output"
     *                "lastCreatedField" : {
     *                      "fromTask" : "Add Field",
     *                      "fieldName" : "$output.name"
     *                }
     *        }
     *  </pre>
     * In this example, the output is appended to the "currentDS.fields" array in {@link
     * com.smartgwt.client.util.workflow.Process#getState state} and
     *  an object called "lastCreatedField" is created in <code>process.state.lastCreatedField</code>.
     * 
     * 
     * @param stateUpdates state updates to apply
     */
    public native void applyStateUpdates(Map stateUpdates) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "applyStateUpdates", "Map");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.applyStateUpdates(stateUpdates == null ? null : @com.smartgwt.client.util.JSOHelper::convertMapToJavascriptObject(Ljava/util/Map;)(stateUpdates));
    }-*/;

    /**
     * See {@link Process#applyStateUpdates(Map, Map, Boolean) applyStateUpdates()}
     */
    public void applyStateUpdates(Map stateUpdates, Map inputRecord){
        applyStateUpdates(stateUpdates, inputRecord, null);
    }

	/**
     * Apply the state updates specified by {@link com.smartgwt.client.util.workflow.Process#setStateVariable
     * setStateVariable()} to the process state.
     *  <p>
     * <code>stateUpdates</code> is a mapping from a {@link com.smartgwt.client.docs.SetterPath setterPath} to a
     * ${TaskInputExpression}
     *  or other value.
     *  <p>
     *  <code>stateUpdates</code> can declare nested structures, and <code>TaskInputExpressions</code> are allowed
     *  anywhere in the nested declaration.
     *  <pre>
     *        {
     *                "currentDS.fields[]" : "$output"
     *                "lastCreatedField" : {
     *                      "fromTask" : "Add Field",
     *                      "fieldName" : "$output.name"
     *                }
     *        }
     *  </pre>
     * In this example, the output is appended to the "currentDS.fields" array in {@link
     * com.smartgwt.client.util.workflow.Process#getState state} and
     *  an object called "lastCreatedField" is created in <code>process.state.lastCreatedField</code>.
     * 
     * 
     * @param stateUpdates state updates to apply
     * @param inputRecord record to use as the source for any $input {@link com.smartgwt.client.docs.TaskInputExpression}                         
     *   properties.
     * @param strict if true, the paths must exist in the state to be set. Otherwise,                           the paths will be created if
     * not existing. Defaults to                           <code>process.strictPaths</code> when null.
     */
    public native void applyStateUpdates(Map stateUpdates, Map inputRecord, Boolean strict) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "applyStateUpdates", "Map,Map,Boolean");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.applyStateUpdates(stateUpdates == null ? null : @com.smartgwt.client.util.JSOHelper::convertMapToJavascriptObject(Ljava/util/Map;)(stateUpdates), inputRecord == null ? null : @com.smartgwt.client.util.JSOHelper::convertMapToJavascriptObject(Ljava/util/Map;)(inputRecord), strict == null ? null : strict.@java.lang.Boolean::booleanValue()());
    }-*/;
	
	/**
     * Override point invoked after a Task completes successfully, but before any of the Task's outputs are committed to {@link
     * com.smartgwt.client.util.workflow.Process#getState state} and before next-task routing proceeds. Use this to: <ul>
     * <li>Inject global validation and force a retry by returning errors.</li> <li>Augment or replace the Task's outputs prior
     * to commit.</li> <li>Apply additional declarative updates to {@link com.smartgwt.client.util.workflow.Process#getState
     * state}.</li> </ul> Return a {@link com.smartgwt.client.util.workflow.TaskResultModifications} object to influence commit
     * behavior. If you return nothing, the engine proceeds normally.
     * @param task The Task or sub-Process that just completed.
     * @param outputs The Task's outputs
     *
     * @return Optional result to modify commit behavior.
     */
    public native TaskResultModifications beforeTaskCommit(ProcessElement task, Map outputs) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "beforeTaskCommit", "ProcessElement,Map");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.beforeTaskCommit(task == null ? null : task.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()(), outputs == null ? null : @com.smartgwt.client.util.JSOHelper::convertMapToJavascriptObject(Ljava/util/Map;)(outputs));
        if(ret == null) return null;
        return @com.smartgwt.client.util.workflow.TaskResultModifications::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

    /**
     * Add a finished handler.
     * <p>
     * StringMethod called when a process completes, meaning the process executes a  ProcessElement with no next element.
     *
     * @param handler the finished handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addFinishedHandler(com.smartgwt.client.util.workflow.events.FinishedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.util.workflow.events.ProcessFinishedEvent.getType()) == 0) setupFinishedEvent();
        return doAddHandler(handler, com.smartgwt.client.util.workflow.events.ProcessFinishedEvent.getType());
    }

    private native void setupFinishedEvent() /*-{
        var obj;
        var selfJ = this;
        var finished = $entry(function(){
            var param = {"_this": this, "state" : arguments[0]};
                var event = @com.smartgwt.client.util.workflow.events.ProcessFinishedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
                selfJ.@com.smartgwt.client.core.BaseClass::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
                selfJ.@com.smartgwt.client.util.workflow.Process::handleTearDownFinishedEvent()();
            });
        if(this.@com.smartgwt.client.core.BaseClass::isCreated()()) {
            obj = this.@com.smartgwt.client.core.BaseClass::getJsObj()();
            obj.addProperties({finished:  finished              });
        } else {
            obj = this.@com.smartgwt.client.core.BaseClass::getConfig()();
            obj.finished =  finished             ;
        }
    }-*/;

    private void handleTearDownFinishedEvent() {
        if (getHandlerCount(com.smartgwt.client.util.workflow.events.ProcessFinishedEvent.getType()) == 0) tearDownFinishedEvent();
    }

    private native void tearDownFinishedEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.core.BaseClass::isCreated()()) {
            obj = this.@com.smartgwt.client.core.BaseClass::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.core.BaseClass::getConfig()();
        }
        if (obj && obj.hasOwnProperty("finished")) delete obj.finished;
    }-*/;

	/**
     * Returns a list of unique global IDs that are referenced by this process. <p> List is assembled by calling {@link
     * com.smartgwt.client.util.workflow.ProcessElement#getComponentReferences ProcessElement.getComponentReferences()} for
     * each task in the workflow and filtering the list to the unique component IDs.
     *
     * @return array of component IDs that are referenced by this process
     */
    public native String[] getComponentReferences() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getComponentReferences", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getComponentReferences();
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfString(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Retrieve a {@link com.smartgwt.client.util.workflow.ProcessElement} by its ID
     * @param ID id of the process element
     *
     * @return the indicated process element, or null if no such element exists
     */
    public native ProcessElement getElement(String ID) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getElement", "String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getElement(ID);
        if(ret == null) return null;
        return @com.smartgwt.client.util.workflow.ProcessElement::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Returns the task output of the last task executed. More commonly a {@link com.smartgwt.client.docs.TaskInputExpression}
     * property is used (see {@link com.smartgwt.client.util.workflow.ProcessElement#getDynamicValue
     * ProcessElement.getDynamicValue()}).
     *
     * @return the last task output or null if none is found
     */
    public native Object getLastTaskOutput() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getLastTaskOutput", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getLastTaskOutput();
        return $wnd.SmartGWT.convertToJavaType(ret);
    }-*/;

	/**
     * Returns the task output of the last task executed. More commonly a {@link com.smartgwt.client.docs.TaskInputExpression}
     * property is used (see {@link com.smartgwt.client.util.workflow.ProcessElement#getDynamicValue
     * ProcessElement.getDynamicValue()}).
     * @param taskType the optional task type to lookup in last task output
     *
     * @return the last task output or null if none is found
     */
    public native Object getLastTaskOutput(String taskType) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getLastTaskOutput", "String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getLastTaskOutput(taskType);
        return $wnd.SmartGWT.convertToJavaType(ret);
    }-*/;
	
	/**
     * Returns the process description as HTML.
     *
     * @return the process description as HTML
     */
    public native String getProcessDescription() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getProcessDescription", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getProcessDescription();
        return ret;
    }-*/;

	/**
     * Returns a variable value from the {@link com.smartgwt.client.util.workflow.Process#getState process state}. Values can
     * be written into the process state by {@link com.smartgwt.client.util.workflow.Process#setStateVariable
     * setStateVariable()}, setting {@link com.smartgwt.client.util.workflow.ProcessElement#getBindOutput
     * ProcessElement.bindOutput}, or various task output settings (See {@link com.smartgwt.client.docs.TaskIO}.)
     * @param stateVariablePath path to variable in process state to set.                                   segments are separated by a decimal point
     * (.)
     *
     * @return the value found at the path
     */
    public native Object getStateVariable(String stateVariablePath) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getStateVariable", "String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getStateVariable(stateVariablePath);
        return $wnd.SmartGWT.convertToJavaType(ret);
    }-*/;

	/**
     * Takes the {@link com.smartgwt.client.util.workflow.Process#getLastTaskOutput last task output} and sets it as the {@link
     * com.smartgwt.client.util.workflow.Process#setTaskOutput task output} for the <code>task</code>. <p> This method is not
     * just a shortcut to set output of a pass-thru task, but it also records the correct schema of the passed-thru output so
     * it can be quickly looked up.
     * @param task the workflow task setting the output (i.e. this)
     */
    public native void passThruTaskOutput(ProcessElement task) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "passThruTaskOutput", "ProcessElement");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.passThruTaskOutput(task == null ? null : task.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()());
    }-*/;

	/**
     * Reset process to its initial state, so process can be started again.
     */
    public native void reset() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "reset", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.reset();
    }-*/;

	/**
     * Reset process to its initial state, so process can be started again.
     * @param state new state of the process
     */
    public native void reset(Record state) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "reset", "Record");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.reset(state == null ? null : state.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;
	
	/**
     * Execute a single task in isolation for testing. The process must not already be running. This method invokes the
     * specified task once without advancing the workflow. <p> Typically used for automated tests of complex tasks, including
     * those involving AI. <p> Providing <code>priorTaskOutputs</code> means that {@link
     * com.smartgwt.client.docs.TaskInputExpression TaskInputExpressions} and other forms of {@link
     * com.smartgwt.client.util.workflow.Task#getInputs Task.inputs} declarative inputs will draw from the provided data.  For
     * example, $outputs.propertyName used as an expression would refer to the value under <code>propertyName</code> in the
     * provided priorTaskOutputs object. <p> If <code>state</code> is supplied, it is used as the temporary process state for
     * this call (the original state is preserved).  If <code>ruleScope</code> is supplied, it replaces the normal {@link
     * com.smartgwt.client.util.workflow.Process#getRuleScope ruleScope determination} for this invocation only. <p> When the
     * task completes, <code>callback</code> (a  Callbacks.RunTaskCallback()) is invoked with the task, process, and any
     * outputs the task produced (for example, a CoTTask?s <code>$outputs</code>).
     * @param taskID ID of the task to execute.
     * @param callback Completion callback.
     * @param priorTaskOutputs Optional object to simulate outputs from a prior task        (see behavior above).
     * @param state Optional state fixture to use for this call.
     * @param ruleContext Optional override ruleContext for expression evaluation.
     */
    public native void runTask(String taskID, RunTaskCallback callback, Map priorTaskOutputs, Map state, Map ruleContext) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "runTask", "String,RunTaskCallback,Map,Map,Map");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.runTask(taskID, 
			$entry( function(task, process, outputs) { 
				if(callback!=null) callback.@com.smartgwt.client.util.workflow.RunTaskCallback::execute(Lcom/smartgwt/client/util/workflow/Task;Lcom/smartgwt/client/util/workflow/Process;Ljava/util/Map;)(
					task != null ? @com.smartgwt.client.util.workflow.Task::new(Lcom/google/gwt/core/client/JavaScriptObject;)(task) : null, 
					process != null ? @com.smartgwt.client.util.workflow.Process::new(Lcom/google/gwt/core/client/JavaScriptObject;)(process) : null, 
					outputs != null ? @com.smartgwt.client.util.JSOHelper::convertToMap(Lcom/google/gwt/core/client/JavaScriptObject;)(outputs) : null
				);
			}), priorTaskOutputs == null ? null : @com.smartgwt.client.util.JSOHelper::convertMapToJavascriptObject(Ljava/util/Map;)(priorTaskOutputs), state == null ? null : @com.smartgwt.client.util.JSOHelper::convertMapToJavascriptObject(Ljava/util/Map;)(state), ruleContext == null ? null : @com.smartgwt.client.util.JSOHelper::convertMapToJavascriptObject(Ljava/util/Map;)(ruleContext));
    }-*/;

	/**
     * Sets the task ID of the next task to execute after the current task finishes. If the task is not found or
     * <code>null</code> is passed as the nextElement, the current process will be terminated instead.
     */
    public native void setNextElement() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setNextElement", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.setNextElement();
    }-*/;

	/**
     * Sets the task ID of the next task to execute after the current task finishes. If the task is not found or
     * <code>null</code> is passed as the nextElement, the current process will be terminated instead.
     * @param nextElement ID of the next task execute or null to terminate the process
     */
    public native void setNextElement(String nextElement) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setNextElement", "String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.setNextElement(nextElement);
    }-*/;
	
	/**
     * Sets a {@link com.smartgwt.client.util.workflow.Process#getState process state} variable for later reference with {@link
     * com.smartgwt.client.util.workflow.Process#getStateVariable getStateVariable()} or more commonly with a {@link
     * com.smartgwt.client.docs.TaskInputExpression} property. <P> The path, which is one or more valid identifiers separated
     * by periods, is used to identify the variable. By appending an empty pair of brackets ([]) the value will be placed into
     * an existing or new array at the specified path.
     * @param stateVariablePath path to the variable in the process state to set.
     * See {@link com.smartgwt.client.docs.SetterPath SetterPath}
     * @param value the value to save
     */
    public native void setStateVariable(String stateVariablePath, Object value) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setStateVariable", "String,Object");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.setStateVariable(stateVariablePath, value);
    }-*/;

	/**
     * Sets a {@link com.smartgwt.client.util.workflow.Process#getState process state} variable for later reference with {@link
     * com.smartgwt.client.util.workflow.Process#getStateVariable getStateVariable()} or more commonly with a {@link
     * com.smartgwt.client.docs.TaskInputExpression} property. <P> The path, which is one or more valid identifiers separated
     * by periods, is used to identify the variable. By appending an empty pair of brackets ([]) the value will be placed into
     * an existing or new array at the specified path.
     * @param stateVariablePath path to the variable in the process state to set.
     * See {@link com.smartgwt.client.docs.SetterPath SetterPath}
     * @param value the value to save
     * @param strict if true, the path must exist in the state to be set. Otherwise,                           the path will be created if it
     * does not exist. Defaults to                           <code>process.strictPaths</code> when null.
     */
    public native void setStateVariable(String stateVariablePath, Object value, Boolean strict) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setStateVariable", "String,Object,Boolean");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.setStateVariable(stateVariablePath, value, strict == null ? null : strict.@java.lang.Boolean::booleanValue()());
    }-*/;
	
	/**
     * Sets the task output of <code>task</code> in the {@link com.smartgwt.client.types.State process state} so it can be used
     * by later tasks with {@link com.smartgwt.client.util.workflow.Process#getLastTaskOutput getLastTaskOutput()} or more
     * commonly with a {@link com.smartgwt.client.docs.TaskInputExpression} property. <p> If the task sets
     * <code>bindOutput</code> the output value is also written into that {@link
     * com.smartgwt.client.util.workflow.Process#getState process state} variable.
     * @param task the workflow task setting the output (i.e. this)
     * @param value the output value for task
     */
    public native void setTaskOutput(ProcessElement task, Object value) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setTaskOutput", "ProcessElement,Object");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.setTaskOutput(task == null ? null : task.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()(), value);
    }-*/;

	/**
     * Starts this task by executing the {@link com.smartgwt.client.util.workflow.Process#getStartElement startElement}. Also
     * used by asynchronous tasks to restart the workflow.
     */
    public native void start() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "start", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.start();
    }-*/;

    /**
     * Add a traceElement handler.
     * <p>
     * StringMethod called during process execution before each task element is processed.
     *
     * @param handler the traceElement handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addTraceElementHandler(com.smartgwt.client.util.workflow.events.TraceElementHandler handler) {
        if(getHandlerCount(com.smartgwt.client.util.workflow.events.ProcessTraceElementEvent.getType()) == 0) setupTraceElementEvent();
        return doAddHandler(handler, com.smartgwt.client.util.workflow.events.ProcessTraceElementEvent.getType());
    }

    private native void setupTraceElementEvent() /*-{
        var obj;
        var selfJ = this;
        var traceElement = $entry(function(){
            var param = {"_this": this, "element" : arguments[0], "context" : arguments[1]};
                var event = @com.smartgwt.client.util.workflow.events.ProcessTraceElementEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
                selfJ.@com.smartgwt.client.core.BaseClass::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
                selfJ.@com.smartgwt.client.util.workflow.Process::handleTearDownTraceElementEvent()();
            });
        if(this.@com.smartgwt.client.core.BaseClass::isCreated()()) {
            obj = this.@com.smartgwt.client.core.BaseClass::getJsObj()();
            obj.addProperties({traceElement:  traceElement              });
        } else {
            obj = this.@com.smartgwt.client.core.BaseClass::getConfig()();
            obj.traceElement =  traceElement             ;
        }
    }-*/;

    private void handleTearDownTraceElementEvent() {
        if (getHandlerCount(com.smartgwt.client.util.workflow.events.ProcessTraceElementEvent.getType()) == 0) tearDownTraceElementEvent();
    }

    private native void tearDownTraceElementEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.core.BaseClass::isCreated()()) {
            obj = this.@com.smartgwt.client.core.BaseClass::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.core.BaseClass::getConfig()();
        }
        if (obj && obj.hasOwnProperty("traceElement")) delete obj.traceElement;
    }-*/;


    // ********************* Static Methods ***********************

	/**
     * Get a Process instance by its ID. <P> Each process instance created that has an {@link
     * com.smartgwt.client.util.workflow.ProcessElement#getID ID} is cached for later lookup by that ID. If two processes have
     * the same ID the last one is cached, overwriting the first. Note that the process instances are not affected - only the
     * cache reference.
     * @param processId process ID to retrieve.
     * See {@link com.smartgwt.client.docs.Identifier Identifier}
     *
     * @return the process, or null if not found
     * @see com.smartgwt.client.util.workflow.Process#loadProcess
     * @see com.smartgwt.client.docs.Identifier Identifier
     */
    public static native Process getProcess(String processId) /*-{
        var ret = $wnd.isc.Process.getProcess(processId);
        if(ret == null) return null;
        return @com.smartgwt.client.util.workflow.Process::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;



    // ***********************************************************



    private Map<String, ProcessElement[]> elementParameters = new HashMap<String, ProcessElement[]>();
    
    // IDs for elements are not unique, also all elements should be created when process
    // started, so elements don't act as BaseClass
    protected void onInit() {
        super.onInit();
        for (String key : elementParameters.keySet()) {
            setProperty(key, ProcessElement.convertToJavaScriptArray(elementParameters.get(key)));
        }        
    }

    public Process setAttribute(String attribute, ProcessElement[] value, boolean allowPostCreate) {
        if (!isCreated()) {
            elementParameters.put(attribute, value);
        } else if (allowPostCreate) {
            elementParameters.put(attribute, value);
            setProperty(attribute, ProcessElement.convertToJavaScriptArray(value));
        } else {
            error(attribute, value.toString(), allowPostCreate);
        }
        return this;
    }

    public void setConfig(JavaScriptObject jsObj) {
        this.config = jsObj;
    }
    
    public static native void loadProcess(String processId, ProcessCallback callback) /*-{
        var processCallback = null;
        if (callback != null) {
            processCallback = $entry(function (process) {
                var processJ = @com.smartgwt.client.util.workflow.Process::new(Lcom/google/gwt/core/client/JavaScriptObject;)(process);
                processJ.@com.smartgwt.client.util.workflow.Process::setConfig(Lcom/google/gwt/core/client/JavaScriptObject;)(process);
                callback.@com.smartgwt.client.callbacks.ProcessCallback::execute(Lcom/smartgwt/client/util/workflow/Process;)(processJ);
            });
        } else {
	  		processCallback = function (process) {};
        }
        $wnd.isc.Process.loadProcess(processId, processCallback);
    }-*/;
    
    public ProcessElement[] getProcessElements(String attribute) {
        return elementParameters.get(attribute); 
    }
    
    /**
     * Elements involved in this Process.  You can also group elements into {@link
     * com.smartgwt.client.util.workflow.Process#getSequences sequences} to reduce the need to explicitly define IDs for
     * elements and interlink them.
     *
     *
     * @return ProcessElement
     */
    public ProcessElement[] getElements()  {
        return getProcessElements("elements");
    }

    /**
     * Convenience form of declaring a single, linear sequence of tasks for this process.
     * Functionally equivalent to providing a one-element
     * {@link com.smartgwt.client.util.workflow.Process#getSequences sequences}
     * Array whose first (and only) member is this list.
     *
     *
     * @return ProcessElement
     */
    public ProcessElement[] getTasks()  {
        return getProcessElements("tasks");
    }

    /**
     * @see #setStartElement(String)
     */
    public void setStartElement(ProcessElement startElement)  throws IllegalStateException {
        setAttribute("startElement", startElement.getID(), false);
    }


}
