
package com.smartgwt.client.docs;

/**
 * Facilities for generating partial prompts with selected fragments omitted. <P> <h4>Purpose</h4>
 * When debugging CoT workflows, full prompts can be overwhelming?hundreds of kilobytes of UI
 * summaries, DataSource schemas, action lists, and boilerplate obscure the specific logic being
 * investigated. Partial prompts solve this by omitting irrelevant sections while preserving
 * troubleshooting-relevant content. <P> <h4>Fragment Types</h4> Prompts are composed of fragments
 * that can be independently omitted: <ul> <li><b>Built-in fragments:</b> goal, goalPrimer,
 * history, historyPrimer,     transitions, transitionsPrimer, errors, errorsPrimer, taskPrompt,
 * introPrompt</li> <li><b>Process fragments:</b> entries from  CoTProcess.optionalPrompts</li>
 * <li><b>State variables:</b> Any state.* variable referenced in templates</li> </ul> <P>
 * <h4>Built-in Modes</h4> Pre-configured modes target common troubleshooting scenarios. Pass a
 * mode name to  CoTProcess.getPartialPrompt(): <ul> <li><b>taskPromptOnly</b> - Debug
 * task-specific prompt content</li> <li><b>transitionDebug</b> - Debug workflow transition
 * logic</li> <li><b>stateTracking</b> - Track state variable changes</li> <li><b>historyOnly</b>
 * - Focus on action history continuity</li> <li><b>errorsOnly</b> - Focus on validation/execution
 * errors</li> <li><b>minimal</b> - Smallest useful prompt</li> <li><b>noData</b> - Omit large
 * data, keep logic</li> </ul> <P> Subclasses may define additional modes. Modes are resolved by
 * looking for <code>this.promptMode[ModeName]</code> on the process instance. <P> <h4>Customizing
 * Modes</h4> Any mode can be customized via  PartialPromptConfig.add and 
 * PartialPromptConfig.remove:
 */
public interface CoTPartialPrompt {
}
