package com.smartgwt.client.docs;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * A path expression indicating where and how a nested Object should be updated.
 *  <p>
 * A <code>SetterPath</code> is a dot-delimited list of segments, where each segment is a property name.  The
 * <code>SetterPath</code>
 *  can end in an operator that controls how the property update is done:
 *  <p>
 *  <ul>
 *  <li><code>[]</code> ? append to an Array (creates the Array if missing)</li>
 *  <li><code>{}</code> ? deep merge into an Object, overwriting existing keys</li>
 *  <li><code>{?}</code> ? deep merge into an Object, preserving existing keys (non-clobbering)</li>
 *  </ul>
 * This syntax is used in {@link com.smartgwt.client.util.workflow.Task#setState Task.setState()}/{@link
 * com.smartgwt.client.util.workflow.Process#setStateVariable Process.setStateVariable()}.
 *  <p>
 * Missing objects and Arrays are created as needed unless {@link com.smartgwt.client.util.workflow.Task#getStrictPaths
 * strictPaths} is set, either in
 * the specific API call, or on the {@link com.smartgwt.client.util.workflow.Task#getStrictPaths task} or {@link
 * com.smartgwt.client.util.workflow.Process#getStrictPaths process} involved.
 *  When <code>strictPaths</code> is enabled, attempting to traverse through a non-object/Array or a missing
 *  segment throws an error instead.
 *  <p>
 *  <h4>Examples</h4>
 *  Assume <code>process.state</code> starts as:
 *  <pre>
 *  {
 *      currentDS: {
 *          fields: [ { name:"orderId", type:"integer" } ],
 *          defaults: { timezone:"UTC" }
 *      }
 *  }
 *  </pre>
 *  <ul>
 *  <li><b>Append</b><br>
 *    <code>"currentDS.fields[]": { name:"orderDate", type:"date" }</code><br>
 *    Result: <code>fields</code> gains a new element at the end.</li>
 *  <li><b>Deep merge (clobber)</b><br>
 *    <code>"currentDS.defaults{}": { timezone:"PST", dateFormat:"YYYY-MM-DD" }</code><br>
 *    Result: <code>timezone</code> is overwritten to "PST"; <code>dateFormat</code> is added.</li>
 *  <li><b>Deep merge (non-clobber)</b><br>
 *    <code>"currentDS.defaults{?}": { timezone:"PST", locale:"en-US" }</code><br>
 *    Result: existing <code>timezone:"UTC"</code> is preserved; <code>locale</code> is added.</li>
 *  </ul>
 *  <p>
 */
public interface SetterPath  {
}
