/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.grid;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;

import com.smartgwt.logicalstructure.core.*;
import com.smartgwt.logicalstructure.widgets.*;
import com.smartgwt.logicalstructure.widgets.drawing.*;
import com.smartgwt.logicalstructure.widgets.plugins.*;
import com.smartgwt.logicalstructure.widgets.form.*;
import com.smartgwt.logicalstructure.widgets.tile.*;
import com.smartgwt.logicalstructure.widgets.grid.*;
import com.smartgwt.logicalstructure.widgets.chart.*;
import com.smartgwt.logicalstructure.widgets.layout.*;
import com.smartgwt.logicalstructure.widgets.menu.*;
import com.smartgwt.logicalstructure.widgets.rte.*;
import com.smartgwt.logicalstructure.widgets.ace.*;
import com.smartgwt.logicalstructure.widgets.tab.*;
import com.smartgwt.logicalstructure.widgets.tableview.*;
import com.smartgwt.logicalstructure.widgets.toolbar.*;
import com.smartgwt.logicalstructure.widgets.tree.*;
import com.smartgwt.logicalstructure.widgets.viewer.*;
import com.smartgwt.logicalstructure.widgets.calendar.*;
import com.smartgwt.logicalstructure.widgets.cube.*;
import com.smartgwt.logicalstructure.widgets.tools.*;
import com.smartgwt.logicalstructure.widgets.tour.*;
import com.smartgwt.logicalstructure.widgets.ai.*;

/**
 * Specialized {@link com.smartgwt.client.widgets.Label} for showing the currently visible row range and row count for a
 * source listGrid. <P> A rowRangeDisplay may be requested directly from the source grid via {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getRowRangeDisplay ListGrid.getRowRangeDisplay()}.
 * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("RowRangeDisplay")
public class RowRangeDisplay extends Canvas {

    public static RowRangeDisplay getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;
        final BaseWidget refInstance = BaseWidget.getRef(jsObj);
        if (refInstance == null) {
            return new RowRangeDisplay(jsObj);
        } else {
            assert refInstance instanceof RowRangeDisplay;
            return (RowRangeDisplay)refInstance;
        }
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(RowRangeDisplay.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.RowRangeDisplay.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(RowRangeDisplay.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.RowRangeDisplay.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public RowRangeDisplay(){
        scClassName = "RowRangeDisplay";
    }

    public RowRangeDisplay(JavaScriptObject jsObj){
        scClassName = "RowRangeDisplay";
        setJavaScriptObject(jsObj);
    }

    protected native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
        var widget = $wnd.isc[scClassName].create(config);
        if ($wnd.isc.keepGlobals) this.@com.smartgwt.client.widgets.BaseWidget::internalSetID(Lcom/google/gwt/core/client/JavaScriptObject;)(widget);
        this.@com.smartgwt.client.widgets.BaseWidget::doInit()();
        return widget;
    }-*/;


    // ********************* Properties / Attributes ***********************

    /**
     * rowRangeDisplay will center its content by default.
     *
     * @param align New align value. Default value is "center"
     * @return {@link com.smartgwt.client.widgets.grid.RowRangeDisplay RowRangeDisplay} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public RowRangeDisplay setAlign(Alignment align) {
        return (RowRangeDisplay)setAttribute("align", align == null ? null : align.getValue(), true);
    }

    /**
     * rowRangeDisplay will center its content by default.
     *
     * @return Current align value. Default value is "center"
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public Alignment getAlign()  {
        return EnumUtil.getEnum(Alignment.values(), getAttribute("align"));
    }
    

    /**
     * When an exact row count is currently unavailable on the source listGrid's  {@link
     * com.smartgwt.client.data.ResultSet#getRowCountStatus data object}, can the user issue a {@link
     * com.smartgwt.client.data.ResultSet#fetchRowCount row count fetch} by clicking? <P> For a rowRangeDisplay created via
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRowRangeDisplay ListGrid.getRowRangeDisplay()} this value will be
     * set to {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRequestRowCount ListGrid.canRequestRowCount} <P> See also
     * {@link com.smartgwt.client.widgets.grid.RowRangeDisplay#getInteractiveStyleName interactiveStyleName} and {@link
     * com.smartgwt.client.widgets.grid.RowRangeDisplay#getRequestRowCountPrompt requestRowCountPrompt}.
     *
     * @param canRequestRowCount New canRequestRowCount value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.RowRangeDisplay RowRangeDisplay} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public RowRangeDisplay setCanRequestRowCount(boolean canRequestRowCount) {
        return (RowRangeDisplay)setAttribute("canRequestRowCount", canRequestRowCount, true);
    }

    /**
     * When an exact row count is currently unavailable on the source listGrid's  {@link
     * com.smartgwt.client.data.ResultSet#getRowCountStatus data object}, can the user issue a {@link
     * com.smartgwt.client.data.ResultSet#fetchRowCount row count fetch} by clicking? <P> For a rowRangeDisplay created via
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRowRangeDisplay ListGrid.getRowRangeDisplay()} this value will be
     * set to {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRequestRowCount ListGrid.canRequestRowCount} <P> See also
     * {@link com.smartgwt.client.widgets.grid.RowRangeDisplay#getInteractiveStyleName interactiveStyleName} and {@link
     * com.smartgwt.client.widgets.grid.RowRangeDisplay#getRequestRowCountPrompt requestRowCountPrompt}.
     *
     * @return Current canRequestRowCount value. Default value is false
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public boolean getCanRequestRowCount()  {
        Boolean result = getAttributeAsBoolean("canRequestRowCount");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.RowRangeDisplay#getCanRequestRowCount canRequestRowCount} is true, this style
     * name will be applied to the rowRangeDisplay as long as an accurate row count is not known, indicating to the user that
     * they may click the label to retrieve an accurate status value.
     *
     * @param interactiveStyleName New interactiveStyleName value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.RowRangeDisplay RowRangeDisplay} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public RowRangeDisplay setInteractiveStyleName(String interactiveStyleName) {
        return (RowRangeDisplay)setAttribute("interactiveStyleName", interactiveStyleName, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.RowRangeDisplay#getCanRequestRowCount canRequestRowCount} is true, this style
     * name will be applied to the rowRangeDisplay as long as an accurate row count is not known, indicating to the user that
     * they may click the label to retrieve an accurate status value.
     *
     * @return Current interactiveStyleName value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public String getInteractiveStyleName()  {
        return getAttributeAsString("interactiveStyleName");
    }
    

    /**
     * This prompt will be displayed in a hover when {@link
     * com.smartgwt.client.widgets.grid.RowRangeDisplay#getCanRequestRowCount canRequestRowCount} is true and  an accurate row
     * count is not currently known. This indicates to the user that they can click to issue a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchRowCount row count fetch} request. <P> If set to null, no hover prompt
     * will be displayed by default
     *
     * @param requestRowCountPrompt New requestRowCountPrompt value. Default value is "Click to calculate row count"
     * @return {@link com.smartgwt.client.widgets.grid.RowRangeDisplay RowRangeDisplay} instance, for chaining setter calls
     */
    public RowRangeDisplay setRequestRowCountPrompt(String requestRowCountPrompt) {
        return (RowRangeDisplay)setAttribute("requestRowCountPrompt", requestRowCountPrompt, true);
    }

    /**
     * This prompt will be displayed in a hover when {@link
     * com.smartgwt.client.widgets.grid.RowRangeDisplay#getCanRequestRowCount canRequestRowCount} is true and  an accurate row
     * count is not currently known. This indicates to the user that they can click to issue a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchRowCount row count fetch} request. <P> If set to null, no hover prompt
     * will be displayed by default
     *
     * @return Current requestRowCountPrompt value. Default value is "Click to calculate row count"
     */
    public String getRequestRowCountPrompt()  {
        return getAttributeAsString("requestRowCountPrompt");
    }
    

    /**
     * The {@link com.smartgwt.client.widgets.grid.ListGrid} for which this label displays the current row range and row count.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.RowRangeDisplay#getSourceGrid sourceGrid}.
     *
     * @param sourceGrid ListGrid to display row information about. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.RowRangeDisplay RowRangeDisplay} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public RowRangeDisplay setSourceGrid(ListGrid sourceGrid) {
        return (RowRangeDisplay)setAttribute("sourceGrid", sourceGrid == null ? null : sourceGrid.getOrCreateJsObj(), true);
    }

    /**
     * The {@link com.smartgwt.client.widgets.grid.ListGrid} for which this label displays the current row range and row count.
     *
     * @return Current sourceGrid value. Default value is null
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public ListGrid getSourceGrid()  {
        return (ListGrid)ListGrid.getByJSObject(getAttributeAsJavaScriptObject("sourceGrid"));
    }
    

    /**
     * rowRangeDisplay will vertically center its content by default.
     *
     * @param vlign New vlign value. Default value is "center"
     * @return {@link com.smartgwt.client.widgets.grid.RowRangeDisplay RowRangeDisplay} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public RowRangeDisplay setVlign(Alignment vlign) {
        return (RowRangeDisplay)setAttribute("vlign", vlign == null ? null : vlign.getValue(), true);
    }

    /**
     * rowRangeDisplay will vertically center its content by default.
     *
     * @return Current vlign value. Default value is "center"
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public Alignment getVlign()  {
        return EnumUtil.getEnum(Alignment.values(), getAttribute("vlign"));
    }
    

    /**
     * rowRangeDisplay will not allow its content to wrap by default
     *
     * @param wrap New wrap value. Default value is false
     * @return {@link com.smartgwt.client.widgets.grid.RowRangeDisplay RowRangeDisplay} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public RowRangeDisplay setWrap(boolean wrap) {
        return (RowRangeDisplay)setAttribute("wrap", wrap, true);
    }

    /**
     * rowRangeDisplay will not allow its content to wrap by default
     *
     * @return Current wrap value. Default value is false
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public boolean getWrap()  {
        Boolean result = getAttributeAsBoolean("wrap");
        return result == null ? false : result;
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    /** 
     * Class level method to set the default properties of this class.  If set, then all
     * existing and subsequently created instances of this class will automatically have
     * default properties corresponding to
     * the properties set on the SmartGWT class instance passed to this function before its
     * underlying SmartClient JS object was created.
     * This is a powerful feature that eliminates the need for users to create a separate
     * hierarchy of subclasses that only alter the default properties of this class. Can also
     * be used for skinning / styling purposes.  <P> <b>Note:</b> This method is intended for
     * setting default attributes only and will affect all instances of the underlying class
     * (including those automatically generated in JavaScript).  This method should not be used
     * to apply standard EventHandlers or override methods for a class - use a custom subclass
     * instead.  Calling this method after instances have been created can result in undefined
     * behavior, since it bypasses any setters and a class instance may have already examined 
     * a particular property and not be expecting any changes through this route.
     *
     * @param rowRangeDisplayProperties properties that should be used as new defaults when instances of this class are created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public static native void setDefaultProperties(RowRangeDisplay rowRangeDisplayProperties) /*-{
        if (rowRangeDisplayProperties.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)(RowRangeDisplay.@java.lang.Object::getClass()(), "setDefaultProperties", rowRangeDisplayProperties.@java.lang.Object::getClass()());
        }
        rowRangeDisplayProperties.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
    	var properties = rowRangeDisplayProperties.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        properties = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(properties,true);
        $wnd.isc.RowRangeDisplay.addProperties(properties);
    }-*/;

    // ***********************************************************

    /**
     * Setter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject setLogicalStructure(RowRangeDisplayLogicalStructure s) {
        super.setLogicalStructure(s);
        try {
            s.align = getAttributeAsString("align");
        } catch (Throwable t) {
            s.logicalStructureErrors += "RowRangeDisplay.align:" + t.getMessage() + "\n";
        }
        try {
            s.canRequestRowCount = getAttributeAsString("canRequestRowCount");
        } catch (Throwable t) {
            s.logicalStructureErrors += "RowRangeDisplay.canRequestRowCount:" + t.getMessage() + "\n";
        }
        try {
            s.interactiveStyleName = getAttributeAsString("interactiveStyleName");
        } catch (Throwable t) {
            s.logicalStructureErrors += "RowRangeDisplay.interactiveStyleName:" + t.getMessage() + "\n";
        }
        try {
            s.requestRowCountPrompt = getAttributeAsString("requestRowCountPrompt");
        } catch (Throwable t) {
            s.logicalStructureErrors += "RowRangeDisplay.requestRowCountPrompt:" + t.getMessage() + "\n";
        }
        try {
            s.sourceGrid = getSourceGrid();
        } catch (Throwable t) {
            s.logicalStructureErrors += "RowRangeDisplay.sourceGrid:" + t.getMessage() + "\n";
        }
        try {
            s.vlign = getAttributeAsString("vlign");
        } catch (Throwable t) {
            s.logicalStructureErrors += "RowRangeDisplay.vlign:" + t.getMessage() + "\n";
        }
        try {
            s.wrap = getAttributeAsString("wrap");
        } catch (Throwable t) {
            s.logicalStructureErrors += "RowRangeDisplay.wrap:" + t.getMessage() + "\n";
        }
        return s;
    }

    /**
     * Getter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject getLogicalStructure() {
        RowRangeDisplayLogicalStructure s = new RowRangeDisplayLogicalStructure();
        setLogicalStructure(s);
        return s;
    }
}
