/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.componentXML.applications;

import com.smartgwt.client.rpc.LoadScreenCallback;
import com.smartgwt.client.rpc.RPCManager;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class DashboardStarterAppSampleXML extends ShowcasePanel {

    private static final String DESCRIPTION =
        " This application shows you how to aggregate data via workflows, build charts "+
        "by just binding them to DataSources, and how to use highlighting to set up KPIs on "+
        "the performance of actual sales against target sales."+
        "<P>"+
        "Hover over any chart element to see the real value."+
        "<P>"+
        "Click on the Pipeline description in the left section to change the view in the right-hand "+
        "pane. Filter data in the grid using the different radio group items to see it automatically filter the data.";

    public static class Factory implements PanelFactory {

        private String id;

        public ShowcasePanel create() {
            DashboardStarterAppSampleXML panel = new DashboardStarterAppSampleXML();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    @Override
    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {
        final Canvas layout = new Canvas();
        layout.setHeight100();
        layout.setWidth100();
        RPCManager.loadScreen("dashboardStarterApp", new LoadScreenCallback() {
            @Override
            public void execute() {
                layout.addChild(this.getScreen());
            }
        });
        return layout;
    }

    @Override
    public String getIntro() {
        return DESCRIPTION;
    }

    @Override
    protected boolean isFullscreenMode() {
        return true;
    }
    
    @Override
    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[]{
            new SourceEntity("dashboardStarterApp.ui.xml", XML, "source/dashboardStarterApp.ui.xml.html", true),
            new SourceEntity("kpi_Forecast.ds.xml", XML, "source/kpi_Forecast.ds.xml.html", true),
            new SourceEntity("kpi_Pipeline.ds.xml", XML, "source/kpi_Pipeline.ds.xml.html", true)
        };
    }
}
