/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.componentXML;

import java.util.HashMap;
import java.util.Map;

import com.smartgwt.client.rpc.LoadScreenCallback;
import com.smartgwt.client.rpc.RPCManager;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.SearchForm;
import com.smartgwt.client.widgets.form.fields.ComboBoxItem;
import com.smartgwt.client.widgets.form.fields.FilterCriteriaFunction;
import com.smartgwt.client.widgets.form.fields.FormItemCriteriaFunction;
import com.smartgwt.client.widgets.form.fields.FormItemFunctionContext;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridRecord;
import com.smartgwt.client.widgets.grid.events.CellContextClickEvent;
import com.smartgwt.client.widgets.grid.events.CellContextClickHandler;
import com.smartgwt.client.widgets.grid.events.CellSavedEvent;
import com.smartgwt.client.widgets.grid.events.CellSavedHandler;
import com.smartgwt.client.widgets.grid.events.RecordClickEvent;
import com.smartgwt.client.widgets.grid.events.RecordClickHandler;
import com.smartgwt.client.widgets.menu.Menu;
import com.smartgwt.client.widgets.menu.MenuItem;
import com.smartgwt.client.widgets.menu.events.ItemClickEvent;
import com.smartgwt.client.widgets.menu.events.ItemClickHandler;
import com.smartgwt.client.widgets.tab.TabSet;
import com.smartgwt.client.widgets.tab.events.TabSelectedEvent;
import com.smartgwt.client.widgets.tab.events.TabSelectedHandler;
import com.smartgwt.client.widgets.tree.TreeGrid;
import com.smartgwt.client.widgets.tree.events.NodeClickEvent;
import com.smartgwt.client.widgets.tree.events.NodeClickHandler;
import com.smartgwt.client.widgets.viewer.DetailViewer;
import com.smartgwt.client.widgets.viewer.DetailViewerRecord;
import com.smartgwt.client.data.Criteria;
import com.smartgwt.client.util.JSOHelper;

public class CompleteApplication extends ShowcasePanel {

    private static final String DESCRIPTION =
            "Demonstrates a range of SmartGWT GUI components, data binding operations, and layout managers" +
            " in a single-page application.";

    public static class Factory implements PanelFactory {

        private String id;

        public ShowcasePanel create() {
            CompleteApplication panel = new CompleteApplication();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    @Override
    protected boolean isTopIntro() {
        return false;
    }

    private ListGrid itemList = null;
    private TabSet itemDetailTabs = null;
    private DetailViewer itemViewer = null;
    private DynamicForm editForm = null;
    private TreeGrid categoryTree = null;
    private Label editorMessage = null;
    private SearchForm findForm = null;
    private Menu itemListMenu = null;
    private IButton findButton = null;
    
    public Canvas getViewPanel() {
        final Canvas layout = new Canvas();
        RPCManager.loadScreen("completeApplication", new LoadScreenCallback() {
            @Override
            public void execute() {
                findButton = (IButton) this.getScreen().getByLocalId("findButton");
                findButton.addClickHandler(new com.smartgwt.client.widgets.events.ClickHandler() {
                    @Override
                    public void onClick(com.smartgwt.client.widgets.events.ClickEvent event) {
                        findItems(null);
                    }
                });
                itemList = (ListGrid) this.getScreen().getByLocalId("itemList"); 
                itemList.addCellContextClickHandler(new CellContextClickHandler() {
                    @Override
                    public void onCellContextClick(CellContextClickEvent event) {
                        event.cancel();
                        itemListMenu.showContextMenu();
                    }
                });
                itemList.addRecordClickHandler(new RecordClickHandler() {
                    @Override
                    public void onRecordClick(RecordClickEvent event) {
                        updateDetails();
                    }
                });
                itemList.addCellSavedHandler(new CellSavedHandler() {
                    @Override
                    public void onCellSaved(CellSavedEvent event) {
                        updateDetails();
                    }
                });
                itemDetailTabs = (TabSet) this.getScreen().getByLocalId("itemDetailTabs");
                itemDetailTabs.addTabSelectedHandler(new TabSelectedHandler() {
                    @Override
                    public void onTabSelected(TabSelectedEvent event) {
                        updateDetails();
                    }
                });
                itemViewer = (DetailViewer) this.getScreen().getByLocalId("itemViewer");
                editForm = (DynamicForm) this.getScreen().getByLocalId("editForm");
                categoryTree = (TreeGrid) this.getScreen().getByLocalId("categoryTree");
                categoryTree.addNodeClickHandler(new NodeClickHandler() {
                    @Override
                    public void onNodeClick(NodeClickEvent event) {
                        findItems(event.getNode().getAttribute("categoryName"));
                    }
                });
                editorMessage = (Label) this.getScreen().getByLocalId("editorMessage");
                findForm = (SearchForm) this.getScreen().getByLocalId("findForm");
                ComboBoxItem cbi = (ComboBoxItem)findForm.getItem("itemName");
                cbi.setPickListFilterCriteriaFunction(new com.smartgwt.client.widgets.form.fields.FormItemCriteriaFunction() {
                    @Override
                    public Criteria getCriteria(FormItemFunctionContext itemContext) {
                        Criteria criteria = new Criteria();
                        if (findForm.getValue("findInCategory") != null && categoryTree.getSelectedRecords().length == 1) {
                            criteria.addCriteria("category", categoryTree.getSelectedRecord().getAttribute("categoryName"));
                        }
                        return criteria;
                    }
                });
                
                itemListMenu = (Menu) this.getScreen().getByLocalId("itemListMenu");
                itemListMenu.addItemClickHandler(new ItemClickHandler() {
                    @Override
                    public void onItemClick(ItemClickEvent event) {
                        String menu = event.getItem().getAttribute("name");
                        if (menu.equals("newItem")) {
                            itemList.deselectAllRecords();
                            itemDetailTabs.selectTab(1);
                            updateDetails();
                        } else if (menu.equals("showDetails")) {
                            itemDetailTabs.selectTab(0);
                            updateDetails();
                        } else if (menu.equals("editItem")) {
                            itemDetailTabs.selectTab(1);
                            updateDetails();
                        } else if (menu.equals("deleteItem")) {
                            if (itemList.getSelectedRecord() != null) {
                                itemList.removeSelectedData();
                                clearDetails();
                            }
                        }
                    }
                });

                layout.addChild(this.getScreen());
                
                categoryTree.fetchData();
            }
        });
        return layout;
    }

    public void findItems(String categoryName) {
        Map findValues = null;
        
        if (findForm.getValue("findInCategory") != null && categoryTree.getSelectedRecords().length == 1) {
            // use tree category and form values
            if (categoryName == null) categoryName = categoryTree.getSelectedRecord().getAttribute("categoryName");
            
            findValues = findForm.getValues();
            findValues.put("category", categoryName);
            
        } else if (categoryName == null) {
            // use form values only
            findValues = findForm.getValues();
            
        } else {
            // use tree category only
            findValues = new HashMap();
            findValues.put("category", categoryName);
        }
        
        itemList.filterData(new Criteria(JSOHelper.convertMapToJavascriptObject(findValues)));
        
        clearDetails();
    }
    
    public void updateDetails() {
        ListGridRecord record = itemList.getSelectedRecord();
        if (record == null) {
            clearDetails();
        } else if (itemDetailTabs.getSelectedTabNumber() == 0) {
            // View tab: show selected record
            itemViewer.setData(new ListGridRecord[] { record });
        } else {
            // Edit tab: edit selected record
            itemDetailTabs.updateTab(itemDetailTabs.getTab("editTab"), editForm);
            editForm.editRecord(record);
        }
    }
    
    public void clearDetails() {
        int selectedTab = itemDetailTabs.getSelectedTabNumber();
        if (selectedTab == 0) {
            // View tab: show empty message
            itemViewer.setData(new DetailViewerRecord[0]);
        } else if (selectedTab == 1) {
            // Edit tab: show new record editor, or empty message
            if (categoryTree.getSelectedRecord() != null) {
                itemDetailTabs.updateTab(itemDetailTabs.getTab("editTab"), editForm);
                ListGridRecord rec = new ListGridRecord();
                rec.setAttribute("category", categoryTree.getSelectedRecord().getAttribute("categoryName"));
                editForm.editNewRecord(rec);
            } else {
                itemDetailTabs.updateTab(itemDetailTabs.getTab("editTab"), editorMessage);
            }
        }
    }

    @Override
    public String getIntro() {
        return DESCRIPTION;
    }

    @Override
    protected boolean isFullscreenMode() {
        return true;
    }

    @Override
    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[]{
            new SourceEntity("completeApplication.ui.xml", XML, "source/completeApplication.ui.xml.html", true),
            new SourceEntity("supplyCategory.ds.xml", XML, "source/supplyCategory.ds.xml.html", true),
            new SourceEntity("supplyItem.ds.xml", XML, "source/supplyItem.ds.xml.html", true)
        };
    }
}
