/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.lang.reflect.Constructor;
import org.hibernate.InstantiationException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.internal.AbstractPojoInstantiator;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.ValueAccess;

public class EmbeddableInstantiatorRecordStandard
extends AbstractPojoInstantiator
implements EmbeddableInstantiator {
    protected final Constructor<?> constructor;

    public EmbeddableInstantiatorRecordStandard(Class<?> javaType) {
        super(javaType);
        Class<?>[] componentTypes = ReflectHelper.getRecordComponentTypes(javaType);
        this.constructor = ReflectHelper.getConstructorOrNull(javaType, componentTypes);
    }

    @Override
    public Object instantiate(ValueAccess valuesAccess, SessionFactoryImplementor sessionFactory) {
        if (this.constructor == null) {
            throw new InstantiationException("Unable to locate constructor for embeddable", this.getMappedPojoClass());
        }
        try {
            return this.constructor.newInstance(valuesAccess.getValues());
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate entity", this.getMappedPojoClass(), e);
        }
    }
}

