/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.log;

import com.isomorphic.base.Reflection;
import com.isomorphic.log.ILogger;
import com.isomorphic.log.Level;
import com.isomorphic.log.Logger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.event.SubstituteLoggingEvent;

public class Slf4jLogger
implements ILogger {
    private org.slf4j.Logger log;
    public static final Map<org.slf4j.event.Level, Level> fromSlf4j = new HashMap<org.slf4j.event.Level, Level>(){
        {
            this.put(org.slf4j.event.Level.ERROR, Logger.ERROR);
            this.put(org.slf4j.event.Level.WARN, Logger.WARN);
            this.put(org.slf4j.event.Level.INFO, Logger.INFO);
            this.put(org.slf4j.event.Level.DEBUG, Logger.DEBUG);
            this.put(org.slf4j.event.Level.TRACE, Logger.ALL);
        }
    };

    protected Slf4jLogger(String subsystem) {
        this.log = LoggerFactory.getLogger((String)subsystem);
    }

    @Override
    public void fatal(String message) {
        this.log.error(message);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.log.error(message, t);
    }

    @Override
    public void error(String message) {
        this.log.error(message);
    }

    @Override
    public void error(String message, Throwable t) {
        this.log.error(message, t);
    }

    @Override
    public void warn(String message) {
        this.log.warn(message);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log.warn(message, t);
    }

    @Override
    public void info(String message, Throwable t) {
        this.log.info(message, t);
    }

    @Override
    public void info(String message) {
        this.log.info(message);
    }

    @Override
    public void debug(String message) {
        this.log.debug(message);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.log.debug(message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.log.isErrorEnabled();
    }

    @Override
    public Level getLevel() {
        throw new UnsupportedOperationException("Reading logging level at runtime is not currently supported by SLF4J");
    }

    @Override
    public void setLevel(Level level) {
        throw new UnsupportedOperationException("Changing logging level at runtime is not currently supported by SLF4J");
    }

    @Override
    public void clearMDC() {
        MDC.clear();
    }

    @Override
    public void putMDC(String key, Object o) {
        if (o == null) {
            this.removeMDC(key);
            return;
        }
        MDC.put((String)key, (String)(o == null ? null : o.toString()));
    }

    @Override
    public void removeMDC(String key) {
        MDC.remove((String)key);
    }

    @Override
    public Object getMDC(String key) {
        return MDC.get((String)key);
    }

    @Override
    public Map getMDC() {
        return MDC.getCopyOfContextMap();
    }

    @Override
    public Map convertEvent(Object eventObj, Map mdc, String pk) throws Exception {
        Throwable t;
        SubstituteLoggingEvent event = (SubstituteLoggingEvent)eventObj;
        HashMap<String, Object> scEvent = new HashMap<String, Object>();
        scEvent.put("pk", pk);
        String loggerName = event.getLoggerName();
        int lastDotIndex = loggerName.lastIndexOf(".");
        if (lastDotIndex != -1) {
            loggerName = loggerName.substring(lastDotIndex + 1);
        }
        scEvent.put("loggerName", loggerName);
        scEvent.put("timeStamp", new Date(event.getTimeStamp()));
        scEvent.put("logMessage", event.getMessage());
        scEvent.put("threadName", event.getThreadName());
        scEvent.put("level", fromSlf4j.get(event.getLevel()).toInteger());
        if (mdc != null) {
            scEvent.put("mdc", mdc);
        }
        if ((t = event.getThrowable()) != null) {
            scEvent.put("throwable", ExceptionUtils.getStackTrace((Throwable)Reflection.getRealTargetException(t)));
        }
        return scEvent;
    }
}

