/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.Relation;
import com.isomorphic.datasource.SummaryFunctionType;
import com.isomorphic.datasource.UnionDataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.DBType;
import com.isomorphic.sql.SQLClauseType;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLExpression;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SQLExpressions
extends Base {
    private static boolean formulaEnabled = false;
    private static boolean templateEnabled = false;
    private static boolean valueOperationEnabled = false;
    private static Logger log;
    private DSRequest request;
    private SQLDataSource dataSource;
    private List dataSources;
    private SQLDriver driver;
    private Map remapTable = null;
    private Map column2TableMap = new HashMap();
    private boolean qualifyColumnNames;
    private List<String> customValueFields;
    private List<String> customCriteriaFields;
    private List<String> summaryFunctionFields;
    List<SQLExpression> templateFields = null;
    List<String> sortFields = null;
    List<String> sortFieldsWithDirection = null;
    private Map<String, Map> valueMaps;
    private boolean unionMode;
    UnionDataSource unionDs;

    public static SQLExpressions get(DSRequest req) throws Exception {
        SQLExpressions result = (SQLExpressions)((Object)req.getAttribute(SQLExpressions.class.getName()));
        if (result == null) {
            result = new SQLExpressions(req, DataTools.makeListIfSingle((Object)req.getDataSource()));
        }
        return result;
    }

    public SQLExpressions(DSRequest request, SQLDataSource dataSource) throws Exception {
        this(request, DataTools.makeList((Object)((Object)dataSource)));
    }

    protected SQLExpressions(DSRequest request, List dataSources) throws Exception {
        this(request, dataSources, false, null, null);
    }

    protected SQLExpressions(DSRequest request, List dataSources, boolean qualifyColumnNames, List customValueFields, List customCriteriaFields) throws Exception {
        this.remapTable = SQLDataSource.getField2ColumnMap(dataSources);
        if (dataSources.size() > 1) {
            this.column2TableMap = SQLDataSource.getColumn2TableMap(dataSources);
        }
        this.request = request;
        this.dataSources = dataSources;
        this.dataSource = (SQLDataSource)((Object)dataSources.get(0));
        this.driver = this.dataSource.getDriver();
        this.qualifyColumnNames = qualifyColumnNames;
        this.customValueFields = customValueFields;
        this.customCriteriaFields = customCriteriaFields;
        this.unionMode = Boolean.TRUE.equals(request.getAttribute("unionMode"));
        this.unionDs = (UnionDataSource)request.getAttribute("unionDataSource");
        this.sortFields = new ArrayList<String>();
        this.sortFieldsWithDirection = request.getSortByFields();
        this.sortFieldsWithDirection = this.dataSource.getSortByFields(this.sortFieldsWithDirection);
        for (String field : this.sortFieldsWithDirection) {
            if (field.startsWith("-")) {
                field = field.substring(1);
            }
            if (this.sortFields == null) {
                this.sortFields = new ArrayList<String>();
            }
            this.sortFields.add(field);
        }
        ArrayList<String> valueMapFields = new ArrayList<String>(this.sortFieldsWithDirection);
        List sortExpressionFields = request.getSortExpressionFields();
        if (sortExpressionFields != null) {
            for (String s : sortExpressionFields) {
                if (valueMapFields == null) {
                    valueMapFields = new ArrayList();
                }
                if (valueMapFields.contains(s)) continue;
                valueMapFields.add(s);
            }
        }
        this.valueMaps = SQLDataSource.getCombinedValueMaps(dataSources, valueMapFields);
        this.generateExpressions();
        request.setAttribute(SQLExpressions.class.getName(), (Object)this);
    }

    public static void setRequestExpressions(DSRequest req, Map<String, SQLExpression> expressions) {
        req.setExpressions(expressions);
    }

    public static Map<String, SQLExpression> getRequestExpressions(DSRequest req) {
        return (Map)req.getExpressions();
    }

    public static SQLExpression getExpression(DSRequest req, String fieldName) {
        return SQLExpressions.getExpression(req, fieldName, false);
    }

    public static SQLExpression getExpression(DSRequest req, String fieldName, boolean warn) {
        DSRequest primary;
        Map<String, SQLExpression> reqExpressions = SQLExpressions.getRequestExpressions(req);
        SQLExpression expression = null;
        if (reqExpressions != null) {
            expression = reqExpressions.get(fieldName);
        }
        if (expression == null && req.isQueryField(fieldName) && (primary = req.getPrimaryDSRequest()) != null) {
            expression = SQLExpressions.getExpression(primary, fieldName, false);
        }
        if (expression == null && warn) {
            log.warn((Object)("Missing expression for the '" + fieldName + "' field of the '" + req.getDataSourceName() + "' DataSource."));
        }
        return expression;
    }

    public static void init(DSRequest dsRequest) throws Exception {
        new SQLExpressions(dsRequest, DataTools.makeList((Object)dsRequest.getDataSource()));
    }

    public static void init(DSRequest dsRequest, List dataSources) throws Exception {
        new SQLExpressions(dsRequest, dataSources);
    }

    protected SQLExpression addExpression(String fieldName, SQLExpression expression) {
        Map<String, SQLExpression> reqExpressions = SQLExpressions.getRequestExpressions(this.request);
        if (reqExpressions == null) {
            reqExpressions = new LinkedHashMap<String, SQLExpression>();
            SQLExpressions.setRequestExpressions(this.request, reqExpressions);
        }
        if (!reqExpressions.containsKey(fieldName)) {
            reqExpressions.put(fieldName, expression);
        } else {
            boolean warn = true;
            SQLExpression existing = reqExpressions.get(fieldName);
            if (existing.isIncludeFrom() && expression.isIncludeFrom()) {
                warn = existing.getIncludeFrom().getKey().equals(expression.getIncludeFrom().getKey());
            }
            if (warn && !DataSource.isModificationOperation((String)this.request.getOperationType())) {
                log.warn((Object)("SQLExpression for field '" + fieldName + "' already exists, skip."));
            }
        }
        return expression;
    }

    protected SQLExpression getExpression(String fieldName) {
        return SQLExpressions.getExpression(this.request, fieldName);
    }

    protected DSRequest getRequest() {
        return this.request;
    }

    protected SQLDataSource getDataSource() {
        return this.dataSource;
    }

    protected List getDataSources() {
        return this.dataSources;
    }

    protected SQLDriver getDriver() {
        return this.driver;
    }

    protected Map getColumn2TableMap() {
        return this.column2TableMap;
    }

    protected Map getRemapTable() {
        return this.remapTable;
    }

    protected List<String> getSortFields() {
        return this.sortFields;
    }

    protected List<String> getSortFieldsWithDirection() {
        return this.sortFieldsWithDirection;
    }

    protected boolean qualifyColumnNames() {
        return this.qualifyColumnNames;
    }

    public Map getValueMap(String fieldName) {
        if (this.valueMaps != null) {
            return this.valueMaps.get(fieldName);
        }
        return null;
    }

    private void generateExpressions() throws Exception {
        Map staticValueFields;
        Iterator fieldIterator;
        DataTypeMap operationBinding;
        String order;
        String opType = this.request.getOperationType();
        String opId = this.request.getOperationId();
        DataTypeMap opBinding = this.dataSource.getOperationBinding(opType, opId);
        boolean vanillaFetch = false;
        if (opBinding != null && !this.request.isSummary()) {
            if (opBinding.get("customSQL") == null && opBinding.get("selectClause") == null && opBinding.get("tableClause") == null && opBinding.get("whereClause") == null && opBinding.get("groupClause") == null && opBinding.get("orderClause") == null && opBinding.get("valueClause") == null) {
                vanillaFetch = true;
            }
        } else {
            vanillaFetch = true;
        }
        if (this.request.isPaged() && this.driver.supportsSQLLimit() && this.driver.limitRequiresSQLOrderClause() && !this.driver.supportsOffsetFetch() && (this.sortFields == null || this.sortFields.isEmpty()) && ((order = (String)((operationBinding = this.dataSource.getOperationBinding(this.request)) == null ? null : operationBinding.get("orderClause"))) == null || "$defaultOrderClause".equals(order.trim()))) {
            this.sortFields = this.dataSource.getPrimaryKeys();
        }
        List expressionFields = this.request.getExpressionFields();
        Iterator<Object> iterator = fieldIterator = this.unionMode ? expressionFields.iterator() : this.remapTable.keySet().iterator();
        while (fieldIterator.hasNext()) {
            DataSource firstDS;
            String tableName;
            String unionFieldName;
            String columnName;
            boolean requestedBySorting;
            String rsName = (String)fieldIterator.next();
            if (this.request.getDroppedFields() != null && this.request.getDroppedFields().contains(rsName)) continue;
            boolean requested = false;
            List outputs = this.unionMode ? this.request.getOutputs() : this.request.getConsolidatedOutputs();
            List sortExpressionFields = this.request.getSortExpressionFields();
            boolean ignoreOutputs = outputs == null;
            boolean requestedByOutputs = outputs != null && outputs.contains(rsName);
            boolean expressionNeeded = expressionFields != null && expressionFields.contains(rsName);
            List summaryFields = this.request.getSummaryFields();
            boolean requestedBySummary = summaryFields != null && summaryFields.contains(rsName);
            boolean bl = requestedBySorting = this.sortFields != null && this.sortFields.contains(rsName) || sortExpressionFields != null && sortExpressionFields.contains(rsName);
            if (this.request.isSummary() ? !requestedBySummary && !expressionNeeded : !ignoreOutputs && !requestedByOutputs && !requestedBySorting && !expressionNeeded) continue;
            String remapName = columnName = (String)this.remapTable.get(rsName);
            if (this.unionMode && (unionFieldName = this.unionDs.getOriginalFieldName((DataSource)this.dataSource, rsName, this.request)) != null) {
                columnName = unionFieldName;
            }
            if (columnName != null && columnName.contains(".")) {
                columnName = columnName.substring(columnName.lastIndexOf(".") + 1);
            }
            if ((tableName = this.request.getForcedAlias()) == null) {
                String string = tableName = this.qualifyColumnNames ? (String)this.column2TableMap.get(columnName) : null;
            }
            if (tableName == null && this.qualifyColumnNames && (firstDS = (DataSource)this.dataSources.get(0)) instanceof SQLDataSource) {
                tableName = ((SQLDataSource)firstDS).getTable().getNameQuotedIfNecessary((SQLDataSource)firstDS);
            }
            boolean skipCustomSQLCheck = false;
            if (this.customValueFields != null) {
                Iterator<String> i = this.customValueFields.iterator();
                while (i.hasNext()) {
                    if (!i.next().equals(rsName)) continue;
                    skipCustomSQLCheck = true;
                    break;
                }
            }
            boolean skipCustomSQLCheckForWhereClause = false;
            if (this.customCriteriaFields != null) {
                Iterator<String> i = this.customCriteriaFields.iterator();
                while (i.hasNext()) {
                    if (!i.next().equals(rsName)) continue;
                    skipCustomSQLCheckForWhereClause = true;
                    break;
                }
            }
            boolean exclude = false;
            boolean excludeFromWhereClause = false;
            int exclusionReason = 0;
            SQLDataSource ds = null;
            DSField field = null;
            for (int i = 0; i < this.dataSources.size(); ++i) {
                ds = (SQLDataSource)((Object)this.dataSources.get(i));
                field = ds.getField(rsName);
                if (this.unionMode && field == null) {
                    field = ds.getField(columnName);
                }
                if (field == null) continue;
                if (field.getIncludeFromDefinition(this.request) != null || valueOperationEnabled && field.get((Object)"valueOperation") != null) {
                    if (this.unionMode) {
                        // empty if block
                    }
                    exclude = true;
                    break;
                }
                if (field.getBoolean("customSQL")) {
                    if (!skipCustomSQLCheckForWhereClause) {
                        excludeFromWhereClause = true;
                    }
                    if (!skipCustomSQLCheck) {
                        if (this.unionMode) {
                            columnName = null;
                            break;
                        }
                        exclude = true;
                        exclusionReason = 1;
                        break;
                    }
                }
                if (field.get((Object)"tableName") != null && vanillaFetch) {
                    exclude = true;
                    excludeFromWhereClause = true;
                    exclusionReason = 2;
                    break;
                }
                if (field.isInapplicable()) {
                    exclude = true;
                    excludeFromWhereClause = true;
                    exclusionReason = 3;
                    break;
                }
                if (this.qualifyColumnNames && field.get((Object)"tableName") != null) {
                    tableName = field.get((Object)"tableName").toString();
                }
                if (!DataSource.simpleTypeInheritsFromBuiltInType((String)field.getType(), (String)"binary")) break;
                boolean includeBinaryField = false;
                if (this.request.isClientRequest() && (this.request.isDownload() || field.shouldEncodeInResponse())) {
                    includeBinaryField = true;
                }
                if (!includeBinaryField && this.request.getIncludeBinaryFields()) {
                    includeBinaryField = true;
                }
                if (!includeBinaryField && this.request.getConsolidatedOutputs() != null && this.request.getConsolidatedOutputs().contains(rsName)) {
                    includeBinaryField = true;
                }
                List sortByFields = this.request.getSortByFields();
                if (!includeBinaryField && sortByFields != null && !sortByFields.isEmpty()) {
                    for (int y = 0; y < sortByFields.size(); ++y) {
                        DataTypeMap operationBinding2;
                        String paging;
                        String sortByField = (String)sortByFields.get(y);
                        if (sortByField.startsWith("-")) {
                            sortByField = sortByField.substring(1);
                        }
                        if (!sortByField.equals(rsName) || !this.request.isPaged() || "none".equals(paging = SQLDataSource.getPaging(this.request, (Map)(operationBinding2 = this.request.getDataSource().getOperationBinding(this.request.getOperationType(), this.request.getOperationId())), ds))) continue;
                        includeBinaryField = true;
                    }
                }
                if (includeBinaryField) break;
                exclude = true;
                excludeFromWhereClause = true;
                exclusionReason = 4;
                break;
            }
            if (exclude && excludeFromWhereClause) {
                if (exclusionReason == 0) continue;
                SQLExpression dummy = new SQLExpression(this.request, this.driver, this.dataSource, field);
                String reasonForExcluding = "Unknown";
                switch (exclusionReason) {
                    case 1: {
                        reasonForExcluding = "Field is marked customSQL";
                        break;
                    }
                    case 2: {
                        reasonForExcluding = "Field specifies tableName and this is a vanillaFetch";
                        break;
                    }
                    case 3: {
                        reasonForExcluding = "Field is marked inapplicable";
                        break;
                    }
                    case 4: {
                        reasonForExcluding = "Field is binary and we have no reason to fetch it";
                    }
                }
                dummy.setExcluded(true);
                dummy.setExcludedFromWhereClause(true);
                dummy.setReasonForExcluding(reasonForExcluding);
                dummy.setExpr("*EXCLUDED " + rsName + "*");
                this.addExpression(rsName, dummy);
                continue;
            }
            String functionName = null;
            Map summaryFunctionMap = this.request.getSummaryFunctions();
            if (summaryFunctionMap != null && summaryFunctionMap.containsKey(rsName)) {
                functionName = ((SummaryFunctionType)summaryFunctionMap.get(rsName)).getFunctionName();
            }
            if (("CONCAT".equalsIgnoreCase(functionName) && this.driver.getDBType() != DBType.Oracle || "ARRAY".equalsIgnoreCase(functionName)) && !this.isConcatFetch((DataSource)this.dataSource, rsName)) {
                this.addExpression(rsName, new SQLExpression(this.request, this.driver, this.dataSource, field).setExpr("null").setAlias(rsName).setExprFullWithAlias("null AS " + rsName)).setExcluded(exclude && exclusionReason != 0).setExcludedFromWhereClause(excludeFromWhereClause);
            }
            if (field != null && "relatedCount".equals(field.getProperty("type"))) {
                this.addExpression(field.getName(), this.aggregationSubSelect(ds, columnName, rsName, tableName, field));
                continue;
            }
            if (field != null && (field.getProperty("customSelectExpression") != null || field.getProperty("customSQLExpression") != null)) {
                this.addExpression(field.getName(), this.customSQLExpression(ds, field, functionName)).setExcluded(exclude && exclusionReason != 0).setExcludedFromWhereClause(excludeFromWhereClause);
                continue;
            }
            if (valueOperationEnabled && field != null && field.get((Object)"valueOperation") != null) {
                this.addExpression(field.getName(), this.valueOperation(ds, field, functionName)).setExcluded(exclude && exclusionReason != 0).setExcludedFromWhereClause(excludeFromWhereClause);
                continue;
            }
            if (field != null && field.getProperty("serverFormula") != null) {
                this.addExpression(field.getName(), this.customSQLExpression(ds, field, functionName)).setExcluded(exclude && exclusionReason != 0).setExcludedFromWhereClause(excludeFromWhereClause);
                continue;
            }
            if (formulaEnabled && field != null && field.get((Object)"formula") != null) {
                this.addExpression(field.getName(), this.formula(ds, field, functionName)).setExcluded(exclude && exclusionReason != 0).setExcludedFromWhereClause(excludeFromWhereClause);
                continue;
            }
            if (templateEnabled && field != null && field.get((Object)"template") != null) {
                if (this.templateFields == null) {
                    this.templateFields = new ArrayList<SQLExpression>();
                }
                this.templateFields.add(new SQLExpression(this.request, this.driver, ds, field));
                continue;
            }
            String thisTableName = tableName;
            if (this.unionMode) {
                if (ds.getField(columnName) == null && ds.getField(rsName) == null) {
                    DSField renamedField = this.unionDs.getRenamedField((DataSource)ds, ds.getField(remapName));
                    if (renamedField != null) {
                        if (!ds.getField(remapName).getName().equals(this.unionDs.getOriginalFieldName((DataSource)ds, ds.getField(remapName).getName()))) {
                            columnName = null;
                        }
                    } else {
                        columnName = null;
                    }
                }
                if (columnName == null) {
                    thisTableName = null;
                }
            }
            if (exclude && exclusionReason == 0) continue;
            SQLExpression expression = new SQLExpression(this.request, this.driver, ds, field).setTable(thisTableName).setColumn(columnName).setExpr(this.driver.sqlOutTransform(columnName, null, thisTableName, null, (Map)field)).setExcluded(exclude).setExcludedFromWhereClause(excludeFromWhereClause);
            if (functionName != null) {
                expression.setFunction(functionName).setExprFull(this.driver.sqlOutTransform(columnName, null, thisTableName, functionName, (Map)field));
            }
            expression.setExprFullWithAlias(this.driver.sqlOutTransform(columnName, rsName, thisTableName, functionName, (Map)field));
            if (requestedBySorting) {
                expression.setExprForSortBy(this.driver.getExpressionForSortBy(this.unionMode ? rsName : expression.getExpr(), this.valueMaps.get(rsName), functionName, this.request));
            }
            if (!rsName.equals(columnName) || functionName != null) {
                expression.setAlias(rsName);
            }
            this.addExpression(rsName, expression);
        }
        this.addSQLForJoinedFields();
        Map queryFields = this.request.getQueryFields();
        if (queryFields != null) {
            for (String fieldName : queryFields.keySet()) {
                Map queryFieldData = (Map)queryFields.get(fieldName);
                this.addExpression(fieldName, this.queryField(fieldName, queryFieldData));
            }
        }
        if ((staticValueFields = this.request.getStaticValueFields()) != null) {
            for (String fieldName : staticValueFields.keySet()) {
                Map staticValue = (Map)staticValueFields.get(fieldName);
                this.addExpression(fieldName, this.staticValue(this.driver, fieldName, staticValue));
            }
        }
        if (this.summaryFunctionFields != null && !this.summaryFunctionFields.isEmpty()) {
            this.request.setSummaryFunctionFields(this.summaryFunctionFields);
        }
        if (templateEnabled && this.templateFields != null) {
            for (SQLExpression expression : this.templateFields) {
                DSField field = expression.getField();
                String expr = this.driver.evaluateTemplate(this.request, field);
                expression.setTemplate().setExpr(expr).setAlias(field.getName()).setExprFullWithAlias(expr + " AS " + field.getName());
                if (this.sortFields != null && this.sortFields.contains(field.getName())) {
                    expression.setExprForSortBy(this.driver.getExpressionForSortBy(this.unionMode ? field.getName() : expression.getExpr(), this.valueMaps.get(field.getName()), expression.getFunction(), this.request));
                }
                this.addExpression(field.getName(), expression);
            }
        }
    }

    private void addSQLForJoinedField(DSField field, String forceAlias) throws Exception {
        IncludeFromDefinition incFrom = field.getIncludeFromDefinition(this.request);
        if (incFrom.isInError()) {
            return;
        }
        SQLExpression expression = this._addSQLForJoinedField(incFrom);
        expression.setAlias(forceAlias);
    }

    private void addSQLForJoinedFields() throws Exception {
        for (IncludeFromDefinition incFrom : this.request.getIncludeFrom()) {
            if (incFrom.isInError()) continue;
            this._addSQLForJoinedField(incFrom);
        }
    }

    private SQLExpression _addSQLForJoinedField(IncludeFromDefinition incFrom) throws Exception {
        DSField unionField;
        SQLDataSource thisDS = (SQLDataSource)incFrom.getThisDataSource();
        String thisFieldName = incFrom.getThisFieldName();
        DSField thisField = incFrom.getThisField();
        String expressionId = incFrom.getExpressionId();
        boolean requested = false;
        List outputs = this.unionMode ? this.request.getOutputs() : this.request.getConsolidatedOutputs();
        String fieldNameToUse = thisFieldName;
        if (this.unionMode && this.unionDs != null && (unionField = this.unionDs.getRenamedField((DataSource)this.dataSource, this.dataSource.getField(thisFieldName), this.request)) != null) {
            fieldNameToUse = unionField.getName();
        }
        if (!requested && outputs != null && outputs.contains(fieldNameToUse) || outputs == null) {
            requested = true;
        }
        List expressionFields = this.request.getExpressionFields();
        if (!requested && expressionFields != null && expressionFields.contains(fieldNameToUse)) {
            requested = true;
        }
        List summaryFields = this.request.getSummaryFields();
        if (!requested && this.request.isSummary() && summaryFields != null && summaryFields.contains(fieldNameToUse)) {
            requested = true;
        }
        if (!requested) {
            return null;
        }
        if (thisField != null && thisField.getBoolean("customSQL")) {
            boolean skipField = true;
            if (this.customValueFields != null) {
                Iterator<String> j = this.customValueFields.iterator();
                while (j.hasNext()) {
                    if (!j.next().equals(thisFieldName)) continue;
                    skipField = false;
                    break;
                }
            }
            if (skipField) {
                return null;
            }
        }
        IncludeFromDefinition topIncFrom = incFrom;
        IncludeFromDefinition target = incFrom.getTargetIncludeFrom();
        while (target != null && incFrom.getDataSource() instanceof SQLDataSource) {
            incFrom = target;
            target = incFrom.getTargetIncludeFrom();
        }
        if (!(incFrom.getDataSource() instanceof SQLDataSource)) {
            return null;
        }
        DSField targetThisField = incFrom.getThisField();
        DSField targetField = incFrom.getIncludedField();
        String fieldName = incFrom.getIncludedFieldName();
        String columnName = incFrom.getIncludedField().getNativeName();
        if (columnName == null) {
            columnName = fieldName;
        }
        SQLDataSource relatedDS = (SQLDataSource)incFrom.getDataSource();
        String tableName = relatedDS.getTable().getNameQuotedIfNecessary(relatedDS);
        String alias = incFrom.getAlias();
        if (alias != null) {
            tableName = alias;
        }
        String functionName = null;
        Map summaryFunctionsMap = this.request.getSummaryFunctions();
        if (summaryFunctionsMap != null && summaryFunctionsMap.containsKey(thisFieldName)) {
            functionName = ((SummaryFunctionType)summaryFunctionsMap.get(thisFieldName)).getFunctionName();
        }
        String fieldFunctionName = null;
        if (functionName == null && thisField != null) {
            fieldFunctionName = (String)thisField.get((Object)"includeSummaryFunction");
        }
        if (("CONCAT".equalsIgnoreCase(functionName) && this.driver.getDBType() != DBType.Oracle || "ARRAY".equalsIgnoreCase(functionName) || "ARRAY".equalsIgnoreCase(fieldFunctionName)) && !this.isConcatFetch((DataSource)thisDS, thisFieldName)) {
            return new SQLExpression(this.request, this.driver, (SQLDataSource)incFrom.getThisDataSource(), thisField).setExpr("null").setAlias(thisFieldName).setExprFullWithAlias("null AS " + fieldNameToUse);
        }
        if (!this.request.isSummary() && thisField != null && thisField.getProperty("includeSummaryFunction") != null && !this.request.isConcatFetchRequest()) {
            return this.addExpression(expressionId, this.addSubSelectForIncludeSummaryField(topIncFrom, functionName));
        }
        if (thisField != null && (thisField.getProperty("customSelectExpression") != null || thisField.getProperty("customSQLExpression") != null)) {
            return this.addExpression(expressionId, this.customSQLExpression(thisDS, thisField, functionName));
        }
        if (valueOperationEnabled && targetThisField != null && targetThisField.get((Object)"valueOperation") != null) {
            return this.addExpression(expressionId, this.valueOperation(thisDS, targetThisField, functionName, topIncFrom, incFrom));
        }
        if (formulaEnabled && targetField != null && targetField.get((Object)"formula") != null) {
            return this.addExpression(expressionId, this.formula((SQLDataSource)incFrom.getDataSource(), targetField, functionName, thisFieldName));
        }
        if (thisField != null && thisField.get((Object)"template") != null || targetField != null && targetField.get((Object)"template") != null) {
            if (this.templateFields == null) {
                this.templateFields = new ArrayList<SQLExpression>();
            }
            this.templateFields.add(new SQLExpression(this.request, this.driver, thisDS, thisField));
            return null;
        }
        String fieldType = null;
        if (columnName == null && this.unionMode) {
            DSField unionDSField = null;
            if (columnName == null) {
                unionDSField = this.unionDs.getField(thisField.getName());
                fieldType = this.request.getDataSource().getSimpleBaseType(unionDSField.getType());
            }
        } else if (thisField == null && targetField != null) {
            fieldType = targetField.getType();
        }
        String expr = relatedDS.getDriver().sqlOutTransform(columnName, null, tableName, null, (Map)incFrom.getThisField(), fieldType);
        SQLExpression expression = new SQLExpression(this.request, this.driver, thisDS, thisField).setTable(tableName).setColumn(columnName).setAlias(fieldNameToUse).setIncludeFrom(topIncFrom).setExpr(expr);
        if (this.sortFields != null && this.sortFields.contains(thisFieldName)) {
            expression.setExprForSortBy(this.driver.getExpressionForSortBy(this.unionMode ? thisFieldName : expr, this.valueMaps.get(thisFieldName), functionName, this.request));
        }
        if (functionName != null) {
            expr = relatedDS.getDriver().sqlOutTransform(columnName, null, tableName, functionName, (Map)incFrom.getThisField(), fieldType);
            expression.setFunction(functionName).setExprFull(expr);
        }
        expression.setExprFullWithAlias(expr + " AS " + fieldNameToUse);
        if (thisField == null) {
            HashMap<String, String> dummyFieldConfig = new HashMap<String, String>();
            dummyFieldConfig.put("name", thisFieldName);
            dummyFieldConfig.put("type", fieldType);
            expression.setField(new DSField(dummyFieldConfig));
            expression.setAlias(null);
            expression.setExprForSortBy(expressionId);
        } else {
            expressionId = fieldNameToUse;
        }
        return this.addExpression(expressionId, expression);
    }

    private Relation getConnectorRelation(Relation source) {
        if (source == null) {
            return null;
        }
        Relation target = new Relation();
        target.setFromDataSource(source.getFromDataSource());
        target.setFromAlias(source.getFromAlias());
        target.setFromFields(source.getFromFields());
        target.setToDataSource(source.getToDataSource());
        target.setToAlias(source.getToAlias());
        target.setToFields(source.getToFields());
        target.setJoinType(0);
        return target;
    }

    protected static Relation inverseRelation(Relation source) {
        if (source == null) {
            return null;
        }
        Relation target = new Relation();
        target.setFromDataSource(source.getToDataSource());
        target.setFromAlias(source.getToAlias());
        target.setFromFields(source.getToFields());
        target.setToDataSource(source.getFromDataSource());
        target.setToAlias(source.getFromAlias());
        target.setToFields(source.getFromFields());
        target.setJoinType(0);
        if (source.getNextRelation() != null) {
            target.setNextRelation(SQLExpressions.inverseRelation(source.getNextRelation()));
        }
        return target;
    }

    private SQLExpression queryField(String fieldName, Map queryFieldData) throws Exception {
        SQLExpression expression = this.getExpression(fieldName);
        if (expression == null) {
            DSRequest subRequest = (DSRequest)queryFieldData.get("_validatedDSRequest");
            if (subRequest == null) {
                log.debug((Object)("Query field failed to create and validate sub-query fetching data from '" + String.valueOf(queryFieldData.get("dataSource")) + "' DataSource. Using NULL."));
                return new SQLExpression(this.request, this.driver, this.dataSource, null).setExpr("null");
            }
            String queryFK = (String)queryFieldData.get("queryFK");
            if (queryFK == null || !"*none*".equalsIgnoreCase(queryFK.trim())) {
                Relation connector;
                Relation r = subRequest.getDataSource().getRelation(new DataSource[]{this.dataSource}, null, queryFK, true, this.request);
                if (r.getNextRelation() == null) {
                    connector = r;
                    r = null;
                } else {
                    Relation current = r;
                    Relation previous = null;
                    while (current.getNextRelation() != null) {
                        previous = current;
                        current = current.getNextRelation();
                    }
                    connector = current;
                    previous.setNextRelation(null);
                }
                if (connector != null) {
                    connector.setJoinType(0);
                }
                String forcedAlias = "sub";
                if (r == null && connector.getFromDataSource().getName().equals(connector.getToDataSource().getName())) {
                    subRequest.setForcedAlias(forcedAlias);
                    connector.setToAlias(forcedAlias);
                }
                if (r != null && r.getFromDataSource().getName().equals(connector.getToDataSource().getName())) {
                    subRequest.setForcedAlias(forcedAlias);
                    r.setFromAlias(forcedAlias);
                }
                subRequest.setSubqueryConnector(connector).setSubqueryRelations(r).setValueOperation(true);
            }
            DataSource ds = subRequest.getDataSource();
            String queryOutput = (String)queryFieldData.get("queryOutput");
            DSField outputField = null;
            String outputType = null;
            if (queryOutput != null && (outputField = ds.getField(queryOutput)) == null) {
                log.warn((Object)("The DataSource field '" + ds.getName() + "." + queryOutput + "' requested in fieldQuery/valueQuery does not exist. The subquery will attempt to select the field automatically, as it would do by default in the absence of a queryOutput setting."));
                queryOutput = null;
            }
            Map summaryFunctions = (Map)queryFieldData.get("summaryFunctions");
            List groupBy = (List)queryFieldData.get("groupBy");
            if (summaryFunctions != null && summaryFunctions.size() > 0) {
                if (queryOutput == null) {
                    queryOutput = (String)summaryFunctions.keySet().iterator().next();
                }
                tempField = ds.getField(queryOutput);
                fieldType = outputField != null ? outputField.getType() : (tempField != null ? tempField.getType() : "text");
                String function = (String)summaryFunctions.values().iterator().next();
                outputType = function.equalsIgnoreCase(SummaryFunctionType.COUNT.getFunctionName()) ? "integer" : (function.equalsIgnoreCase(SummaryFunctionType.CONCAT.getFunctionName()) ? "text" : fieldType);
            } else if (groupBy != null && groupBy.size() > 0) {
                if (queryOutput == null) {
                    queryOutput = (String)groupBy.get(0);
                }
                tempField = ds.getField(queryOutput);
                outputType = fieldType = outputField != null ? outputField.getType() : (tempField != null ? tempField.getType() : "text");
            } else {
                DSField f;
                DSField firstField = null;
                DSField firstIntegerField = null;
                DSField firstFloatField = null;
                for (DSField field : ds.getFields()) {
                    if (firstField == null) {
                        firstField = field;
                    }
                    if (ds.simpleTypeInheritsFrom(field.getType(), "integer") && firstIntegerField == null) {
                        firstIntegerField = field;
                    }
                    if (!ds.simpleTypeInheritsFrom(field.getType(), "float") || firstFloatField != null) continue;
                    firstFloatField = field;
                }
                if (queryOutput == null) {
                    String string = firstIntegerField != null ? firstIntegerField.getName() : (queryOutput = firstFloatField != null ? firstFloatField.getName() : firstField.getName());
                }
                if (queryOutput != null && (f = ds.getField(queryOutput)) != null) {
                    outputType = f.getType();
                }
            }
            subRequest.setOutputs(DataTools.makeList((Object)queryOutput));
            subRequest.setPrimaryDSRequest(this.request);
            subRequest.setValueOperation(true);
            boolean limitQuery = true;
            String operator = (String)queryFieldData.get("_operator");
            if (operator != null && ("inSet".equalsIgnoreCase(operator) || "notInSet".equalsIgnoreCase(operator))) {
                limitQuery = false;
            }
            subRequest.buildFieldData(false);
            Object expr = SQLDataSource.getSQLClause(SQLClauseType.All, subRequest);
            if (limitQuery && this.driver.supportsSQLLimit()) {
                if (subRequest.getAttribute(SQLExpressions.class.getName()) == null) {
                    subRequest.setAttribute(SQLExpressions.class.getName(), (Object)this);
                }
                expr = SQLDataSource.getSingleRowForSubquery((String)expr, this.dataSource, subRequest, this.dataSource.getDriver());
            }
            expr = "(" + (String)expr + ")";
            expression = new SQLExpression(this.request, this.driver, this.dataSource, null).setExpr((String)expr).setQueryField().setSubSelect().setSubSelectDS(subRequest.getDataSourceName()).setOutputField(outputField).setOutputType(outputType);
        }
        return expression;
    }

    private SQLExpression addSubSelectForIncludeSummaryField(IncludeFromDefinition incFrom, String functionName) throws Exception {
        DSField field = incFrom.getThisField();
        final SummaryFunctionType includeSummaryFunction = SummaryFunctionType.valueOf((String)field.getProperty("includeSummaryFunction").toUpperCase());
        if (SummaryFunctionType.CONCAT.getFunctionName().equals(includeSummaryFunction.getFunctionName()) && !this.isConcatFetch(incFrom.getThisDataSource(), field.getName()) && this.driver.getDBType() != DBType.Oracle || "ARRAY".equalsIgnoreCase(includeSummaryFunction.getFunctionName())) {
            return new SQLExpression(this.request, this.driver, (SQLDataSource)incFrom.getThisDataSource(), field).setExpr("null").setAlias(field.getName()).setExprFullWithAlias("null AS " + field.getName());
        }
        SQLExpression expression = this.getExpression(field.getName());
        if (expression == null) {
            final String thisFieldName = incFrom.getThisFieldName();
            DSRequest req = new DSRequest(incFrom.getThisDataSource(), "fetch").setOutputs(DataTools.makeList((Object)thisFieldName)).setSummaryFunctions((Map)new HashMap(){
                {
                    this.put(thisFieldName, includeSummaryFunction);
                }
            }).setSummaryFunction(true);
            Object expr = SQLDataSource.getSQLClause(SQLClauseType.All, req);
            expression = new SQLExpression(this.request, this.driver, (SQLDataSource)incFrom.getThisDataSource(), field);
            if (this.driver.supportsSQLLimit()) {
                if (req.getAttribute(SQLExpressions.class.getName()) == null) {
                    req.setAttribute(SQLExpressions.class.getName(), (Object)this);
                }
                expr = SQLDataSource.getSingleRowForSubquery((String)expr, this.dataSource, req, this.dataSource.getDriver());
                expression.setSQLLimit();
            }
            expr = "(" + (String)expr + ")";
            expression.setExpr((String)expr).setSubSelect();
            if (functionName != null) {
                expr = this.driver.sqlOutTransformFunction((String)expr, functionName, (Map)field);
                expression.setFunction(functionName);
            }
            expr = this.driver.sqlCast((String)expr, field);
            expression.setExprFull((String)expr).setSqlCasted().setAlias(field.getName()).setExprFullWithAlias((String)expr + " AS " + field.getName());
        }
        return expression;
    }

    protected SQLExpression aggregationSubSelect(SQLDataSource ds, String columnName, String rsName, String tableName, DSField field) throws Exception {
        String relatedTable = field.getProperty("relatedTable");
        String relatedColumn = field.getProperty("relatedColumn");
        String localField = field.getProperty("localField");
        Object subselect = " (SELECT ";
        subselect = (String)subselect + "COUNT";
        subselect = (String)subselect + "(";
        subselect = (String)subselect + "*";
        subselect = (String)subselect + ") FROM ";
        subselect = (String)subselect + field.getProperty("relatedTable");
        subselect = (String)subselect + " WHERE ";
        subselect = (String)subselect + this.driver.sqlOutTransform(localField, localField, tableName, null, null);
        subselect = (String)subselect + " = ";
        subselect = (String)subselect + this.driver.sqlOutTransform(relatedColumn, relatedColumn, relatedTable, null, null);
        subselect = (String)subselect + ")";
        return new SQLExpression(this.request, this.driver, ds, field).setExpr((String)subselect).setExprFullWithAlias((String)subselect + " AS " + field.getName()).setAlias(field.getName()).setSubSelect();
    }

    protected SQLExpression customSQLExpression(SQLDataSource ds, DSField field) throws Exception {
        return this.customSQLExpression(ds, field, null);
    }

    protected SQLExpression customSQLExpression(SQLDataSource ds, DSField field, String functionName) throws Exception {
        SQLExpression expression = this.getExpression(field.getName());
        String custom = null;
        if (expression == null) {
            custom = field.getProperty("customSelectExpression");
            if (custom == null) {
                custom = field.getProperty("customSQLExpression");
            }
            if (custom == null) {
                custom = field.getProperty("serverFormula");
            }
            Map context = Velocity.getStandardContextMap((DSRequest)this.request);
            boolean searchForVelocityVariables = config.getBoolean((Object)"velocity.searchForVariables.enabled", true);
            if (!searchForVelocityVariables || custom.contains("$")) {
                custom = Velocity.evaluateWithSnippets((String)custom, (Map)context, (String)"customSelectExpression", (DSRequest)this.request, (boolean)field.getBoolean("autoQuoteCustomExpressions", true), (boolean)false);
            }
            expression = new SQLExpression(this.request, this.driver, ds, field).setExpr(custom).setCustomSQL();
            if (functionName != null) {
                custom = this.driver.sqlOutTransformFunction(custom, functionName, (Map)field);
                expression.setFunction(functionName).setExprFull(custom);
            }
            expression.setAlias(field.getName()).setExprFullWithAlias(custom + " AS " + field.getName());
        }
        return expression;
    }

    protected SQLExpression formula(SQLDataSource ds, DSField field, String functionName) throws Exception {
        return this.formula(ds, field, functionName, null);
    }

    protected SQLExpression formula(SQLDataSource ds, DSField field, String functionName, String alias) throws Exception {
        SQLExpression expression = this.getExpression(field.getName());
        if (expression == null) {
            Object formula = field.get((Object)"formula");
            String expr = null;
            expr = formula instanceof Map ? (String)((Map)formula).get("text") : (String)formula;
            expr = this.driver.transformFormula(expr);
            expression = new SQLExpression(this.request, this.driver, ds, field).setExpr(expr).setFormula();
            if (functionName != null) {
                expr = this.driver.sqlOutTransformFunction(expr, functionName, (Map)field);
                expression.setFunction(functionName);
            }
            expr = this.driver.sqlCast(expr, field);
            expression.setExprFull(expr).setSqlCasted().setAlias(alias == null ? field.getName() : alias).setExprFullWithAlias(expr + " AS " + (alias == null ? field.getName() : alias));
        }
        return expression;
    }

    protected SQLExpression valueOperation(SQLDataSource ds, DSField field, String functionName) throws Exception {
        return this.valueOperation(ds, field, functionName, null, null);
    }

    protected SQLExpression valueOperation(SQLDataSource ds, DSField field, String functionName, IncludeFromDefinition topIncFrom, IncludeFromDefinition targetIncFrom) throws Exception {
        SQLExpression expression = this.getExpression(field.getName());
        if (expression == null) {
            Relation r;
            String dsName;
            String[] valueOp = ((String)field.get((Object)"valueOperation")).split("\\.");
            if (valueOp.length < 2 || valueOp.length > 3) {
                log.warn((Object)("Field '" + ds.getName() + "." + field.getName() + "' has incorrectly declared valueOperation: '" + String.valueOf(field.get((Object)"valueOperation"))));
                return null;
            }
            String fieldName = valueOp[valueOp.length - 1];
            String operationId = valueOp[valueOp.length - 2];
            String string = dsName = valueOp.length == 2 ? null : valueOp[0];
            if (topIncFrom != null && targetIncFrom != null) {
                r = topIncFrom.getRelation();
                for (IncludeFromDefinition _target = topIncFrom.getTargetIncludeFrom(); _target != null && _target != targetIncFrom; _target = _target.getTargetIncludeFrom()) {
                    r.setNextRelation(_target.getRelation());
                }
            } else {
                r = ds.getRelation((DataSource)(dsName == null ? ds : DataSource.forName((String)dsName, (DSRequest)this.request)));
            }
            Relation connector = this.getConnectorRelation(r);
            r = SQLExpressions.inverseRelation(r.getNextRelation());
            Object forcedAlias = null;
            if (connector.getFromDataSource().getName().equals(connector.getToDataSource().getName()) && connector.getToAlias() == null) {
                forcedAlias = this.request.getForcedAlias();
                forcedAlias = forcedAlias == null ? "sub" : (String)forcedAlias + "_sub";
                connector.setToAlias((String)forcedAlias);
            }
            DSRequest req = new DSRequest(dsName == null ? ds.getName() : dsName, "fetch").setOperationId(operationId).setOutputs(DataTools.makeList((Object)fieldName)).setValueOperation(true).setSubqueryRelations(r).setSubqueryConnector(connector).setForcedAlias((String)forcedAlias);
            Object expr = SQLDataSource.getSQLClause(SQLClauseType.All, req);
            if (this.driver.supportsSQLLimit()) {
                if (req.getAttribute(SQLExpressions.class.getName()) == null) {
                    req.setAttribute(SQLExpressions.class.getName(), (Object)this);
                }
                expr = SQLDataSource.getSingleRowForSubquery((String)expr, this.dataSource, req, this.dataSource.getDriver());
            }
            expr = "(" + (String)expr + ")";
            expression = new SQLExpression(this.request, this.driver, ds, field).setExpr((String)expr).setSubSelect().setSubSelectDS(dsName == null ? ds.getName() : dsName).setSubSelectOperationId(operationId).setSubSelectFieldName(fieldName);
            if (functionName != null) {
                expr = this.driver.sqlOutTransformFunction((String)expr, functionName, (Map)field);
                expression.setFunction(functionName);
            }
            String alias = topIncFrom != null ? topIncFrom.getThisFieldName() : field.getName();
            expr = this.driver.sqlCast((String)expr, field);
            expression.setExprFull((String)expr).setSqlCasted().setAlias(alias).setExprFullWithAlias((String)expr + " AS " + alias);
        }
        return expression;
    }

    protected SQLExpression staticValue(SQLDriver driver, String fieldName, Map staticValueMap) throws Exception {
        SQLExpression expression = this.getExpression(fieldName);
        if (expression == null) {
            Map queryFieldData = (Map)staticValueMap.get("valueQuery");
            DSRequest subRequest = (DSRequest)queryFieldData.get("_validatedDSRequest");
            if (subRequest == null) {
                log.debug((Object)("Query field failed to create and validate sub-query fetching data from '" + String.valueOf(queryFieldData.get("dataSource")) + "' DataSource. Using NULL."));
                return new SQLExpression(this.request, driver, this.dataSource, null).setExpr("null");
            }
            DataSource ds = subRequest.getDataSource();
            String queryOutput = (String)queryFieldData.get("queryOutput");
            Map summaryFunctions = (Map)queryFieldData.get("summaryFunctions");
            List groupBy = (List)queryFieldData.get("groupBy");
            if (summaryFunctions != null && summaryFunctions.size() > 0) {
                if (queryOutput == null) {
                    queryOutput = (String)summaryFunctions.keySet().iterator().next();
                }
            } else if (groupBy != null && groupBy.size() > 0) {
                if (queryOutput == null) {
                    queryOutput = (String)groupBy.get(0);
                }
            } else {
                DSField firstField = null;
                DSField firstIntegerField = null;
                DSField firstFloatField = null;
                for (DSField field : ds.getFields()) {
                    if (firstField == null) {
                        firstField = field;
                    }
                    if (ds.simpleTypeInheritsFrom(field.getType(), "integer") && firstIntegerField == null) {
                        firstIntegerField = field;
                    }
                    if (!ds.simpleTypeInheritsFrom(field.getType(), "float") || firstFloatField != null) continue;
                    firstFloatField = field;
                }
                if (queryOutput == null) {
                    queryOutput = firstIntegerField != null ? firstIntegerField.getName() : (firstFloatField != null ? firstFloatField.getName() : firstField.getName());
                }
            }
            String expr = driver.sqlInTransform(staticValueMap.get("fieldStaticValue"), ds.getField(queryOutput), (SQLDataSource)ds);
            expression = new SQLExpression(this.request, driver, null, null).setExpr(expr);
        }
        return expression;
    }

    protected boolean isConcatFetch(DataSource ds, String fieldName) {
        if (this.request.isConcatFetchRequest()) {
            return true;
        }
        if (this.request.shouldStreamResults()) {
            log.warn((Object)("Field '" + ds.getName() + "." + fieldName + "' is configured to use 'CONCAT' summaryFunction and  DSRequest.streamResults is enabled. Both these features are not allowed in same request. Field will be skipped."));
            return false;
        }
        if (this.summaryFunctionFields == null) {
            this.summaryFunctionFields = new ArrayList<String>();
        }
        if (!this.summaryFunctionFields.contains(fieldName)) {
            this.summaryFunctionFields.add(fieldName);
        }
        return false;
    }

    static {
        formulaEnabled = config.getBoolean((Object)"sql.formula.enabled", true);
        templateEnabled = true;
        valueOperationEnabled = true;
        log = new Logger(SQLExpressions.class.getName());
    }
}

