/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.AbstractArrayOverlapsFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleArrayOverlapsFunction
extends AbstractArrayOverlapsFunction {
    public OracleArrayOverlapsFunction(TypeConfiguration typeConfiguration, boolean nullable) {
        super(nullable, typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression haystackExpression = (Expression)sqlAstArguments.get(0);
        String arrayTypeName = DdlTypeHelper.getTypeName(haystackExpression.getExpressionType(), walker.getSessionFactory().getTypeConfiguration());
        sqlAppender.appendSql(arrayTypeName);
        sqlAppender.append("_overlaps(");
        haystackExpression.accept(walker);
        sqlAppender.append(',');
        sqlAstArguments.get(1).accept(walker);
        sqlAppender.append(',');
        sqlAppender.append(this.nullable ? "1" : "0");
        sqlAppender.append(")>0");
    }
}

