/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.from.CorrelatedTableGroup;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;

public class CorrelatedPluralTableGroup
extends CorrelatedTableGroup
implements PluralTableGroup {
    private TableGroup indexTableGroup;
    private TableGroup elementTableGroup;

    public CorrelatedPluralTableGroup(TableGroup correlatedTableGroup, SqlAliasBase sqlAliasBase, QuerySpec querySpec, Consumer<Predicate> joinPredicateConsumer, SessionFactoryImplementor sessionFactory) {
        super(correlatedTableGroup, sqlAliasBase, querySpec, joinPredicateConsumer, sessionFactory);
    }

    @Override
    public PluralAttributeMapping getModelPart() {
        return (PluralAttributeMapping)super.getModelPart();
    }

    @Override
    public TableGroup getElementTableGroup() {
        return this.elementTableGroup;
    }

    @Override
    public TableGroup getIndexTableGroup() {
        return this.indexTableGroup;
    }

    public void registerIndexTableGroup(TableGroupJoin indexTableGroupJoin) {
        assert (this.indexTableGroup == null);
        this.indexTableGroup = indexTableGroupJoin.getJoinedGroup();
    }

    public void registerElementTableGroup(TableGroupJoin elementTableGroupJoin) {
        assert (this.elementTableGroup == null);
        this.elementTableGroup = elementTableGroupJoin.getJoinedGroup();
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, ValuedModelPart modelPart, String tableExpression, boolean resolve) {
        TableReference indexTableReference;
        TableReference tableReference = super.getTableReference(navigablePath, modelPart, tableExpression, resolve);
        if (tableReference != null) {
            return tableReference;
        }
        if (this.indexTableGroup != null && (navigablePath == null || this.indexTableGroup.getNavigablePath().isParent(navigablePath)) && (indexTableReference = this.indexTableGroup.getTableReference(navigablePath, modelPart, tableExpression, resolve)) != null) {
            return indexTableReference;
        }
        if (this.elementTableGroup != null && (navigablePath == null || this.elementTableGroup.getNavigablePath().isParent(navigablePath))) {
            TableReference elementTableReference = this.elementTableGroup.getTableReference(navigablePath, modelPart, tableExpression, resolve);
            return elementTableReference;
        }
        return null;
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean resolve) {
        TableReference indexTableReference;
        TableReference tableReference = super.getTableReference(navigablePath, tableExpression, resolve);
        if (tableReference != null) {
            return tableReference;
        }
        if (this.indexTableGroup != null && (navigablePath == null || this.indexTableGroup.getNavigablePath().isParent(navigablePath)) && (indexTableReference = this.indexTableGroup.getTableReference(navigablePath, tableExpression, resolve)) != null) {
            return indexTableReference;
        }
        if (this.elementTableGroup != null && (navigablePath == null || this.elementTableGroup.getNavigablePath().isParent(navigablePath))) {
            TableReference elementTableReference = this.elementTableGroup.getTableReference(navigablePath, tableExpression, resolve);
            return elementTableReference;
        }
        return null;
    }
}

