/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.hibernate;

import com.isomorphic.log.Logger;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.cfg.Configuration;

public class MetadataCache {
    private static Logger log = new Logger(MetadataCache.class.getName());
    private static final HashMap<Configuration, Metadata> metadataCache = new HashMap();

    public static synchronized Metadata get(Configuration configuration) {
        log.debug((Object)("Serving metadata for " + String.valueOf(configuration) + " from cache"));
        return MetadataCache.get(configuration, false);
    }

    public static synchronized Metadata get(Configuration configuration, boolean rebuild) {
        if (metadataCache.containsKey(configuration) && !rebuild) {
            return metadataCache.get(configuration);
        }
        log.info((Object)("Rebuilding metadata for " + String.valueOf(configuration)));
        try {
            Field sourcesField = Configuration.class.getDeclaredField("metadataSources");
            sourcesField.setAccessible(true);
            MetadataSources sources = (MetadataSources)sourcesField.get(configuration);
            Metadata metadata = sources.buildMetadata();
            metadataCache.put(configuration, metadata);
            return metadata;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Unable to extract MetadataSources from Configuration", e);
        }
    }

    public static synchronized void remove(Configuration configuration) {
        log.debug((Object)("Removing metadata for " + String.valueOf(configuration)));
        metadataCache.remove(configuration);
    }

    public static synchronized void invalidateCache() {
        log.info((Object)"Invalidating the cache.  All bindings will be removed.");
        metadataCache.clear();
    }
}

