/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.openapi;

import com.isomorphic.datasource.Validator;

public class ValidationDescriptions {
    static String getDescription(Validator validator) {
        String type = validator.getType();
        if ("isBoolean".equals(type)) {
            return ValidationDescriptions.isBooleanDescription();
        }
        if ("isString".equals(type)) {
            return ValidationDescriptions.isStringDescription();
        }
        if ("isInteger".equals(type)) {
            return ValidationDescriptions.isIntegerDescription(validator);
        }
        if ("isFloat".equals(type)) {
            return ValidationDescriptions.isFloatDescription();
        }
        if ("matchesField".equals(type)) {
            return ValidationDescriptions.matchesFieldDescription(validator);
        }
        if ("contains".equals(type)) {
            return ValidationDescriptions.containsDescription(validator);
        }
        if ("doesntContain".equals(type)) {
            return ValidationDescriptions.doesntContainDescription(validator);
        }
        if ("substringCount".equals(type)) {
            return ValidationDescriptions.substringCountDescription(validator);
        }
        if ("dateRange".equals(type)) {
            return ValidationDescriptions.dateRangeDescription(validator);
        }
        if ("floatPrecision".equals(type)) {
            return ValidationDescriptions.floatPrecisionDescription(validator);
        }
        if ("isUnique".equals(type)) {
            return ValidationDescriptions.isUniqueDescription(validator);
        }
        if ("hasRelatedRecord".equals(type)) {
            return ValidationDescriptions.hasRelatedRecordDescription(validator);
        }
        if ("serverCustom".equals(type)) {
            return ValidationDescriptions.serverCustomDescription(validator);
        }
        return null;
    }

    static String isBooleanDescription() {
        return "Value must be a boolean, and must not be empty.";
    }

    static String isStringDescription() {
        return "Value must be a String";
    }

    static String isIntegerDescription(Validator validator) {
        Object description = "Value must be a whole number.";
        Boolean convertToInteger = validator.getBoolean("convertToInteger");
        if (convertToInteger.booleanValue()) {
            description = (String)description + "  Note that float values will be converted into whole numbers and validation will succeed.";
        }
        return description;
    }

    static String isFloatDescription() {
        return "Value must be a valid floating point number.";
    }

    static String matchesFieldDescription(Validator validator) {
        String description = "Value must match the value of the '%s' field.";
        return String.format(description, validator.getProperty("otherField"));
    }

    static String containsDescription(Validator validator) {
        String description = "Value must contain the following substring: %s";
        return String.format(description, validator.getProperty("substring"));
    }

    static String doesntContainDescription(Validator validator) {
        String description = "Value must not contain the following substring: %s";
        return String.format(description, validator.getProperty("substring"));
    }

    static String substringCountDescription(Validator validator) {
        String description = "Value must contain the following substring %s %s times: %s";
        String operator = validator.getProperty("operator");
        String quantifier = "some number of";
        if ("==".equals(operator)) {
            quantifier = "exactly";
        } else if ("!=".equals(operator)) {
            quantifier = "not exactly";
        } else if ("<".equals(operator)) {
            quantifier = "fewer than";
        } else if ("<=".equals(operator)) {
            quantifier = "no more than";
        } else if (">".equals(operator)) {
            quantifier = "more than";
        } else if (">=".equals(operator)) {
            quantifier = "at least";
        }
        String count2 = validator.getProperty("count");
        String substring = validator.getProperty("substring");
        return String.format(description, quantifier, count2, substring);
    }

    static String dateRangeDescription(Validator validator) {
        String description = "Value must be a date between %s and %s, %s.  Note that the value should be specified in XML Schema date format.";
        String min2 = validator.getProperty("min");
        String max2 = validator.getProperty("max");
        String bound = "inclusive";
        if (validator.getBoolean("exclusive")) {
            bound = "exclusive";
        }
        return String.format(description, min2, max2, bound);
    }

    static String floatPrecisionDescription(Validator validator) {
        Object description = "Value must be a floating point number with %s decimal places.";
        String precision = validator.getProperty("precision");
        String roundToPrecision = validator.getProperty("roundToPrecision");
        if (roundToPrecision != null) {
            description = (String)description + "  Note that the value will be rounded, if necessary, to the nearest " + precision + " prior to validation.";
        }
        return String.format((String)description, precision);
    }

    static String isUniqueDescription(Validator v) {
        String criteriaFields = v.getProperty("criteriaFields");
        Boolean caseSensitive = v.getBoolean("caseSensitive");
        String template = "Value must be unique - no other record %s may have the same value%s.  Note that the check %s case-sensitive.  Note also that when isUnique validator is executed as part of validation process during update operation, it will perform uniqueness check only for single row updates.";
        String arg1 = "in the entire DataSource";
        Object arg2 = "";
        if (criteriaFields != null) {
            arg1 = "matching the following criteria";
            arg2 = ": [" + criteriaFields + "]";
        }
        String arg3 = "is not";
        if (caseSensitive.booleanValue()) {
            arg3 = "is";
        }
        return String.format(template, arg1, arg2, arg3);
    }

    private static String hasRelatedRecordDescription(Validator validator) {
        String relatedField;
        String description = "Record must exist at the %s DataSource, located by the %s field.";
        String relatedDataSource = validator.getProperty("relatedDataSource");
        if (relatedDataSource == null) {
            relatedDataSource = "Foreign Key";
        }
        if ((relatedField = validator.getProperty("relatedField")) == null) {
            relatedField = "Foreign Key";
        }
        return String.format(description, relatedDataSource, relatedField);
    }

    private static String serverCustomDescription(Validator validator) {
        String description = "Custom validator that evaluates field value using a %s";
        String arg1 = "custom server object.";
        if (validator.getServerCondition() != null) {
            arg1 = "Velocity expression, found in this validator's serverCondition.  Refer to the x-validators section for details.";
        }
        return String.format(description, arg1);
    }
}

