/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.sql.SQLExpression;

public class SQLUtils {
    private SQLUtils() {
    }

    public static abstract class Either<T, U> {
        private Either() {
        }

        public abstract Object getValue();

        public static <V, W> boolean isLeft(Either<V, W> either) {
            return either instanceof Left;
        }

        public static <V, W> boolean isRight(Either<V, W> either) {
            return either != null && !Either.isLeft(either);
        }

        public static <V, W> V fromLeft(Either<V, W> either, V defaultValue) {
            return (V)(either instanceof Left ? either.getValue() : defaultValue);
        }

        public static <V, W> W fromRight(Either<V, W> either, W defaultValue) {
            return (W)(either instanceof Right ? either.getValue() : defaultValue);
        }

        public static final class Left<T, U>
        extends Either<T, U> {
            private T value;

            public Left(T value) {
                this.value = value;
            }

            @Override
            public T getValue() {
                return this.value;
            }
        }

        public static final class Right<T, U>
        extends Either<T, U> {
            private U value;

            public Right(U value) {
                this.value = value;
            }

            @Override
            public U getValue() {
                return this.value;
            }
        }
    }

    public static class FieldInfo {
        public BasicDataSource ds;
        public DSField field;
        public String columnName;
        public String columnType;
        public String columnOrExpression;
        public String functionName;
        public SQLExpression expression;

        public FieldInfo(BasicDataSource ds, DSField field, String columnType, String columnOrExpression, String functionName, SQLExpression expression) {
            this.ds = ds;
            this.field = field;
            this.columnType = columnType;
            this.columnOrExpression = columnOrExpression;
            this.functionName = functionName;
            this.expression = expression;
        }
    }

    public static class Pair<T, U> {
        private final T first;
        private final U second;

        public Pair(T first, U second) {
            this.first = first;
            this.second = second;
        }

        public T getFirst() {
            return this.first;
        }

        public U getSecond() {
            return this.second;
        }
    }
}

