/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * An object representing a user-created formula. <p> Note that the current implementation of formulas simply executes the
 * {@link com.smartgwt.client.widgets.UserFormula#getText text} as a JavaScript string after making special variables and
 * methods available to the formula. It is safe to allow users to define formulas for themselves (since an end user can
 * always execute whatever JavaScript they want via the browser's built-in developer tools), and is safe to allow formulas
 * to be shared between trusted users.  However it would not be safe to allow an untrusted user to create formulas that are
 * shared to other users. <p> Also, while the current implementation would allow creation of a formula that calls
 * JavaScript functions which are not part of the standard or custom  MathFunctions, this behavior should not be relied
 * upon, as future versions of the formula engine may prohibit such calls. <p> {@link
 * com.smartgwt.client.widgets.grid.ListGrid}s additionally allow the formula to be user-modifiable, with the formula
 * created and edited with a FormulaBuilder, either directly or via the {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getCanAddFormulaFields ListGrid.canAddFormulaFields} behavior.
 * @see com.smartgwt.client.docs.FieldGeneration FieldGeneration overview and related methods
 */
@BeanFactory.FrameworkClass
public class UserFormula extends DataClass {

    public static UserFormula getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new UserFormula(jsObj);
    }
        


    public UserFormula(){
        
    }

    public UserFormula(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }


    public UserFormula(String text) {
        setText(text);
                
    }


    public UserFormula(String text, Map formulaVars) {
        setText(text);
		setFormulaVars(formulaVars);
                
    }



    // ********************* Properties / Attributes ***********************

    /**
     * Object mapping from variable names to field names.  All variable names must be single
     *  capital letters (e.g. A).  For example, for a formula that should divide the field
     *  "population" over the field "area", the formula might be "E/L" and formula vars would be:
     *  
     *  
     *  <pre>
     *    Map vars = new HashMap();
     *    vars.put("E", "population");
     *    vars.put("L", "area");
     *  </pre>
     *  
     *  <p>
     *  When used in the context of grid or detail viewer fields, field names are evaluated against the
     *  record.
     *  <p>
     *  When used in the context of forms and editing, this property is not used for formula mapping.
     * Instead, field names are evaluated directly against the current {@link com.smartgwt.client.widgets.Canvas#getRuleScope
     * rule context}.
     *  <p>
     * Formulas built by a FormulaBuilder for a {@link com.smartgwt.client.widgets.grid.ListGrid} will normally not define this
     *  property and the field names will be used directly, unless
     *   useSingleLetterKey is <code>true</code>.  However,
     *  the Builder may add mapping keys to avoid collisions with registered
     *   math functions.  When directly using field names in
     *  a formula, any mapping keys you add to avoid collisions should contain the string "Field"
     *  so that the Smart GWT Framework can detect when single-letter keys are not in use.
     *  <p>
     *  So, for example, if your grid contains a field "max" and you want to use it in a formula,
     *  your userFormula might look something like:
     *  <pre>
     *  {
     *      text: "max(maxField, 1000)",
     *      formulaVars: {
     *          maxField: "max"
     *      }
     *  }</pre>
     *  .. where the formula also uses the built-in  math function max().
     *
     * @param formulaVars New formulaVars value. Default value is null
     * @return {@link com.smartgwt.client.widgets.UserFormula UserFormula} instance, for chaining setter calls
     */
    public UserFormula setFormulaVars(Map formulaVars) {
        return (UserFormula)setAttribute("formulaVars", formulaVars);
    }

    /**
     * Object mapping from variable names to field names.  All variable names must be single
     *  capital letters (e.g. A).  For example, for a formula that should divide the field
     *  "population" over the field "area", the formula might be "E/L" and formula vars would be:
     *  
     *  
     *  <pre>
     *    Map vars = new HashMap();
     *    vars.put("E", "population");
     *    vars.put("L", "area");
     *  </pre>
     *  
     *  <p>
     *  When used in the context of grid or detail viewer fields, field names are evaluated against the
     *  record.
     *  <p>
     *  When used in the context of forms and editing, this property is not used for formula mapping.
     * Instead, field names are evaluated directly against the current {@link com.smartgwt.client.widgets.Canvas#getRuleScope
     * rule context}.
     *  <p>
     * Formulas built by a FormulaBuilder for a {@link com.smartgwt.client.widgets.grid.ListGrid} will normally not define this
     *  property and the field names will be used directly, unless
     *   useSingleLetterKey is <code>true</code>.  However,
     *  the Builder may add mapping keys to avoid collisions with registered
     *   math functions.  When directly using field names in
     *  a formula, any mapping keys you add to avoid collisions should contain the string "Field"
     *  so that the Smart GWT Framework can detect when single-letter keys are not in use.
     *  <p>
     *  So, for example, if your grid contains a field "max" and you want to use it in a formula,
     *  your userFormula might look something like:
     *  <pre>
     *  {
     *      text: "max(maxField, 1000)",
     *      formulaVars: {
     *          maxField: "max"
     *      }
     *  }</pre>
     *  .. where the formula also uses the built-in  math function max().
     *
     * @return Current formulaVars value. Default value is null
     */
    public Map getFormulaVars()  {
        return getAttributeAsMap("formulaVars");
    }
    

    /**
     * Formula to be evaluated. <p> There are two contexts where a <code>UserFormula</code> is used: {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getUserFormula ListGridField.userFormula} / {@link
     * com.smartgwt.client.widgets.viewer.DetailViewerField#getUserFormula DetailViewerField.userFormula} and {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getFormula FormItem.formula} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getEditorFormula ListGridField.editorFormula}. For the grid/detail viewer
     * field formula, all variables used by the formula must be single capital letters (e.g. A). These are derived from field
     * values for the record in question - see {@link com.smartgwt.client.widgets.UserFormula#getFormulaVars formulaVars}. <p>
     * In addition to these variables, the keyword <code>record</code> may be used to refer directly to the record for which
     * the formula is being evaluated. <p> In the context of forms and editing, variables are dot-separated (.) names
     * representing the nested hierarchy path to the desired value within the {@link
     * com.smartgwt.client.widgets.Canvas#getRuleScope rule context}. No mapping with {@link
     * com.smartgwt.client.widgets.UserFormula#getFormulaVars formulaVars} is needed. <p> The formula text must be valid
     * JavaScript code and may only call either the built-in  math functions or  custom functions. <p> This attribute is
     * writable only in {@link com.smartgwt.client.widgets.grid.ListGrid}s. Applications must call either {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setUserFormula ListGrid.setUserFormula()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setUserFormulaText ListGrid.setUserFormulaText()} to re-evaluate the formula.
     *
     * @param text New text value. Default value is null
     * @return {@link com.smartgwt.client.widgets.UserFormula UserFormula} instance, for chaining setter calls
     */
    public UserFormula setText(String text) {
        return (UserFormula)setAttribute("text", text);
    }

    /**
     * Formula to be evaluated. <p> There are two contexts where a <code>UserFormula</code> is used: {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getUserFormula ListGridField.userFormula} / {@link
     * com.smartgwt.client.widgets.viewer.DetailViewerField#getUserFormula DetailViewerField.userFormula} and {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getFormula FormItem.formula} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getEditorFormula ListGridField.editorFormula}. For the grid/detail viewer
     * field formula, all variables used by the formula must be single capital letters (e.g. A). These are derived from field
     * values for the record in question - see {@link com.smartgwt.client.widgets.UserFormula#getFormulaVars formulaVars}. <p>
     * In addition to these variables, the keyword <code>record</code> may be used to refer directly to the record for which
     * the formula is being evaluated. <p> In the context of forms and editing, variables are dot-separated (.) names
     * representing the nested hierarchy path to the desired value within the {@link
     * com.smartgwt.client.widgets.Canvas#getRuleScope rule context}. No mapping with {@link
     * com.smartgwt.client.widgets.UserFormula#getFormulaVars formulaVars} is needed. <p> The formula text must be valid
     * JavaScript code and may only call either the built-in  math functions or  custom functions. <p> This attribute is
     * writable only in {@link com.smartgwt.client.widgets.grid.ListGrid}s. Applications must call either {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setUserFormula ListGrid.setUserFormula()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setUserFormulaText ListGrid.setUserFormulaText()} to re-evaluate the formula.
     *
     * @return Current text value. Default value is null
     */
    public String getText()  {
        return getAttributeAsString("text");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
