
package com.smartgwt.client.docs;

/**
 * Skins are a collection of styles, images and other settings used to manage the overall 
 * appearance of an application. <P> A skin is typically in a single directory and consists of:
 * <ul> <li><i>load_skin.js</i> - this is essentially the bootstrap file for a skin.  It is     
 * responsible for loading the CSS for the skin, and contains global overrides for     Smart GWT
 * component properties that affect the appearance of those components.</li>
 * <li><i>skin_styles.css</i> - this file defines the set of CSS classes and styles      available
 * for styling the visual elements of Smart GWT components</li> <li><i>images/</i> - this
 * sub-directory typically contains all the icons and other images  needed by a skin</li> </ul>
 * Skins are loaded via the <code>skin</code> attribute of the {@link loadISCTag} or by including
 * the appropriate <code>load_skin.js</code> source file with a standard script include tag. <P>
 * You can create a custom skin with your own look and feel by copying an existing skin and 
 * modifying the media, CSS class definitions and component property overrides you wish to change.
 * <P> Note that the <code>load_skin.js</code> file contains a {@link
 * com.smartgwt.client.util.Page#setSkinDir Page.setSkinDir()} directive to set up the skin dir
 * (used to ensure media is retrieved from the appropriate directory), and a {@link
 * com.smartgwt.client.util.Page#loadStyleSheet Page.loadStyleSheet()} directive to load the .css
 * file. <P> See the {@link com.smartgwt.client.docs.Skinning Skinning Overview} for more
 * information.
     * @see com.smartgwt.client.docs.Appearance
     * @see com.smartgwt.client.docs.Images
     * @see com.smartgwt.client.docs.Files
 * @see com.smartgwt.client.util.Page#setSkinDir
 * @see com.smartgwt.client.util.Page#loadStyleSheet
 * @see com.smartgwt.client.util.Page#setAddVersionToSkinCSS
 * @see com.smartgwt.client.util.Page#isAddVersionToSkinCSS
 */
public interface Skins {
}
