
package com.smartgwt.client.docs;

/**
 * <h3>Grid row-range and row-count display</h3>
 * ListGrids are able to create a {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getRowRangeDisplay specialized label} that will
 * display the currently visible range of rows in the viewport along with a total row count for
 * the current data set. <P> When {@link com.smartgwt.client.data.DataSource#getProgressiveLoading
 * progressive loading is active}, the {@link com.smartgwt.client.data.ResultSet#getRowCount
 * reported row count} for list grid's  data may not accurately reflect the true number of rows in
 * the data set. <P> See {@link com.smartgwt.client.types.RowCountStatus} for more details. Note
 * that for custom dataSources where progressive loading is active, the  {@link
 * com.smartgwt.client.data.DSResponse#getEstimatedTotalRows DSResponse.estimatedTotalRows} may be
 * used to explictly provide either an estimated or exact row count for the data set (distinct
 * from the reported {@link com.smartgwt.client.data.DSResponse#getTotalRows
 * DSResponse.totalRows}. <P> When the true size of the data set is not known, the
 * <code>rowRangeDisplay</code> will format the reported length in a way that indicates it is not
 * an exact count (see {@link com.smartgwt.client.widgets.grid.ListGrid#getFormattedRowCount
 * ListGrid.getFormattedRowCount()}). If {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchRowCount ListGrid.autoFetchRowCount} is
 * set to <code>true</code>, a separate row count fetch will be intiated as soon as data arrives,
 * so an accurate row count will be displayed as soon as that fetch completes. Alternatively, if
 * {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRequestRowCount
 * ListGrid.canRequestRowCount} is set to <code>true</code>, the user may click the label to issue
 * a row count fetch request and get back an accurate row count to display to the user.  <P> As an
 * alternative to using the <code>rowRangeDisplay</code> autoChild, developers  may also make use
 * of various list grid APIs such as {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getRowCountStatus ListGrid.getRowCountStatus()},
 * {@link com.smartgwt.client.widgets.grid.ListGrid#getRowCount ListGrid.getRowCount()}, {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getRowRangeDisplayValue
 * ListGrid.getRowRangeDisplayValue()} and {@link
 * com.smartgwt.client.widgets.grid.ListGrid#fetchRowCount ListGrid.fetchRowCount()} to directly
 * display or retrieve row counts.
 * @see com.smartgwt.client.types.RowCountStatus
 * @see com.smartgwt.client.types.RowRangeDisplayStyle
 * @see com.smartgwt.client.data.ResultSet#getRowCountStatus
 * @see com.smartgwt.client.data.ResultSet#getRowCount
 * @see com.smartgwt.client.data.ResultSet#getRowCountRange
 * @see com.smartgwt.client.data.ResultSet#fetchRowCount
 * @see com.smartgwt.client.widgets.grid.ListGrid#getRowRangeDisplay
 * @see com.smartgwt.client.widgets.grid.ListGrid#getRowRangeDisplayValue
 * @see com.smartgwt.client.widgets.grid.ListGrid#getFormattedRowCount
 * @see com.smartgwt.client.widgets.grid.ListGrid#getRowCount
 * @see com.smartgwt.client.widgets.grid.ListGrid#getRowCountRange
 * @see com.smartgwt.client.widgets.grid.ListGrid#getRowCountStatus
 * @see com.smartgwt.client.widgets.grid.ListGrid#fetchRowCount
 * @see com.smartgwt.client.widgets.grid.RowRangeDisplay#setSourceGrid
 * @see com.smartgwt.client.widgets.grid.RowRangeDisplay
 * @see com.smartgwt.client.data.ResultSet#getApplyRowCountToLength
 * @see com.smartgwt.client.data.ResultSet#getRowCountOperation
 * @see com.smartgwt.client.data.ResultSet#getRowCountContext
 * @see com.smartgwt.client.data.ResultSet#getBlockingRowCountFetch
 * @see com.smartgwt.client.widgets.grid.ListGrid#getRowRangeDisplay
 * @see com.smartgwt.client.widgets.grid.ListGrid#getCanRequestRowCount
 * @see com.smartgwt.client.widgets.grid.ListGrid#getApplyRowCountToLength
 * @see com.smartgwt.client.widgets.grid.ListGrid#getBlockingRowCountFetch
 * @see com.smartgwt.client.widgets.grid.ListGrid#getRowRangeDisplayStyle
 * @see com.smartgwt.client.widgets.grid.ListGrid#getLoadingRowCountDisplayIcon
 * @see com.smartgwt.client.widgets.grid.ListGrid#getLoadingRowCountDisplayIconWidth
 * @see com.smartgwt.client.widgets.grid.ListGrid#getLoadingRowCountDisplayIcoHeight
 * @see com.smartgwt.client.widgets.grid.ListGrid#getExactRowCountFormat
 * @see com.smartgwt.client.widgets.grid.ListGrid#getMinimumRowCountFormat
 * @see com.smartgwt.client.widgets.grid.ListGrid#getApproximateRowCountFormat
 * @see com.smartgwt.client.widgets.grid.ListGrid#getMaximumRowCountFormat
 * @see com.smartgwt.client.widgets.grid.ListGrid#getRangeRowCountFormat
 * @see com.smartgwt.client.widgets.grid.ListGrid#getRowCountDisplayPrecision
 * @see com.smartgwt.client.widgets.grid.RowRangeDisplay#getWrap
 * @see com.smartgwt.client.widgets.grid.RowRangeDisplay#getAlign
 * @see com.smartgwt.client.widgets.grid.RowRangeDisplay#getVlign
 * @see com.smartgwt.client.widgets.grid.RowRangeDisplay#getSourceGrid
 * @see com.smartgwt.client.widgets.grid.RowRangeDisplay#getCanRequestRowCount
 * @see com.smartgwt.client.widgets.grid.RowRangeDisplay#getInteractiveStyleName
 */
public interface RowRangeDisplay {
}
