/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */

package com.smartgwt.sample.showcase.client.dataintegration.java.sql;

import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.data.Criteria;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.DSCallback;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.events.SelectionChangedHandler;
import com.smartgwt.client.widgets.grid.events.SelectionEvent;
import com.smartgwt.client.types.SelectionStyle;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class ServerFormulaSample extends ShowcasePanel {

    private static final String DESCRIPTION =
        "This example demonstrates how to use DataSourceField formulas and summary functions to dynamically calculate"+ 
        "and display values."+ 
        "<P>"+ 
        "The first grid displays a list of line items from a single order. In this grid, the \"Total Cost\" field is "+
        "dynamically calculated on the server by applying a formula to multiply the unit cost by the quantity for "+
        "each item. This is achieved using the <code>dataSourceField.formula</code> property."+
        "<P>"+
        "The second grid shows a list of orders. Selecting an order within this grid will update the first grid to "+
        "display the items from that order."+
        "<P>"+
        "In the orders grid, the \"Order Total\" field is calculated by aggregating the \"Total Cost\" values from the "+
        "line items within each order. This is done using the <code>includeFrom</code> property to pull in the "+
        "calculated \"Total Cost\" field from the line items, and the <code>includeSummaryFunction</code> to sum "+
        "these values across the order.";

    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
            ServerFormulaSample panel = new ServerFormulaSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {

        ListGrid orderLineGrid = new ListGrid();
        orderLineGrid.setDataSource(DataSource.get("OrderLine_FormulaField"));
        orderLineGrid.setWidth(700);
        orderLineGrid.setHeight(224);
        orderLineGrid.setAutoFetchData(false);
        orderLineGrid.setIsGroup(true);
        orderLineGrid.setGroupTitle("Items in Order #");
        orderLineGrid.setShowAllColumns(true);
    	
        ListGrid orderGrid = new ListGrid();
        orderGrid.setDataSource(DataSource.get("Order_AggregatedField"));
        orderGrid.setWidth(700);
        orderGrid.setHeight(224);
        orderGrid.setAutoFetchData(false);
        orderGrid.setIsGroup(true);
        orderGrid.setGroupTitle("Orders showing total cost");
        orderGrid.setShowAllColumns(true);
        orderGrid.setSelectionType(SelectionStyle.SINGLE);
        orderGrid.addSelectionChangedHandler(new SelectionChangedHandler() {
            @Override
            public void onSelectionChanged(SelectionEvent event) {
                String orderNumber = event.getSelectedRecord().getAttribute("orderNumber");
                Criteria criteria = new Criteria();
                criteria.addCriteria("orderNumber", orderNumber);
                orderLineGrid.fetchData(criteria);
                orderLineGrid.setGroupTitle("Items in Order #"+orderNumber);
            }
        });
    	
        VLayout vLayout = new VLayout();
        vLayout.setHeight("100%");
        vLayout.setWidth(500);
        vLayout.setMembersMargin(10);
        vLayout.addMembers(orderLineGrid, orderGrid);
        
        orderGrid.fetchData(null, new DSCallback() {
            @Override
            public void execute(DSResponse dsResponse, Object data, DSRequest dsRequest) {
                orderGrid.selectRecord(0);
            }
    	});
    	
        return vLayout;
    }

    public String getIntro() {
        return DESCRIPTION;
    }

}
