/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.componentXML;

import java.util.HashMap;
import java.util.Map;

import com.smartgwt.client.rpc.LoadScreenCallback;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.rpc.LoadScreenSettings;
import com.smartgwt.client.rpc.Project;
import com.smartgwt.client.rpc.RPCManager;
import com.smartgwt.client.rpc.RPCResponse;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.ButtonItem;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class VerifyingScreensXMLSample extends ShowcasePanel {

    private static final String DESCRIPTION =
        "You can declare your code's specific dependencies on components within a "+
        "loaded screen, so that if the screen is changed, you know about the problem immediately."+
        "<p>"+
        "Declare <code>verifyComponents</code> when creating a screen to get a warning if a loaded "+
        "screen is missing expected components, or if they have the wrong types."+
        "<p>"+
        "Click on \"Load Project\" below to see warnings telling you that the screen is missing "+
        "components where your code wanted to add handlers.";

    public static class Factory implements PanelFactory {

        private String id;

        public ShowcasePanel create() {
            VerifyingScreensXMLSample panel = new VerifyingScreensXMLSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    @Override
    protected boolean isTopIntro() {
        return true;
    }
    
    public Canvas getViewPanel() {
        
        final VLayout container = new VLayout();  
        container.setWidth100();  
        container.setHeight100(); 
        container.setMembersMargin(20);
        
		IButton button = new IButton();  
        button.setTitle("Load Project");  
        button.setWidth(100);  
        button.addClickHandler(new ClickHandler() {  
            @Override  
            public void onClick(ClickEvent event) {  

            	LoadScreenSettings settings = new LoadScreenSettings();
	            settings.setVerifyAsError(true);
	            Map<String,String> componentsMap = new HashMap<String,String>();
	            componentsMap.put("simpleForm.saveDataButton", "ButtonItem");
	            settings.setVerifyComponents(componentsMap);
                settings.setWillHandleError(false);

                RPCManager.loadScreen("verifyingScreensXML", new LoadScreenCallback() {

					@Override
					public void execute() {
						Canvas screen = this.getScreen();
						final DynamicForm saveForm = (DynamicForm)screen.getByLocalId("simpleForm");
                        ButtonItem saveButton = (ButtonItem)saveForm.getField("saveDataButton");
                        if (saveButton != null) {
	                        saveButton.addClickHandler(new com.smartgwt.client.widgets.form.fields.events.ClickHandler() {  
	                            @Override  
	                            public void onClick(com.smartgwt.client.widgets.form.fields.events.ClickEvent event) {  
	                                Map values = saveForm.getValues();  
	                                if (!Boolean.TRUE.equals((Boolean)values.get("inStock")) && values.get("nextShipment") == null) {    
	                                    SC.warn("New stock items which are not already stocked must have a Stock Date");    
	                                }  
	                            }  
	                        });
                        }
                        Canvas target = container.getMember(1);
                        if (target != null) container.replaceMember(target, screen);
                        else container.addMember(screen); 
						
					}
	            	
	            }, settings, null);
                
            }  
        });  
        container.addMember(button);

        return container;
    }
    
    @Override
    public String getIntro() {
        return DESCRIPTION;
    }
    

	public SourceEntity[] getSourceUrls() {
        return new SourceEntity[] {
			new SourceEntity("shared/ui/verifyingScreensXML.ui.xml", XML, "source/verifyingScreensXML.ui.xml.html", true)
        };
    }


}
