/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.componentXML;

import com.smartgwt.client.rpc.RPCManager;
import com.smartgwt.client.rpc.LoadScreenCallback;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class DeclarativeActions extends ShowcasePanel {

    private static final String DESCRIPTION =
        "Common actions can be declared directly in XML rather than having to include <smartgwt>Java</smartgwt> code."+
        "<p>"+
        "This sample shows a grid with some buttons to trigger various behaviors. Other than the trivial code to "+
        "load the XML screen definition, there is no Java code, it's all XML declarations."+
        "<p>"+
        "Click \"Fetch\" to get some data in the grid. Click grid rows and note how the \"Remove Selected\" button "+
        "becomes enabled. Click it to remove the selected record.  You can also click \"Export\" to get a CSV export of the grid's data."+
        "<p>"+
        "Look at the XML source for this sample:"+
        "<ul>"+
        "<li> the \"Fetch\", \"Export\" and \"Remove Selected\" buttons are all triggered via Actions."+
        "<li> the <code>enabledWhen</code> attribute is used to make the \"Remove Selected\" button only active if there's a selection."+
        "</ul>";

    public static class Factory implements PanelFactory {

        private String id;

        public ShowcasePanel create() {
            DeclarativeActions panel = new DeclarativeActions();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    @Override
    protected boolean isTopIntro() {
        return true;
    }
    
    public Canvas getViewPanel() {

		final Canvas container = new Canvas();
		container.setWidth100();
		container.setHeight100();
		
		RPCManager.loadScreen("declarativeActions", new LoadScreenCallback() {
			@Override
			public void execute() {
				container.addChild(this.getScreen());
			}
		});

        return container;
    }
    
    @Override
    public String getIntro() {
        return DESCRIPTION;
    }

    @Override
    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[]{
            new SourceEntity("declarativeActions.ui.xml", XML, "source/declarativeActions.ui.xml.html", true)
        };
    }
}