/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.componentXML;

import com.smartgwt.client.rpc.RPCManager;
import com.smartgwt.client.rpc.LoadScreenCallback;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class BooleanDynamicProperties extends ShowcasePanel {

    private static final String DESCRIPTION = "Any boolean (true/false) property on a component can be declared to react to application state, \r" +
        "without writing any code.\r" +
        "<p>\r" +
        "This sample shows a screen to allow a user to configure an export of a grid.  Other than the trivial code to \r" +
        "load the XML screen definition, there is no <smartclient>JavaScript</smartclient> code, it's all XML declarations.\r" +
        "<ul>\r" +
        "<li> boolean DynamicProperties on the ListGrid definition are used to configure export settings (<code>listGrid.exportFieldWidths</code>, \r" +
        "<code>listGrid.exportFieldAlignments</code> and <code>listGrid.exportDisplay</code>), based on selected values in a form.\r" +
        "<li> DynamicProperties are also used to set the export format attribute (<code>listGrid.exportAs</code>).\r" +
        "<li> an Action is used to trigger export from the \"Export\" button.\r" +
        "</ul>\r" +
        "Click the \"Export\" button and see the default export.  Then use the \"Export Type\" drop-down to switch the export file format\r" +
        "and click \"Export\" again.<br>\r" +
        "The \"Export\" button click Action simply tells the grid to export its data. The grid itself determines the correct export format\r" +
        "thanks to the Dynamic property declaration on <code>listGrid.exportAs</code>.\r" +
        "<p>\r" +
        "Similarly, when exporting to XLS or OOXML, try clicking the \"Export Field Widths\" and \"Export Field Alignments\" checkboxes.\r" +
        "The Dynamic <code>listGrid.exportFieldAlignments</code> and <code>listGrid.exportFieldWidths</code> properties pick up the\r" +
        "new values, causing the appropriate settings to be applied to the export.";

    public static class Factory implements PanelFactory {

        private String id;

        public ShowcasePanel create() {
            BooleanDynamicProperties panel = new BooleanDynamicProperties();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    @Override
    protected boolean isTopIntro() {
        return true;
    }
    
    public Canvas getViewPanel() {

		final Canvas container = new Canvas();
		container.setWidth100();
		container.setHeight100();
		
		RPCManager.loadScreen("booleanDynamicProperties", new LoadScreenCallback() {
			@Override
			public void execute() {
				container.addChild(this.getScreen());
			}
		});

        return container;
    }
    
    @Override
    public String getIntro() {
        return DESCRIPTION;
    }

    @Override
    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[]{
            new SourceEntity("booleanDynamicProperties.ui.xml", XML, "source/booleanDynamicProperties.ui.xml.html", true)
        };
    }
}