/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.util;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Contains utilities and constants to support asynchronous code.
 */
@BeanFactory.FrameworkClass
public class AsyncUtil {


    // ********************* Static Attributes ***********************

    // ********************* Properties / Attributes ***********************

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

	/**
     * Returns a user-displayable message for the given {@link com.smartgwt.client.util.AsyncOperationResult} if its {@link
     * com.smartgwt.client.util.AsyncOperationResult#getType type} is not SUCCESS. <p> {@link
     * com.smartgwt.client.util.isc#getAsyncMessage isc.getAsyncMessage()} and {@link
     * com.smartgwt.client.util.AsyncUtil#getAsyncMessage AsyncUtil.getAsyncMessage()} are equivalent.
     * @param result the <code>AsyncOperationResult</code>.
     *
     * @return If the {@link com.smartgwt.client.util.AsyncOperationResult#getType type} is SUCCESS, then <code>null</code>; otherwise,
     * a user-displayable message describing the non-successful result.
     * See {@link com.smartgwt.client.docs.HTMLString HTMLString}
     * @see com.smartgwt.client.util.AsyncUtil#asyncErrorMessageGeneric
     * @see com.smartgwt.client.util.AsyncUtil#asyncCanceledMessage
     * @see com.smartgwt.client.util.AsyncUtil#asyncCanceledMessageGeneric
     * @see com.smartgwt.client.util.AsyncUtil#asyncDisabledMessageGeneric
     * @see com.smartgwt.client.util.AsyncUtil#asyncNonSuccessMessage
     * @see com.smartgwt.client.util.AsyncUtil#asyncNonSuccessMessageGeneric
     */
    public static native String getAsyncMessage(AsyncOperationResult result) /*-{
        var ret = $wnd.isc.AsyncUtil.getAsyncMessage(result.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret;
    }-*/;


    // ***********************************************************

}
