
package com.smartgwt.client.docs;

/**
 * <h3><code>includeVia</code> syntax</h3>
 * <h3>Overview</h3>
 * The {@link com.smartgwt.client.docs.serverds.DataSourceField#includeVia includeVia} attribute
 * is used in conjunction with
 * {@link com.smartgwt.client.docs.serverds.DataSourceField#includeFrom includeFrom} to resolve
 * ambiguity when multiple foreign keys point to the
 * same related DataSource. It allows you to explicitly specify which foreign key path should be
 * used to retrieve
 *  data from the related DataSource.
 *  <p>
 *  In its simplest form, includeVia references a single foreign key field, such as:
 *  <pre>
 *  &lt;field name="salesRepEmployeeNumber" type="integer" foreignKey="Employee.employeeNumber" /&gt;
 *  &lt;field name="salesRepLastName" includeFrom="Employee.lastName" includeVia="salesRepEmployeeNumber" /&gt;
 *  &lt;field name="accountMgrEmployeeNumber" type="integer" foreignKey="Employee.employeeNumber" /&gt;
 *  &lt;field name="accountMgrLastName" includeFrom="Employee.lastName" includeVia="accountMgrEmployeeNumber" /&gt;
 *  </pre>
 * In more complex scenarios, where relationships span multiple DataSources or involve composite
 * foreign keys,
 * <code>includeVia</code> can define an indirect relation chain ? a multi-step path of linked
 * DataSources leading
 * to the target field. This allows precise control over relation resolution, especially when
 * there are multiple
 * possible foreign key paths between DataSources, and you want deterministic control over how
 * relations are resolved,
 *  overriding default Smart GWT behavior.
 *  <p>
 * For example, to resolve the chain <code>Order &gt; Customer &gt; Employee &gt; Office</code>,
 * you can use
 * <code>includeVia</code> to specify which foreign keys (single-field or composite) to follow at
 * each step.
 *  <h3>Syntax</h3>
 *  <code>[dsName.]field1-field2:[dsName.]field3-field4...</code>
 *  <ul>
 *  <li/><code>"."</code> separates a DataSource ID from its field / composite key fields
 *  <li/><code>"-"</code> separates fields that are part of a composite key
 *  <li/><code>":"</code> separates relation steps across different DataSources
 *  </ul>
 *  Datasource names are optional if field names are unambiguous across the chain.
 *  <h3>Behavior & Rules</h3>
 *  <ul>
 * <li/>Each segment must refer to a defined {@link
 * com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey} (or listed in
 * {@link com.smartgwt.client.docs.serverds.DataSourceField#otherFKs otherFKs} in the
 * corresponding DataSource.
 * <li/>Once <code>includeVia</code> is used, the chain must follow the segments as specified,
 * without skipping intermediate DataSources.
 *  <li/>After the last segment of includeVia, relation detection can proceed using default logic.
 *  <li/>The same format and rules apply whether keys are single-field or composite.
 *  <li/>Works identically for both includeVia and queryFK.
 *  </ul>
 *  <h3>Composite PK usage notes</h3>
 * Support for composite primary keys in <code>includeVia</code> is available, but should be used
 * with caution.
 * While there are valid use cases ? such as modeling compound identifiers or many-to-many
 * relationships
 * with additional attributes ? the need for composite keys is relatively rare in modern schema
 * design.
 *  <p>
 * Composite keys are most often found in legacy systems, and their use typically reflects
 * limitations or
 * design choices made before more scalable patterns were available. For multi-tenancy
 * specifically, we
 * strongly recommend using {@link com.smartgwt.client.docs.MultiTenancy Smart GWT?s transparent
 * multi-tenancy} approach, which
 * provides clean tenant separation without duplicating schema or embedding tenancy logic in
 * primary keys.
 *  <p>
 *  If you're working with a legacy system and need to preserve existing composite key structures,
 * <code>includeVia</code> does support this pattern. For example, some systems use a
 * <i>domainKey</i> or a similar
 * field as part of composite keys to simulate multi-tenancy ? this approach is supported, but not
 * recommended
 * for new development. See {@link com.smartgwt.client.docs.IncludeViaAndDomainKey} for more
 * details.
 *  <h3>Examples</h3>
 *  All examples are based on the DataSources shown at the end of this section.
 *  <p>
 * Note that <code>Customer &gt; Employee</code> relation can use foreignKey field
 * <code>accountMgrEmployeeNumber</code>
 * (Account manager) or foreignKey field <code>salesRepEmployeeNumber</code> (Sales
 * representative).
 *  <p>
 *  All examples below resolve the same relation chain:
 *  <pre>
 *  Order &gt; Customer (via accountMgrEmployeeNumber) &gt; Employee &gt; Office
 *  </pre>
 *  <h4>Example 1: Full path specified</h4>
 *  Explicit composite keys at every step.
 *  <pre>
 *  includeFrom="Customer.Employee.Office.city"
 *  includeVia="Order.customerNumber:Customer.accountMgrEmployeeNumber:Employee.officeCode"
 *  </pre>
 *  <h4>Example 2: Partial includeVia with omitted datasource names</h4>
 *  Unambiguous field names allow datasource names to be omitted.
 *  <pre>
 *  includeFrom="Customer.Employee.Office.city"
 *  includeVia="customerNumber:accountMgrEmployeeNumber"
 *  </pre>
 *  <h4>Example 3: Minimal includeVia</h4>
 *  Only the override for the non-default FK path is needed; the rest is resolved automatically.
 *  <pre>
 *  includeFrom="Customer.Employee.Office.city"
 *  includeVia="accountMgrEmployeeNumber"
 *  </pre>
 *  <h4>Example 4: Shorter includeFrom with full includeVia</h4>
 * The includeFrom starts mid-chain, but includeVia ensures correct relation chain from the base
 * DataSource.
 *  <pre>
 *  includeFrom="Employee.Office.city"
 *  includeVia="Order.customerNumber:Customer.accountMgrEmployeeNumber:Employee.officeCode"
 *  </pre>
 *  <h4>Example 5: Minimal includeFrom and includeVia</h4>
 *  System finds shortest valid path from base to target using the provided override.
 *  <pre>
 *  includeFrom="Office.city"
 *  includeVia="accountMgrEmployeeNumber"
 *  </pre>
 *  <h4>Datasources used in samples:</h4>
 *  <pre>
 *  &lt;DataSource ID="Order" serverType="sql"&gt;
 *      &lt;fields&gt;
 *          &lt;field name="orderNumber" type="integer" primaryKey="true" /&gt;
 *          &lt;field name="orderDate" type="date" required="true"/&gt;
 *          &lt;field name="customerNumber" type="integer" foreignKey="Customer.customerNumber" /&gt;
 *      &lt;/fields&gt;
 *  &lt;/DataSource&gt;
 *  </pre>
 *  <pre>
 *  &lt;DataSource ID="Customer" serverType="sql"&gt;
 *      &lt;fields&gt;
 *          &lt;field name="customerNumber" type="integer" primaryKey="true" /&gt;
 *          &lt;field name="customerName" type="text" required="true"/&gt;
 *          &lt;field name="salesRepEmployeeNumber" type="integer" foreignKey="Employee.employeeNumber" /&gt;
 *          &lt;field name="accountMgrEmployeeNumber" type="integer" foreignKey="Employee.employeeNumber" /&gt;
 *      &lt;/fields&gt;
 *  &lt;/DataSource&gt;
 *  </pre>
 *  <pre>
 *  &lt;DataSource ID="Employee" serverType="sql"&gt;
 *      &lt;fields&gt;
 *          &lt;field name="employeeNumber" type="integer" primaryKey="true" /&gt;
 *          &lt;field name="lastName" type="text" required="true"/&gt;
 *          &lt;field name="firstName" type="text" required="true"/&gt;
 *          &lt;field name="officeCode" type="text" foreignKey="Office.officeCode" /&gt;
 *      &lt;/fields&gt;
 *  &lt;/DataSource&gt;
 *  </pre>
 *  <pre>
 *  &lt;DataSource ID="Office" serverType="sql"&gt;
 *      &lt;fields&gt;
 *          &lt;field name="officeCode" type="text" primaryKey="true" /&gt;
 *          &lt;field name="city" type="text" /&gt;
 *      &lt;/fields&gt;
 *  &lt;/DataSource&gt;
 *  </pre>
 */
public interface IncludeViaSyntax {
}
