/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;
import org.xml.sax.InputSource;

public class MockDataSource
extends BasicDataSource {
    private static Logger log = new Logger(MockDataSource.class.getName());
    private static final Set<String> SAFE_CLASS_PROPERTIES = new HashSet<String>(Arrays.asList("ID", "description", "preventhttpcaching", "quoteTableName", "quoteColumnNames", "logSlowSQL", "logSlowFetch", "logSlowAdd", "logSlowUpdate", "logSlowRemove", "fields", "auditedDataSourceID", "generateAuditDS", "sequenceMode", "useSequences", "patternSingleWildcard", "patternMultiWildcard", "patternEscapeChar", "fromServer", "translatePatternOperators", "criteriaPolicy", "defaultTExtMatchStyle", "clientOnly", "ignoreTextMatchStyleCaseSensitive", "useLocalValidators", "requiredMessage", "showPrompt", "enumTranslateStrategy", "enumConstantProperty", "enumOrdinalProperty", "autoDeriveTitles", "canMultiSort", "sparseUpdates", "noNullUpdates", "isServerDS", "omitNullDefaultsOnAdd", "nullStringValue", "nullIntegerValue", "nullBooleanValue", "nullDateValue", "autoJoinTransactions", "sqlPaging", "sqlUsePagingHint", "endGap", "operationBindings", "progressiveLoading", "progressiveLoadingThreshold", "lookAhead", "cacheAllData", "cacheMaxAge", "cacheData", "testData", "autoCacheAllData", "sample", "autoConvertRelativeDates", "trimMilliseconds", "audit", "auditDataSourceID", "title", "pluralTitle", "titleField", "iconField", "infoField", "dataField", "descriptionField", "childrenField", "qualifyColumnNames", "validateRelatedRecords", "multiInsertStrategy", "multiInsertBatchSize", "multiInsertNonMatchingStrategy", "cacheSyncStrategy", "defaultMultiUpdatePolicy", "strictSQLFiltering", "__autoConstruct", "constructor", "allowAdvancedCriteria", "mockData", "mockDataFormat", "mockDataType", "mockDataPrimaryKey", "fieldNamingConvention", "detectFieldTypes"));
    private static final Set<String> VELOCITY_FIELD_PROPERTIES = new HashSet<String>(Arrays.asList("viewRequires", "editRequires", "initRequires", "updateRequires"));
    private static final Set<String> SAFE_FIELD_PROPERTIES = SetUtils.union(VELOCITY_FIELD_PROPERTIES, new HashSet<String>(Arrays.asList("name", "description", "type", "mimeType", "required", "requiredMessage", "nillable", "valueMap", "valueMapEnum", "length", "title", "escapeHTML", "canView", "canEdit", "canSave", "canFilter", "displayFormat", "dateFormatter", "timeFormatter", "decimalPrecision", "decimalPad", "precision", "hidden", "ignore", "detail", "excludeFromState", "emptyDisplayValue", "primaryKey", "foreignKey", "childrenProperty", "rootValue", "sequenceName", "implicitSequence", "includeFrom", "includeVia", "formula", "displayField", "useLocalDisplayFieldValue", "foreignDisplayField", "viewRequiresRole", "sqlForceInsensitive", "multiple", "multipleValueSeparator", "multipleStorage", "multipleStorageSeparator", "showFileInline", "imageWidth", "imageHeight", "imageSize", "audit", "sqlStorageStrategy", "sqlDateFormat", "storeMilliseconds", "sqlTrueValue", "sqlFalseValue", "nullReplacementValue", "sortByField", "ignoreTextMatchStyle", "maxFileSize", "encodeInResponse", "fieldTreeId", "fieldTreeParentId", "format", "validOperators", "defaultOperator", "validators", "editRequiresRole", "joinType", "includeSummaryFunction", "typeExplicitlyDeclared")));
    private static final Set<String> SAFE_OP_BINDING_PROPERTIES = new HashSet<String>(Arrays.asList("operationType", "requiresRole", "requires"));
    private static final Set<String> SAFE_VALIDATOR_PROPERTIES = new HashSet<String>(Arrays.asList("type", "name", "description", "applyWhen", "dependentFields", "errorMessage", "ID", "stopIfFalse", "stopOnError", "validateOnChange", "caseSensitive", "min", "max", "exclusive", "checkComponentData", "serverOnly", "precision", "roundToPrecision", "criteriaFields", "otherField", "list", "substring", "count", "expression", "mask", "transformTo", "fieldName", "operator", "value"));
    private static boolean failFast;

    static String validateConfig(Map fileRecord) throws Exception {
        String lastError;
        String fileContents = (String)fileRecord.get("fileContents");
        if (fileContents == null) {
            return null;
        }
        StringReader contentsReader = new StringReader(fileContents);
        Map dsConfig = (Map)XML.toDSRecords(new InputSource(contentsReader));
        switch (lastError = MockDataSource.cleanUnsafeConfigProps(dsConfig)) {
            case "valid": {
                return null;
            }
            case "cleaned": {
                break;
            }
            default: {
                if (!failFast) break;
                return lastError;
            }
        }
        MockDataSource dummyMDS = new MockDataSource();
        String newFileContents = dummyMDS.toXML(dsConfig);
        fileRecord.put("fileContents", newFileContents);
        return null;
    }

    static String cleanUnsafeConfigProps(Map<String, Object> dsConfig) {
        ArrayList fields;
        Object clientOnly;
        String constructor;
        Object message = "valid";
        if (dsConfig.containsKey("sourceDataSourceID")) {
            log.debug("Removed sourceDataSourceID from MockDataSource config; correct value will be populated when the MDS is loaded");
            dsConfig.remove("sourceDataSourceID");
            message = "cleaned";
        }
        if ((constructor = (String)dsConfig.get("constructor")) != null && !"MockDataSource".equals(constructor)) {
            message = "Invalid constructor " + constructor + " specified.  Expected: MockDataSource";
            if (failFast) {
                return message;
            }
            dsConfig.remove("constructor");
            log.warn(message);
        }
        if ((constructor = (String)dsConfig.getOrDefault("__autoConstruct", constructor)) == null || !"MockDataSource".equals(constructor)) {
            message = "MockDataSource constructor expected.  Found: " + constructor;
            if (failFast) {
                return message;
            }
            dsConfig.remove("__autoConstruct");
            log.warn(message);
        }
        if (new HashSet<String>(dsConfig.keySet()).retainAll(SAFE_CLASS_PROPERTIES)) {
            ArrayList<String> badProps = new ArrayList<String>();
            for (String dataSourceProp : dsConfig.keySet()) {
                if (SAFE_CLASS_PROPERTIES.contains(dataSourceProp)) continue;
                message = "Cannot add MockDataSource declared with property " + dataSourceProp;
                if (failFast) {
                    return message;
                }
                badProps.add(dataSourceProp);
            }
            log.warn("Removing unsafe MockDataSource properties: " + String.valueOf(badProps));
            dsConfig.keySet().retainAll(SAFE_CLASS_PROPERTIES);
        }
        if (dsConfig.containsKey("clientOnly") && !Boolean.TRUE.equals(clientOnly = dsConfig.get("clientOnly")) && !DataTools.equalsIgnoreCase("true", clientOnly)) {
            message = "Cannot declare MockDataSource with clientOnly: " + String.valueOf(clientOnly);
            if (failFast) {
                return message;
            }
            log.warn("Removing clientOnly: " + String.valueOf(clientOnly) + " from MockDataSource config");
            dsConfig.remove("clientOnly");
        }
        if ((fields = (ArrayList)dsConfig.get("fields")) == null) {
            fields = new ArrayList();
        }
        for (Map field : fields) {
            List validators;
            ArrayList<String> badProps;
            if (new HashSet(field.keySet()).retainAll(SAFE_FIELD_PROPERTIES)) {
                badProps = new ArrayList<String>();
                for (String fieldProp : field.keySet()) {
                    if (SAFE_FIELD_PROPERTIES.contains(fieldProp)) continue;
                    message = "Cannot add MockDataSource field declared with property " + fieldProp;
                    if (failFast) {
                        return message;
                    }
                    badProps.add(fieldProp);
                }
                log.warn("Removing unsafe MockDataSource field properties: " + String.valueOf(badProps));
                field.keySet().retainAll(SAFE_FIELD_PROPERTIES);
            }
            badProps = new ArrayList();
            for (String velocityProp : VELOCITY_FIELD_PROPERTIES) {
                Object value;
                if (!field.containsKey(velocityProp) || (value = field.get(velocityProp)) instanceof Boolean || DataTools.equalsIgnoreCase("true", value) || DataTools.equalsIgnoreCase("false", value)) continue;
                message = "MockDataSource velocity field " + velocityProp + " must be 'true' or 'false'";
                if (failFast) {
                    return message;
                }
                badProps.add(velocityProp);
            }
            if (!badProps.isEmpty()) {
                log.warn("Removing unsafe MockDataSource field properties: " + String.valueOf(badProps));
                field.keySet().removeAll(badProps);
            }
            if ((validators = (List)field.get("validators")) == null) continue;
            for (Map validator : validators) {
                if (!new HashSet(validator.keySet()).retainAll(SAFE_VALIDATOR_PROPERTIES)) continue;
                ArrayList<String> badProps2 = new ArrayList<String>();
                for (String validatorProp : validator.keySet()) {
                    if (SAFE_VALIDATOR_PROPERTIES.contains(validatorProp)) continue;
                    message = "Cannot add MockDataSource field validator declared with property " + validatorProp;
                    if (failFast) {
                        return message;
                    }
                    badProps2.add(validatorProp);
                }
                log.warn("Removing unsafe MockDataSource field validator properties: " + String.valueOf(badProps2));
                validator.keySet().retainAll(SAFE_VALIDATOR_PROPERTIES);
            }
        }
        ArrayList bindings = (ArrayList)dsConfig.get("operationBindings");
        if (bindings == null) {
            bindings = new ArrayList();
        }
        for (Map binding : bindings) {
            if (!new HashSet(binding.keySet()).retainAll(SAFE_OP_BINDING_PROPERTIES)) continue;
            ArrayList<String> badProps = new ArrayList<String>();
            for (String bindingProp : binding.keySet()) {
                if (SAFE_OP_BINDING_PROPERTIES.contains(bindingProp)) continue;
                message = "Cannot add MockDataSource operation binding declared with property " + bindingProp;
                if (failFast) {
                    return message;
                }
                badProps.add(bindingProp);
            }
            log.warn("Removing unsafe MockDataSource operation binding properties: " + String.valueOf(badProps));
            binding.keySet().retainAll(SAFE_OP_BINDING_PROPERTIES);
        }
        return message;
    }

    @Override
    public String toXML(Map dsConfig) {
        return this.toXML(dsConfig, "MockDataSource");
    }

    @Override
    public boolean isMock() {
        return true;
    }

    @Override
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        String lastError;
        switch (lastError = MockDataSource.cleanUnsafeConfigProps(theConfig)) {
            case "valid": 
            case "cleaned": {
                break;
            }
            default: {
                if (!failFast) break;
                throw new Exception("Unable to create MockDataSource: " + lastError);
            }
        }
        super.init(theConfig, dsRequest);
    }

    @Override
    public DSResponse execute(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    @Override
    public DSResponse executeFileSource(DSRequest req) throws Exception {
        return this.notSupported(req);
    }

    static {
        Config globalConfig = Config.getGlobal();
        failFast = globalConfig.getBoolean((Object)"devenv", false);
    }
}

