/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.log.Logger;
import com.isomorphic.util.LocaleMessage;
import com.isomorphic.xml.XML;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class ValueMap
extends BasicDataSource {
    private static Logger log = new Logger(ValueMap.class.getName());

    @Override
    public Object toRecord(Object data, ValidationContext context) throws Exception {
        if (data instanceof Map) {
            return data;
        }
        if (data instanceof List) {
            return data;
        }
        if (!(data instanceof Element)) {
            return data;
        }
        Element element = (Element)data;
        LinkedHashMap<Object, Object> valueMap = new LinkedHashMap<Object, Object>();
        List children = XML.getElementChildren(element);
        boolean gotIDMapping = false;
        if (element.hasAttributes()) {
            gotIDMapping = true;
            XML.addAttributesToMap(element, valueMap);
        }
        for (Element child : children) {
            String ID = XML.getAttribute(child, "ID");
            if (ID == null) {
                ID = XML.getAttribute(child, "id");
            }
            Object value = null;
            boolean i18n = false;
            List valueElements = XML.getElementChildren(child);
            LocaleMessage localeMessage = XML.toLocaleMessage(child, context);
            if (localeMessage != null) {
                value = localeMessage;
                i18n = true;
            }
            if (!i18n) {
                value = !valueElements.isEmpty() ? DataSource.recordsFromXML(valueElements) : XML.toSimpleValue(child);
            }
            if (ID != null && value != null) {
                gotIDMapping = true;
                valueMap.put(ID, value);
                continue;
            }
            if (ID != null) {
                valueMap.put(ID, ID);
                continue;
            }
            if (value != null) {
                valueMap.put(value, value);
                continue;
            }
            valueMap.put("", "");
        }
        if (gotIDMapping) {
            return valueMap;
        }
        return new ArrayList(valueMap.values());
    }

    public void recordToXML(String tagName, Map record, Writer out, boolean useAttributes, boolean collapseListsToAttributes, DSRequest dsRequest) throws Exception {
        for (String name : record.keySet()) {
            Object value = record.get(name);
            out.write("    <" + tagName + " ID=\"" + name + "\">" + String.valueOf(value) + "</" + tagName + ">\n");
        }
    }
}

