/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rg;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.EmittedArtifact;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.util.DefaultTextOutput;
import com.google.gwt.dev.util.TextOutput;
import com.google.gwt.dev.util.Util;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.CssResourceBase;
import com.google.gwt.resources.css.ClassRenamer;
import com.google.gwt.resources.css.CssGenerationVisitor;
import com.google.gwt.resources.css.DefsCollector;
import com.google.gwt.resources.css.ExternalClassesCollector;
import com.google.gwt.resources.css.GenerateCssAst;
import com.google.gwt.resources.css.IfEvaluator;
import com.google.gwt.resources.css.MergeIdenticalSelectorsVisitor;
import com.google.gwt.resources.css.MergeRulesByContentVisitor;
import com.google.gwt.resources.css.RequirementsCollector;
import com.google.gwt.resources.css.RtlVisitor;
import com.google.gwt.resources.css.SplitRulesVisitor;
import com.google.gwt.resources.css.Spriter;
import com.google.gwt.resources.css.SubstitutionCollector;
import com.google.gwt.resources.css.SubstitutionReplacer;
import com.google.gwt.resources.css.ast.CollapsedNode;
import com.google.gwt.resources.css.ast.CssCompilerException;
import com.google.gwt.resources.css.ast.CssDef;
import com.google.gwt.resources.css.ast.CssIf;
import com.google.gwt.resources.css.ast.CssNode;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.css.ast.CssStylesheet;
import com.google.gwt.resources.css.ast.CssSubstitution;
import com.google.gwt.resources.ext.ClientBundleRequirements;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import com.google.gwt.resources.ext.SupportsGeneratorResultCaching;
import com.google.gwt.resources.rg.AbstractCssResourceGenerator;
import com.google.gwt.resources.rg.Counter;
import com.google.gwt.resources.rg.CssObfuscationStyle;
import com.google.gwt.resources.rg.GssResourceGenerator;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.user.rebind.SourceWriter;
import com.google.gwt.user.rebind.StringSourceWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.Adler32;

public class CssResourceGenerator
extends AbstractCssResourceGenerator
implements SupportsGeneratorResultCaching {
    static final char[] BASE32_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', '-', '0', '1', '2', '3', '4', '5'};
    private static final int CONCAT_EXPRESSION_LIMIT = 20;
    private static final String KEY_BY_CLASS_AND_METHOD = "classAndMethod";
    private static final String KEY_CLASS_PREFIX = "prefix";
    private static final String KEY_CLASS_COUNTER = "counter";
    private static final String KEY_HAS_CACHED_DATA = "hasCachedData";
    private static final String KEY_MERGE_ENABLED = "CssResource.mergeEnabled";
    private static final String KEY_OBFUSCATION_PREFIX = "CssResource.obfuscationPrefix";
    private static final String KEY_RESERVED_PREFIXES = "CssResource.reservedClassPrefixes";
    private static final String KEY_SHARED_METHODS = "sharedMethods";
    private static final String KEY_STYLE = "CssResource.style";
    private static final char RESERVED_IDENT_CHAR = 'Z';
    protected CssObfuscationStyle obfuscationStyle;
    private Counter classCounter;
    private boolean enableMerge;
    private boolean gssEnabled;
    private GssResourceGenerator gssResourceGenerator;
    private List<String> ignoredMethods = new ArrayList<String>();
    private Map<JClassType, Map<JMethod, String>> replacementsByClassAndMethod;
    private Map<JMethod, String> replacementsForSharedMethods;
    private Map<JMethod, CssStylesheet> stylesheetMap;

    public static String getImportPrefix(JClassType importType) {
        String prefix = importType.getSimpleSourceName();
        CssResource.ImportedWithPrefix exp = (CssResource.ImportedWithPrefix)importType.getAnnotation(CssResource.ImportedWithPrefix.class);
        if (exp != null) {
            prefix = exp.value();
        }
        return prefix + "-";
    }

    public static boolean haveCommonProperties(CssRule a, CssRule b) {
        if (a.getProperties().size() == 0 || b.getProperties().size() == 0) {
            return false;
        }
        TreeSet<String> aProperties = new TreeSet<String>();
        TreeSet<String> bProperties = new TreeSet<String>();
        for (CssProperty p : a.getProperties()) {
            aProperties.add(p.getName());
        }
        for (CssProperty p : b.getProperties()) {
            bProperties.add(p.getName());
        }
        Iterator ai = aProperties.iterator();
        Iterator bi = bProperties.iterator();
        String aName = (String)ai.next();
        String bName = (String)bi.next();
        while (true) {
            int comp;
            if ((comp = aName.compareToIgnoreCase(bName)) == 0) {
                return true;
            }
            if (comp > 0) {
                if (aName.startsWith(bName + "-")) {
                    return true;
                }
                if (!bi.hasNext()) break;
                bName = (String)bi.next();
                continue;
            }
            if (bName.startsWith(aName + "-")) {
                return true;
            }
            if (!ai.hasNext()) break;
            aName = (String)ai.next();
        }
        return false;
    }

    static String computeObfuscatedClassName(String classPrefix, Counter classCounter, SortedSet<String> reservedPrefixes) {
        String obfuscatedClassName = classPrefix + CssResourceGenerator.makeIdent(classCounter.next());
        String conflict = CssResourceGenerator.stringStartsWithAny(obfuscatedClassName, reservedPrefixes);
        while (conflict != null) {
            Adler32 hash = new Adler32();
            hash.update(Util.getBytes((String)conflict));
            String newPrefix = CssResourceGenerator.makeIdent(hash.getValue()).substring(0, conflict.length()) + 'Z';
            obfuscatedClassName = newPrefix + obfuscatedClassName.substring(conflict.length());
            conflict = CssResourceGenerator.stringStartsWithAny(obfuscatedClassName, reservedPrefixes);
        }
        return obfuscatedClassName;
    }

    static <T extends CssNode> String makeExpression(TreeLogger logger, ResourceContext context, T node, boolean prettyOutput) throws UnableToCompleteException {
        DefaultTextOutput out = new DefaultTextOutput(!prettyOutput);
        CssGenerationVisitor v = new CssGenerationVisitor((TextOutput)out);
        v.accept(node);
        String template = out.toString();
        StringBuilder b = new StringBuilder();
        int start = 0;
        int numExpressions = 0;
        b.append('(');
        for (Map.Entry<Integer, List<CssSubstitution>> entry : v.getSubstitutionPositions().entrySet()) {
            b.append('\"');
            b.append(Generator.escape((String)template.substring(start, entry.getKey())));
            b.append('\"');
            numExpressions = CssResourceGenerator.concatOp(numExpressions, b);
            for (CssSubstitution x : entry.getValue()) {
                TreeLogger loopLogger = logger.branch(TreeLogger.DEBUG, "Performing substitution in node " + x.toString());
                if (x instanceof CssIf) {
                    CssIf asIf = (CssIf)x;
                    String expression = CssResourceGenerator.makeExpression(loopLogger, context, new CollapsedNode(asIf), prettyOutput);
                    String elseExpression = asIf.getElseNodes().isEmpty() ? "\"\"" : CssResourceGenerator.makeExpression(loopLogger, context, new CollapsedNode(asIf.getElseNodes()), prettyOutput);
                    b.append("((" + asIf.getExpression() + ") ? " + expression + " : " + elseExpression + ") ");
                    numExpressions = CssResourceGenerator.concatOp(numExpressions, b);
                    continue;
                }
                if (x instanceof CssProperty) {
                    CssProperty property = (CssProperty)x;
                    CssResourceGenerator.validateValue(loopLogger, context.getClientBundleType(), property.getValues());
                    b.append("(" + property.getValues().getExpression() + ") ");
                    numExpressions = CssResourceGenerator.concatOp(numExpressions, b);
                    continue;
                }
                loopLogger.log(TreeLogger.ERROR, "Unhandled substitution " + x.getClass());
                throw new UnableToCompleteException();
            }
            start = entry.getKey();
        }
        b.append('\"');
        b.append(Generator.escape((String)template.substring(start)));
        b.append('\"');
        b.append(')');
        return b.toString();
    }

    private static int concatOp(int numExpressions, StringBuilder b) {
        if (numExpressions >= 20) {
            b.append(") + (");
            return 0;
        }
        b.append(" + ");
        return numExpressions + 1;
    }

    private static String makeIdent(long id) {
        assert (id >= 0L);
        StringBuilder b = new StringBuilder();
        b.append(BASE32_CHARS[(int)(id & 0xFL)]);
        id >>= 4;
        while (id != 0L) {
            b.append(BASE32_CHARS[(int)(id & 0x1FL)]);
            id >>= 5;
        }
        return b.toString();
    }

    private static String stringStartsWithAny(String target, SortedSet<String> prefixes) {
        String prefix;
        if (prefixes.isEmpty()) {
            return null;
        }
        String search = target.toString().toLowerCase(Locale.ROOT) + " ";
        SortedSet<String> headSet = prefixes.headSet(search);
        if (!headSet.isEmpty() && search.startsWith(prefix = headSet.last())) {
            return prefix;
        }
        return null;
    }

    private static void validateValue(TreeLogger logger, JClassType resourceBundleType, CssProperty.Value value) throws UnableToCompleteException {
        CssProperty.ListValue list = value.isListValue();
        if (list != null) {
            for (CssProperty.Value v : list.getValues()) {
                CssResourceGenerator.validateValue(logger, resourceBundleType, v);
            }
            return;
        }
        CssProperty.DotPathValue dot = value.isDotPathValue();
        if (dot != null) {
            try {
                ResourceGeneratorUtil.getMethodByPath(resourceBundleType, dot.getParts(), null);
            }
            catch (NotFoundException e) {
                logger.log(TreeLogger.ERROR, e.getMessage());
                throw new UnableToCompleteException();
            }
        }
    }

    @Override
    public String createAssignment(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        if (this.gssEnabled) {
            return this.gssResourceGenerator.createAssignment(logger, context, method);
        }
        JClassType cssResourceSubtype = method.getReturnType().isInterface();
        assert (cssResourceSubtype != null);
        CssStylesheet stylesheet = this.stylesheetMap.get(method);
        Map<JMethod, String> actualReplacements = this.optimize(logger, context, method);
        CssResourceGenerator.outputCssMapArtifact(logger, context, method, actualReplacements);
        this.outputAdditionalArtifacts(logger, context, method, actualReplacements, cssResourceSubtype, stylesheet);
        return this.getResourceImplAsString(logger, context, method, actualReplacements, cssResourceSubtype, stylesheet);
    }

    @Override
    public void init(TreeLogger logger, ResourceContext context) throws UnableToCompleteException {
        String classPrefix;
        GssResourceGenerator.GssOptions gssOptions = GssResourceGenerator.getGssOptions(context.getGeneratorContext().getPropertyOracle(), logger);
        if (gssOptions.isEnabled()) {
            this.gssEnabled = true;
            this.gssResourceGenerator = new GssResourceGenerator(gssOptions);
            this.gssResourceGenerator.init(logger, context);
            return;
        }
        this.gssEnabled = false;
        try {
            PropertyOracle propertyOracle = context.getGeneratorContext().getPropertyOracle();
            ConfigurationProperty styleProp = propertyOracle.getConfigurationProperty(KEY_STYLE);
            this.obfuscationStyle = CssObfuscationStyle.getObfuscationStyle((String)styleProp.getValues().get(0));
            ConfigurationProperty mergeProp = propertyOracle.getConfigurationProperty(KEY_MERGE_ENABLED);
            JMethod[] merge = (JMethod[])mergeProp.getValues().get(0);
            this.enableMerge = merge.equals("true");
            ConfigurationProperty classPrefixProp = propertyOracle.getConfigurationProperty(KEY_OBFUSCATION_PREFIX);
            classPrefix = (String)classPrefixProp.getValues().get(0);
            ClientBundleRequirements requirements = context.getRequirements();
            requirements.addConfigurationProperty(KEY_STYLE);
            requirements.addConfigurationProperty(KEY_MERGE_ENABLED);
            requirements.addConfigurationProperty(KEY_OBFUSCATION_PREFIX);
        }
        catch (BadPropertyValueException e) {
            logger.log(TreeLogger.ERROR, "Unable to query module property", (Throwable)e);
            throw new UnableToCompleteException();
        }
        TypeOracle typeOracle = context.getGeneratorContext().getTypeOracle();
        JClassType superInterface = typeOracle.findType(this.getSuperclassInterfaceName());
        JClassType baseInterface = typeOracle.findType(this.getBaseclassInterfaceName());
        for (JMethod m : superInterface.getInheritableMethods()) {
            this.ignoredMethods.add(m.getName());
        }
        this.stylesheetMap = new IdentityHashMap<JMethod, CssStylesheet>();
        SortedSet<JClassType> cssResourceSubtypes = this.computeOperableTypes(logger, baseInterface);
        this.initReplacements(logger, context, classPrefix, cssResourceSubtypes);
    }

    @Override
    public void prepare(TreeLogger logger, ResourceContext context, ClientBundleRequirements requirements, JMethod method) throws UnableToCompleteException {
        if (this.gssEnabled) {
            this.gssResourceGenerator.prepare(logger, context, requirements, method);
            return;
        }
        if (method.getReturnType().isInterface() == null) {
            logger.log(TreeLogger.ERROR, "Return type must be an interface");
            throw new UnableToCompleteException();
        }
        URL[] resources = this.getResources(logger, context, method);
        if (resources.length == 0) {
            logger.log(TreeLogger.ERROR, "At least one source must be specified");
            throw new UnableToCompleteException();
        }
        this.ensureNoGssFile(resources, logger);
        CssStylesheet sheet = GenerateCssAst.exec(logger, resources);
        this.checkSheet(logger, sheet);
        this.stylesheetMap.put(method, sheet);
        new RequirementsCollector(logger, context.getRequirements()).accept(sheet);
    }

    private void ensureNoGssFile(URL[] resources, TreeLogger logger) throws UnableToCompleteException {
        for (URL stylesheet : resources) {
            if (!stylesheet.getFile().endsWith(".gss")) continue;
            logger.log(TreeLogger.Type.ERROR, "GSS is not enabled. Add the following line to your gwt.xml file to enable it: <set-configuration-property name=\"CssResource.enableGss\" value=\"true\" />");
            throw new UnableToCompleteException();
        }
    }

    protected void checkSheet(TreeLogger logger, CssStylesheet stylesheet) throws UnableToCompleteException {
    }

    protected String getBaseclassInterfaceName() {
        return CssResourceBase.class.getCanonicalName();
    }

    protected String getResourceImplAsString(TreeLogger logger, ResourceContext context, JMethod method, Map<JMethod, String> actualReplacements, JClassType cssResourceSubtype, CssStylesheet stylesheet) throws UnableToCompleteException {
        StringSourceWriter sw = new StringSourceWriter();
        sw.println("new " + method.getReturnType().getQualifiedSourceName() + "() {");
        sw.indent();
        this.writeEnsureInjected((SourceWriter)sw);
        this.writeGetName(method, (SourceWriter)sw);
        this.writeGetText(logger, context, method, (SourceWriter)sw);
        this.writeUserMethods(logger, (SourceWriter)sw, stylesheet, cssResourceSubtype.getOverridableMethods(), actualReplacements);
        sw.outdent();
        sw.println("}");
        return sw.toString();
    }

    protected URL[] getResources(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        return GssResourceGenerator.findResources(logger, context, method, false);
    }

    protected String getSuperclassInterfaceName() {
        return CssResource.class.getCanonicalName();
    }

    protected void outputAdditionalArtifacts(TreeLogger logger, ResourceContext context, JMethod method, Map<JMethod, String> actualReplacements, JClassType cssResourceSubtype, CssStylesheet stylesheet) throws UnableToCompleteException {
    }

    protected static void outputCssMapArtifact(TreeLogger logger, ResourceContext context, JMethod method, Map<JMethod, String> actualReplacements) {
        JClassType bundleType = method.getEnclosingType();
        String qualifiedMethodName = bundleType.getQualifiedSourceName() + "." + method.getName();
        String mappingFileName = "cssResource/" + qualifiedMethodName + ".cssmap";
        OutputStream os = null;
        try {
            os = context.getGeneratorContext().tryCreateResource(logger, mappingFileName);
        }
        catch (UnableToCompleteException e) {
            logger.log(TreeLogger.WARN, "Could not create resource: " + mappingFileName);
            return;
        }
        if (os == null) {
            return;
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
        try {
            for (Map.Entry<JMethod, String> replacement : actualReplacements.entrySet()) {
                String qualifiedName = replacement.getKey().getEnclosingType().getQualifiedSourceName();
                String baseName = replacement.getKey().getName();
                writer.write(qualifiedName.replaceAll("[.$]", "-") + "-" + baseName);
                writer.write(",");
                writer.write(replacement.getValue());
                writer.newLine();
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            logger.log(TreeLogger.WARN, "Error writing artifact: " + mappingFileName);
        }
        try {
            context.getGeneratorContext().commitResource(logger, os).setVisibility(EmittedArtifact.Visibility.Private);
        }
        catch (UnableToCompleteException e) {
            logger.log(TreeLogger.WARN, "Error trying to commit artifact: " + mappingFileName);
        }
    }

    protected void writeUserMethods(TreeLogger logger, SourceWriter sw, CssStylesheet sheet, JMethod[] methods, Map<JMethod, String> obfuscatedClassNames) throws UnableToCompleteException {
        DefsCollector collector = new DefsCollector();
        collector.accept(sheet);
        Set<String> defs = collector.getDefs();
        for (JMethod toImplement : methods) {
            String name = toImplement.getName();
            if (this.ignoredMethods.contains(name)) continue;
            if (defs.contains(name) && obfuscatedClassNames.containsKey(toImplement)) {
                logger.log(TreeLogger.ERROR, "@def shadows CSS class name: " + name + ". Fix by renaming the @def name or the CSS class name.");
                throw new UnableToCompleteException();
            }
            if (defs.contains(toImplement.getName()) && toImplement.getParameters().length == 0) {
                this.writeDefAssignment(logger, sw, toImplement, sheet);
                continue;
            }
            if (toImplement.getReturnType().getQualifiedSourceName().equals("java.lang.String") && toImplement.getParameters().length == 0) {
                this.writeClassAssignment(sw, toImplement, obfuscatedClassNames);
                continue;
            }
            logger.log(TreeLogger.ERROR, "Don't know how to implement method " + toImplement.getName());
            throw new UnableToCompleteException();
        }
    }

    private String computeClassPrefix(String classPrefix, SortedSet<JClassType> cssResourceSubtypes, TreeSet<String> reservedPrefixes) {
        if ("default".equals(classPrefix)) {
            classPrefix = null;
        } else if ("empty".equals(classPrefix)) {
            classPrefix = "";
        }
        if (classPrefix == null) {
            Adler32 checksum = new Adler32();
            for (JClassType type : cssResourceSubtypes) {
                checksum.update(Util.getBytes((String)type.getQualifiedSourceName()));
            }
            final int seed = Math.abs((int)checksum.getValue());
            classPrefix = "G" + CssResourceGenerator.computeObfuscatedClassName("", new Counter(this){
                final /* synthetic */ CssResourceGenerator this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                int next() {
                    return seed;
                }
            }, reservedPrefixes);
            reservedPrefixes.clear();
        }
        return classPrefix;
    }

    private void computeObfuscatedNames(TreeLogger logger, String classPrefix, SortedSet<String> reservedPrefixes, Set<JClassType> cssResourceSubtypes) {
        logger = logger.branch(TreeLogger.DEBUG, "Computing CSS class replacements");
        for (JClassType type : cssResourceSubtypes) {
            if (this.replacementsByClassAndMethod.containsKey(type)) continue;
            IdentityHashMap<JMethod, String> replacements = new IdentityHashMap<JMethod, String>();
            this.replacementsByClassAndMethod.put(type, replacements);
            for (JMethod method : type.getOverridableMethods()) {
                CssResource.Shared shared;
                String name = method.getName();
                if (this.ignoredMethods.contains(name)) continue;
                CssResource.ClassName classNameOverride = (CssResource.ClassName)method.getAnnotation(CssResource.ClassName.class);
                if (classNameOverride != null) {
                    name = classNameOverride.value();
                }
                String obfuscatedClassName = CssResourceGenerator.computeObfuscatedClassName(classPrefix, this.classCounter, reservedPrefixes);
                obfuscatedClassName = this.obfuscationStyle.getPrettyName(name, type, obfuscatedClassName);
                replacements.put(method, obfuscatedClassName);
                if (method.getEnclosingType() == type && (shared = (CssResource.Shared)type.getAnnotation(CssResource.Shared.class)) != null) {
                    this.replacementsForSharedMethods.put(method, obfuscatedClassName);
                }
                if (!logger.isLoggable(TreeLogger.SPAM)) continue;
                logger.log(TreeLogger.SPAM, "Mapped " + type.getQualifiedSourceName() + "." + name + " to " + obfuscatedClassName);
            }
        }
    }

    private SortedSet<JClassType> computeOperableTypes(TreeLogger logger, JClassType baseInterface) {
        JClassType[] cssResourceSubtypes;
        logger = logger.branch(TreeLogger.DEBUG, "Finding operable CssResource subtypes");
        TreeSet<JClassType> toReturn = new TreeSet<JClassType>(new JClassOrderComparator());
        for (JClassType type : cssResourceSubtypes = baseInterface.getSubtypes()) {
            if (type.isInterface() != null) {
                if (logger.isLoggable(TreeLogger.SPAM)) {
                    logger.log(TreeLogger.SPAM, "Added " + type.getQualifiedSourceName());
                }
                toReturn.add(type);
                continue;
            }
            if (!logger.isLoggable(TreeLogger.SPAM)) continue;
            logger.log(TreeLogger.SPAM, "Ignored " + type.getQualifiedSourceName());
        }
        return toReturn;
    }

    private Map<JMethod, String> computeReplacementsForType(JClassType type) {
        IdentityHashMap<JMethod, String> toReturn = new IdentityHashMap<JMethod, String>();
        if (this.replacementsByClassAndMethod.containsKey(type)) {
            toReturn.putAll(this.replacementsByClassAndMethod.get(type));
        }
        for (JMethod method : type.getOverridableMethods()) {
            if (!this.replacementsForSharedMethods.containsKey(method)) continue;
            assert (toReturn.containsKey(method));
            toReturn.put(method, this.replacementsForSharedMethods.get(method));
        }
        return toReturn;
    }

    private boolean derivedFromCssResource(JClassType type, JClassType cssResourceType) {
        List<JClassType> superInterfaces = Arrays.asList(type.getImplementedInterfaces());
        if (superInterfaces.contains(cssResourceType)) {
            return true;
        }
        JClassType superClass = type.getSuperclass();
        if (superClass != null && this.derivedFromCssResource(superClass, cssResourceType)) {
            return true;
        }
        for (JClassType superInterface : superInterfaces) {
            if (!this.derivedFromCssResource(superInterface, cssResourceType)) continue;
            return true;
        }
        return false;
    }

    private void initReplacements(TreeLogger logger, ResourceContext context, String classPrefix, SortedSet<JClassType> operableTypes) {
        if (context.getCachedData(KEY_HAS_CACHED_DATA, Boolean.class) != Boolean.TRUE) {
            TreeSet<String> reservedPrefixes = new TreeSet<String>();
            try {
                ConfigurationProperty prop = context.getGeneratorContext().getPropertyOracle().getConfigurationProperty(KEY_RESERVED_PREFIXES);
                context.getRequirements().addConfigurationProperty(KEY_RESERVED_PREFIXES);
                for (String value : prop.getValues()) {
                    if ((value = value.trim()).length() == 0) {
                        logger.log(TreeLogger.WARN, "Ignoring nonsensical empty string value for CssResource.reservedClassPrefixes configuration property");
                        continue;
                    }
                    if (value.startsWith(".")) {
                        value = value.substring(1);
                    }
                    reservedPrefixes.add(value.toLowerCase(Locale.ROOT));
                }
            }
            catch (BadPropertyValueException badPropertyValueException) {
                // empty catch block
            }
            String computedPrefix = this.computeClassPrefix(classPrefix, operableTypes, reservedPrefixes);
            context.putCachedData(KEY_BY_CLASS_AND_METHOD, new IdentityHashMap());
            context.putCachedData(KEY_CLASS_PREFIX, computedPrefix);
            context.putCachedData(KEY_CLASS_COUNTER, new Counter());
            context.putCachedData(KEY_HAS_CACHED_DATA, Boolean.TRUE);
            context.putCachedData(KEY_RESERVED_PREFIXES, reservedPrefixes);
            context.putCachedData(KEY_SHARED_METHODS, new IdentityHashMap());
        }
        this.classCounter = context.getCachedData(KEY_CLASS_COUNTER, Counter.class);
        this.replacementsByClassAndMethod = context.getCachedData(KEY_BY_CLASS_AND_METHOD, Map.class);
        this.replacementsForSharedMethods = context.getCachedData(KEY_SHARED_METHODS, Map.class);
        classPrefix = context.getCachedData(KEY_CLASS_PREFIX, String.class);
        SortedSet reservedPrefixes = context.getCachedData(KEY_RESERVED_PREFIXES, SortedSet.class);
        this.computeObfuscatedNames(logger, classPrefix, reservedPrefixes, operableTypes);
    }

    private boolean isStrict(TreeLogger logger, JMethod method) {
        CssResource.Strict strictAnnotation = (CssResource.Strict)method.getAnnotation(CssResource.Strict.class);
        CssResource.NotStrict nonStrictAnnotation = (CssResource.NotStrict)method.getAnnotation(CssResource.NotStrict.class);
        boolean strict = true;
        if (strictAnnotation != null && nonStrictAnnotation != null) {
            logger.log(TreeLogger.WARN, "Contradictory annotations " + CssResource.Strict.class.getName() + " and " + CssResource.NotStrict.class.getName() + " applied to the CssResource accessor method; assuming strict");
        } else if (nonStrictAnnotation != null) {
            strict = false;
        }
        return strict;
    }

    @Override
    protected String getCssExpression(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        return this.makeExpression(logger, context, this.stylesheetMap.get(method));
    }

    private String makeExpression(TreeLogger logger, ResourceContext context, CssStylesheet sheet) throws UnableToCompleteException {
        try {
            String standard = CssResourceGenerator.makeExpression(logger, context, sheet, this.obfuscationStyle.isPretty());
            new RtlVisitor().accept(sheet);
            String reversed = CssResourceGenerator.makeExpression(logger, context, sheet, this.obfuscationStyle.isPretty());
            if (standard.equals(reversed)) {
                return standard;
            }
            return LocaleInfo.class.getName() + ".getCurrentLocale().isRTL() ? (" + reversed + ") : (" + standard + ")";
        }
        catch (CssCompilerException e) {
            logger.log(TreeLogger.ERROR, "Unable to process CSS", (Throwable)(e.getCause() == null ? null : e));
            throw new UnableToCompleteException();
        }
    }

    private Map<JMethod, String> optimize(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        TypeOracle typeOracle = context.getGeneratorContext().getTypeOracle();
        JClassType cssResourceSubtype = method.getReturnType().isInterface();
        assert (cssResourceSubtype != null);
        assert (this.derivedFromCssResource(cssResourceSubtype, typeOracle.findType(this.getBaseclassInterfaceName())));
        Map<String, Map<JMethod, String>> classReplacementsWithPrefix = this.processImports(logger, typeOracle, cssResourceSubtype, method, context);
        boolean strict = this.isStrict(logger, method);
        CssStylesheet sheet = this.stylesheetMap.get(method);
        new Spriter(logger, context).accept(sheet);
        SubstitutionCollector collector = new SubstitutionCollector();
        collector.accept(sheet);
        new SubstitutionReplacer(logger, context, collector.getSubstitutions()).accept(sheet);
        new IfEvaluator(logger, context.getGeneratorContext().getPropertyOracle()).accept(sheet);
        ExternalClassesCollector externalClasses = new ExternalClassesCollector();
        externalClasses.accept(sheet);
        ClassRenamer renamer = new ClassRenamer(logger, classReplacementsWithPrefix, strict, externalClasses.getClasses());
        renamer.accept(sheet);
        TreeMap<JMethod, String> actualReplacements = new TreeMap<JMethod, String>(new Comparator<JMethod>(){

            @Override
            public int compare(JMethod o1, JMethod o2) {
                int result = this.source(o1).compareTo(this.source(o2));
                if (result == 0) {
                    result = o1.getName().compareTo(o2.getName());
                }
                return result;
            }

            private String source(JMethod o) {
                return o.getEnclosingType().getQualifiedSourceName();
            }
        });
        actualReplacements.putAll(renamer.getReplacements());
        if (this.enableMerge) {
            new SplitRulesVisitor().accept(sheet);
            new MergeIdenticalSelectorsVisitor().accept(sheet);
            new MergeRulesByContentVisitor().accept(sheet);
        }
        return actualReplacements;
    }

    private Map<String, Map<JMethod, String>> processImports(TreeLogger logger, TypeOracle typeOracle, JClassType cssResourceSubtype, JMethod method, ResourceContext context) throws UnableToCompleteException {
        HashMap<String, Map<JMethod, String>> replacementsWithPrefix = new HashMap<String, Map<JMethod, String>>();
        replacementsWithPrefix.put("", this.computeReplacementsForType(cssResourceSubtype));
        CssResource.Import imp = (CssResource.Import)method.getAnnotation(CssResource.Import.class);
        if (imp != null) {
            boolean fail = false;
            for (Class<? extends CssResource> clazz : imp.value()) {
                JClassType importType = typeOracle.findType(clazz.getName().replace('$', '.'));
                assert (importType != null) : "TypeOracle does not have type " + clazz.getName();
                context.getRequirements().addTypeHierarchy(importType);
                String prefix = CssResourceGenerator.getImportPrefix(importType);
                if (replacementsWithPrefix.put(prefix, this.computeReplacementsForType(importType)) == null) continue;
                logger.log(TreeLogger.ERROR, "Multiple imports that would use the prefix " + prefix);
                fail = true;
            }
            if (fail) {
                throw new UnableToCompleteException();
            }
        }
        return replacementsWithPrefix;
    }

    private void writeClassAssignment(SourceWriter sw, JMethod toImplement, Map<JMethod, String> classReplacements) {
        String replacement = classReplacements.get(toImplement);
        assert (replacement != null) : "Missing replacement for " + toImplement.getName();
        this.writeSimpleGetter(toImplement, "\"" + replacement + "\"", sw);
    }

    private void writeDefAssignment(TreeLogger logger, SourceWriter sw, JMethod toImplement, CssStylesheet cssStylesheet) throws UnableToCompleteException {
        SubstitutionCollector collector = new SubstitutionCollector();
        collector.accept(cssStylesheet);
        String name = toImplement.getName();
        CssDef def = collector.getSubstitutions().get(name);
        if (def == null) {
            logger.log(TreeLogger.ERROR, "No @def rule for name " + name);
            throw new UnableToCompleteException();
        }
        JClassType classReturnType = toImplement.getReturnType().isClass();
        if (def.getValues().size() != 1 && !this.isReturnTypeString(classReturnType)) {
            logger.log(TreeLogger.ERROR, "@def rule " + name + " must define exactly one value or return type must be String");
            throw new UnableToCompleteException();
        }
        String returnExpr = "";
        if (this.isReturnTypeString(classReturnType)) {
            ArrayList<String> returnValues = new ArrayList<String>();
            for (CssProperty.Value val : def.getValues()) {
                returnValues.add(Generator.escape((String)val.toString()));
            }
            returnExpr = "\"" + Joiner.on(" ").join(returnValues) + "\"";
        } else {
            JPrimitiveType returnType = toImplement.getReturnType().isPrimitive();
            if (returnType == null) {
                logger.log(TreeLogger.ERROR, toImplement.getName() + ": Return type must be primitive type or String for @def accessors");
                throw new UnableToCompleteException();
            }
            CssProperty.NumberValue numberValue = def.getValues().get(0).isNumberValue();
            if (returnType == JPrimitiveType.INT || returnType == JPrimitiveType.LONG) {
                returnExpr = "" + Math.round(numberValue.getValue());
            } else if (returnType == JPrimitiveType.FLOAT) {
                returnExpr = numberValue.getValue() + "F";
            } else if (returnType == JPrimitiveType.DOUBLE) {
                returnExpr = "" + numberValue.getValue();
            } else {
                logger.log(TreeLogger.ERROR, returnType.getQualifiedSourceName() + " is not a valid primitive return type for @def accessors");
                throw new UnableToCompleteException();
            }
        }
        this.writeSimpleGetter(toImplement, returnExpr, sw);
    }

    static class JClassOrderComparator
    implements Comparator<JClassType>,
    Serializable {
        JClassOrderComparator() {
        }

        @Override
        public int compare(JClassType o1, JClassType o2) {
            return o1.getQualifiedSourceName().compareTo(o2.getQualifiedSourceName());
        }
    }
}

