/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractInputCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.text.shared.SafeHtmlRenderer;

public class TextInputCell
extends AbstractInputCell<String, ViewData> {
    private static Template template;

    public TextInputCell() {
        super("change", "keyup");
        if (template == null) {
            template = (Template)GWT.create(Template.class);
        }
    }

    @Deprecated
    public TextInputCell(SafeHtmlRenderer<String> renderer) {
        this();
    }

    @Override
    public void onBrowserEvent(Cell.Context context, Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) {
        super.onBrowserEvent(context, parent, value, event, valueUpdater);
        InputElement input = this.getInputElement(parent);
        Element target = (Element)event.getEventTarget().cast();
        if (!input.isOrHasChild(target)) {
            return;
        }
        String eventType = event.getType();
        Object key = context.getKey();
        if ("change".equals(eventType)) {
            this.finishEditing(parent, value, key, valueUpdater);
        } else if ("keyup".equals(eventType)) {
            ViewData vd = (ViewData)this.getViewData(key);
            if (vd == null) {
                vd = new ViewData(value);
                this.setViewData(key, vd);
            }
            vd.setCurrentValue(input.getValue());
        }
    }

    @Override
    public void render(Cell.Context context, String value, SafeHtmlBuilder sb) {
        String s;
        Object key = context.getKey();
        ViewData viewData = (ViewData)this.getViewData(key);
        if (viewData != null && viewData.getCurrentValue().equals(value)) {
            this.clearViewData(key);
            viewData = null;
        }
        String string = s = viewData != null ? viewData.getCurrentValue() : value;
        if (s != null) {
            sb.append(template.input(s));
        } else {
            sb.appendHtmlConstant("<input type=\"text\" tabindex=\"-1\"></input>");
        }
    }

    @Override
    protected void finishEditing(Element parent, String value, Object key, ValueUpdater<String> valueUpdater) {
        String newValue = this.getInputElement(parent).getValue();
        ViewData vd = (ViewData)this.getViewData(key);
        if (vd == null) {
            vd = new ViewData(value);
            this.setViewData(key, vd);
        }
        vd.setCurrentValue(newValue);
        if (valueUpdater != null && !vd.getCurrentValue().equals(vd.getLastValue())) {
            vd.setLastValue(newValue);
            valueUpdater.update(newValue);
        }
        super.finishEditing(parent, newValue, key, valueUpdater);
    }

    @Override
    protected InputElement getInputElement(Element parent) {
        return (InputElement)super.getInputElement(parent).cast();
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<input type=\"text\" value=\"{0}\" tabindex=\"-1\"></input>")
        public SafeHtml input(String var1);
    }

    public static class ViewData {
        private String lastValue;
        private String curValue;

        public ViewData(String value) {
            this.lastValue = value;
            this.curValue = value;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ViewData)) {
                return false;
            }
            ViewData vd = (ViewData)other;
            return this.equalsOrNull(this.lastValue, vd.lastValue) && this.equalsOrNull(this.curValue, vd.curValue);
        }

        public String getCurrentValue() {
            return this.curValue;
        }

        public String getLastValue() {
            return this.lastValue;
        }

        public int hashCode() {
            return (this.lastValue + "_*!@HASH_SEPARATOR@!*_" + this.curValue).hashCode();
        }

        protected void setCurrentValue(String curValue) {
            this.curValue = curValue;
        }

        protected void setLastValue(String lastValue) {
            this.lastValue = lastValue;
        }

        private boolean equalsOrNull(Object a, Object b) {
            return a != null ? a.equals(b) : b == null;
        }
    }
}

