/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;

public class JXPathContextObjectFactory
extends AbstractFactory {
    private static Logger log = new Logger(JXPathContextObjectFactory.class.getName());
    private static JXPathContextObjectFactory instance = new JXPathContextObjectFactory();

    private JXPathContextObjectFactory() {
    }

    public static JXPathContextObjectFactory getInstance() {
        return instance;
    }

    public boolean createObject(JXPathContext context, Pointer pointer, Object parent, String name, int index) {
        try {
            Map<String, PropertyDescriptor> propertyDescriptors = DataTools.getPropertyDescriptors(parent.getClass());
            PropertyDescriptor pd = propertyDescriptors.get(name);
            if (pd == null && Map.class.isAssignableFrom(parent.getClass())) {
                HashMap m = new HashMap();
                ((Map)parent).put(name, m);
                return true;
            }
            if (pd == null) {
                throw new Exception("Property not found.");
            }
            Class<?> cl = pd.getPropertyType();
            if (cl.isArray()) {
                Object[] array2 = (Object[])pd.getReadMethod().invoke(parent, new Object[0]);
                if (index < 0) {
                    throw new IndexOutOfBoundsException("Provided index is negative. Notice, that jXPath starts counting from '1', not from '0'. So if you use '0' in xpath, '-1' will be provided to object factory.");
                }
                if (array2 == null) {
                    array2 = (Object[])Array.newInstance(cl.getComponentType(), index + 1);
                    pd.getWriteMethod().invoke(parent, new Object[]{array2});
                }
                if (array2.length <= index) {
                    Object[] arrayCopy = (Object[])Array.newInstance(cl.getComponentType(), index + 1);
                    System.arraycopy(array2, 0, arrayCopy, 0, array2.length);
                    array2 = arrayCopy;
                    pd.getWriteMethod().invoke(parent, new Object[]{array2});
                }
                array2[index] = cl.getComponentType().newInstance();
                return true;
            }
            if (Collection.class.isAssignableFrom(cl)) {
                AbstractCollection collection = (ArrayList)pd.getReadMethod().invoke(parent, new Object[0]);
                if (index < 0) {
                    throw new IndexOutOfBoundsException("Provided index is negative. Notice, that jXPath starts counting from '1', not from '0'. So if you use '0' in xpath, '-1' will be provided to object factory.");
                }
                Class elementType = null;
                Type type = parent.getClass().getDeclaredField(name).getGenericType();
                if (!(type instanceof ParameterizedType)) {
                    throw new Exception("Creation of unparameterized collections is not supported.");
                }
                Type t = ((ParameterizedType)type).getActualTypeArguments()[0];
                String tcl = t.toString().substring(t.toString().indexOf(" ") + 1);
                elementType = Reflection.classForName(tcl);
                if (collection == null) {
                    if (cl.isInterface() || Modifier.isAbstract(cl.getModifiers())) {
                        if (List.class.isAssignableFrom(cl)) {
                            collection = new ArrayList();
                        } else if (Set.class.isAssignableFrom(cl)) {
                            collection = new HashSet();
                        } else if (Queue.class.isAssignableFrom(cl)) {
                            collection = new LinkedList();
                        } else if (Collection.class.isAssignableFrom(cl)) {
                            collection = new ArrayList();
                        } else {
                            throw new Exception("Trying to pick up implementation for interface which is not supported: " + cl.getName() + ".");
                        }
                        pd.getWriteMethod().invoke(parent, collection);
                    } else {
                        pd.getWriteMethod().invoke(parent, cl.newInstance());
                    }
                }
                Object element = elementType.newInstance();
                if (collection.size() <= index) {
                    Object[] additionalElements = new Object[index - collection.size() + 1];
                    additionalElements[additionalElements.length - 1] = element;
                    Collections.addAll(collection, additionalElements);
                    return true;
                }
                if (List.class.isAssignableFrom(cl)) {
                    ((List)((Object)collection)).set(index, element);
                    return true;
                }
                if (Collection.class.isAssignableFrom(cl)) {
                    Object[] collectionArray = collection.toArray();
                    collectionArray[index] = element;
                    collection.clear();
                    Collections.addAll(collection, collectionArray);
                    return true;
                }
                throw new Exception("Class is not supported: " + cl.getName() + ".");
            }
            if (Map.class.isAssignableFrom(cl)) {
                throw new UnsupportedOperationException("Map is not supported.");
            }
            if (!cl.isInterface() && !Modifier.isAbstract(cl.getModifiers())) {
                pd.getWriteMethod().invoke(parent, cl.newInstance());
                return true;
            }
            throw new Exception("Cannot instantiate interface.");
        }
        catch (Exception e) {
            log.info((Object)("Provided XPath has one or more null objects, attempt to create missing object failed. JXPathContext bean: " + String.valueOf(context.getContextBean()) + ", parent object: " + String.valueOf(parent) + ", property that creation failed: " + name + ", property index (in case of collection or array): " + index), e);
            return false;
        }
    }
}

