/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class RelationContext {
    private static Logger log = new Logger(RelationContext.class);
    private String[] queryFK;
    private boolean inverseFKString = false;
    private String linkDelimiter;
    private String dsDelimiter;
    private String fieldDelimiter;
    private RelationLink[] links;
    private int current = 0;
    private int drafted = -1;

    protected static RelationContext instance(RelationContext ctx) {
        if (ctx == null || ctx.empty() || ctx.finished()) {
            return null;
        }
        RelationContext newCtx = new RelationContext();
        newCtx.queryFK = ctx.queryFK;
        newCtx.inverseFKString = ctx.inverseFKString;
        newCtx.linkDelimiter = ctx.linkDelimiter;
        newCtx.dsDelimiter = ctx.dsDelimiter;
        newCtx.fieldDelimiter = ctx.fieldDelimiter;
        newCtx.init();
        newCtx.current = ctx.current;
        newCtx.drafted = ctx.drafted;
        return newCtx;
    }

    protected static RelationContext instance(String queryFKString, boolean inverseFKString) {
        RelationContext newCtx = new RelationContext();
        if (queryFKString != null && !queryFKString.trim().isEmpty()) {
            if (RelationContext.backCompatFormat(queryFKString)) {
                newCtx.linkDelimiter = "\\.";
                newCtx.dsDelimiter = ":";
                newCtx.fieldDelimiter = "-";
            } else {
                newCtx.linkDelimiter = ":";
                newCtx.dsDelimiter = "\\.";
                newCtx.fieldDelimiter = "-";
            }
            newCtx.queryFK = queryFKString.split(newCtx.linkDelimiter);
            newCtx.inverseFKString = inverseFKString;
            newCtx.init();
        }
        if (!newCtx.empty()) {
            return newCtx;
        }
        return null;
    }

    private RelationContext() {
    }

    private static boolean backCompatFormat(String queryFKString) {
        if (queryFKString.contains(":")) {
            return false;
        }
        String[] parts = queryFKString.split("\\.");
        if (parts.length <= 1) {
            return false;
        }
        if (parts.length > 2) {
            return true;
        }
        String dsName = parts[0];
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(dsName, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ds == null;
    }

    private void init() {
        int length = this.queryFK.length;
        if (length > 0) {
            this.links = new RelationLink[length];
            if (this.inverseFKString) {
                int start = 0;
                for (int end = length - 1; start < end; ++start, --end) {
                    String temp = this.queryFK[start];
                    this.queryFK[start] = this.queryFK[end];
                    this.queryFK[end] = temp;
                }
            }
            for (int i = 0; i < length; ++i) {
                RelationLink link = new RelationLink();
                String instruction = this.queryFK[i];
                String[] parts = instruction.split(this.dsDelimiter);
                if (parts.length == 2) {
                    link.ds = parts[0];
                    link.fields = new ArrayList<String>(Arrays.asList(parts[1].split(this.fieldDelimiter)));
                } else if (parts.length == 1) {
                    link.fields = new ArrayList<String>(Arrays.asList(parts[0].split(this.fieldDelimiter)));
                } else {
                    log.debug("Cannot use queryFK fragment: '" + instruction + "', incorrect format.");
                    this.queryFK = null;
                    this.links = null;
                    break;
                }
                this.links[i] = link;
            }
        }
    }

    protected boolean validateField(String dsName, String fieldName) {
        if (this.empty() || this.finished()) {
            return true;
        }
        String ctxDS = this.ds();
        if ((ctxDS == null || dsName.equals(ctxDS)) && this.fields().contains(fieldName)) {
            this.draftField(fieldName);
            return true;
        }
        return !this.inUse();
    }

    protected String ds() {
        if (this.queryFK != null && this.current >= 0 && this.current < this.queryFK.length) {
            return this.links[this.current].ds;
        }
        return null;
    }

    protected List<String> fields() {
        if (this.queryFK != null && this.current >= 0 && this.current < this.queryFK.length) {
            return this.links[this.current].fields;
        }
        return null;
    }

    protected void matchField(String fieldName) {
        this.links[this.current].draftField(fieldName);
    }

    protected void draftField(String fieldName) {
        this.drafted = this.current;
        this.links[this.current].draftField(fieldName);
    }

    protected void confirmField(String fieldName) {
        this.links[this.current].confirmField(fieldName);
    }

    protected void cancelField(String fieldName) {
        if (!this.drafted()) {
            return;
        }
        this.links[this.current].cancelField(fieldName);
    }

    protected boolean validDraft() {
        return this.drafted() && this.links[this.current].valid();
    }

    protected RelationContext cancel() {
        if (this.drafted()) {
            --this.drafted;
        }
        this.links[this.current].reset();
        return this;
    }

    protected RelationContext next() {
        ++this.current;
        return this;
    }

    protected boolean drafted() {
        return !this.finished() && this.drafted >= 0 && this.drafted == this.current;
    }

    protected boolean inUse() {
        return this.current > 0 && this.current < this.queryFK.length;
    }

    protected boolean finished() {
        if (this.empty()) {
            return true;
        }
        return this.current >= this.queryFK.length;
    }

    protected boolean empty() {
        return this.queryFK == null || this.queryFK.length == 0;
    }

    protected void setState(RelationContext ctx) {
        this.current = ctx.current;
        this.drafted = ctx.drafted;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RelationContext{");
        sb.append("queryFK=").append(this.queryFK == null ? "null" : Arrays.asList(this.queryFK).toString());
        sb.append(", inverseFKString=").append(this.inverseFKString);
        sb.append(", links=").append(this.links == null ? "null" : Arrays.asList(this.links).toString());
        sb.append(", current=").append(this.current);
        sb.append(", drafted=").append(this.drafted);
        sb.append('}');
        return sb.toString();
    }

    public String toStringMinimal() {
        StringBuffer sb = new StringBuffer("RelationContext{");
        sb.append(", current=").append(this.current);
        sb.append(", drafted=").append(this.drafted);
        sb.append('}');
        return sb.toString();
    }

    public String toStringQueryFK() {
        StringBuffer sb = new StringBuffer("RelationContext{");
        sb.append("queryFK=").append(this.queryFK == null ? "null" : Arrays.asList(this.queryFK).toString());
        sb.append(", inverseFKString=").append(this.inverseFKString);
        sb.append('}');
        return sb.toString();
    }

    public String toStringLogWithLinks() {
        StringBuffer sb = new StringBuffer("RelationContext{");
        sb.append("queryFK=").append(this.queryFK == null ? "null" : Arrays.asList(this.queryFK).toString());
        sb.append(", inverseFKString=").append(this.inverseFKString);
        sb.append(", links=").append(this.links == null ? "null" : Arrays.asList(this.links).toString());
        sb.append('}');
        return sb.toString();
    }

    class RelationLink {
        private String ds;
        List<String> fields = new ArrayList<String>();
        List<String> draftFields = new ArrayList<String>();
        List<String> confirmedFields = new ArrayList<String>();

        RelationLink() {
        }

        public boolean draftField(String fieldName) {
            if (!this.fields.contains(fieldName)) {
                return false;
            }
            this.draftFields.add(fieldName);
            return true;
        }

        public boolean confirmField(String fieldName) {
            if (!this.draftFields.contains(fieldName)) {
                return false;
            }
            this.confirmedFields.add(fieldName);
            return true;
        }

        public void cancelField(String fieldName) {
            this.draftFields.remove(fieldName);
            this.confirmedFields.remove(fieldName);
        }

        public void reset() {
            this.draftFields.clear();
            this.confirmedFields.clear();
        }

        public boolean valid() {
            return this.confirmedFields.size() == this.fields.size();
        }

        public String toString() {
            return (String)(this.ds != null ? this.ds + ":" : "") + String.join((CharSequence)"-", this.fields);
        }
    }
}

