/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.velocity;

import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.OperationNotSupportedException;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StoredRecordHandler
implements Map {
    private static final String CLASS_NAME = StoredRecordHandler.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    private Map cache = new HashMap();
    ValidationContext validationContext;
    private Map storedRecord;
    private DataSource ds;
    private Map pk;
    boolean warnOnNoRecord;

    public StoredRecordHandler(ValidationContext validationContext) {
        this.validationContext = validationContext;
        this.setCurrentRecord();
    }

    public StoredRecordHandler(DataSource ds, Map record) {
        this.validationContext = null;
        this.setCurrentRecord(ds, record);
    }

    public void setCurrentRecord() {
        if (this.validationContext != null) {
            this.setCurrentRecord(this.validationContext.getCurrentDataSource(), this.validationContext.getCurrentRecord());
        } else {
            this.setCurrentRecord(null, null);
        }
    }

    public void setCurrentRecord(DataSource ds, Map record) {
        this.storedRecord = null;
        this.ds = null;
        this.pk = null;
        this.warnOnNoRecord = true;
        if (ds == null) {
            this.storedRecord = new HashMap();
            this.pk = new HashMap();
            this.warnOnNoRecord = false;
        } else {
            this.ds = ds;
            if (ds.getPrimaryKeys().size() < 1) {
                this.storedRecord = new HashMap();
                this.pk = new HashMap();
                this.warnOnNoRecord = false;
            } else if (record == null) {
                this.storedRecord = new HashMap();
                this.pk = new HashMap();
                this.warnOnNoRecord = false;
            } else {
                this.pk = new HashMap();
                ArrayList<String> missingPKs = new ArrayList<String>();
                for (String pkName : ds.getPrimaryKeys()) {
                    if (record.containsKey(pkName)) {
                        this.pk.put(pkName, record.get(pkName));
                        continue;
                    }
                    missingPKs.add(pkName);
                }
                if (!missingPKs.isEmpty()) {
                    this.storedRecord = new HashMap();
                    this.pk = new HashMap();
                    this.warnOnNoRecord = false;
                }
            }
        }
    }

    private void findRecordInCache() {
        Map recordsForDS = (Map)this.cache.get(this.ds.getName());
        if (recordsForDS != null) {
            Map recordForPK = (Map)recordsForDS.get(this.pk);
            if (recordForPK != null) {
                this.storedRecord = recordForPK;
            }
        } else {
            this.storedRecord = null;
        }
    }

    private void fetchStoredRecord() {
        this.findRecordInCache();
        if (this.storedRecord == null) {
            try {
                HashMap<Map, Map> recordsForDS;
                this.storedRecord = this.ds.fetchById(this.pk, this.validationContext == null ? null : this.validationContext.getRPCManager());
                if (this.storedRecord == null) {
                    this.storedRecord = new HashMap();
                    if (!this.warnOnNoRecord) {
                        log.warn("There is no record in data base with PK=" + String.valueOf(this.pk) + ".");
                    }
                }
                if ((recordsForDS = (HashMap<Map, Map>)this.cache.get(this.ds.getName())) == null) {
                    recordsForDS = new HashMap<Map, Map>();
                    this.cache.put(this.ds.getName(), recordsForDS);
                }
                recordsForDS.put(this.pk, this.storedRecord);
            }
            catch (OperationNotSupportedException ex) {
                this.storedRecord = new HashMap();
            }
            catch (Exception ex) {
                this.storedRecord = new HashMap();
                log.error((Object)("Failed to fetch stored record with primary key " + String.valueOf(this.pk) + " from data base. Treating as no reocrd."), ex);
            }
        }
    }

    public boolean recordExists() {
        if (this.storedRecord == null) {
            this.warnOnNoRecord = false;
            this.fetchStoredRecord();
        }
        return !this.storedRecord.isEmpty();
    }

    @Override
    public int size() {
        if (this.storedRecord == null) {
            this.fetchStoredRecord();
        }
        return this.storedRecord.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.storedRecord == null) {
            this.fetchStoredRecord();
        }
        return this.storedRecord.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.storedRecord == null) {
            this.fetchStoredRecord();
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.storedRecord == null) {
            this.fetchStoredRecord();
        }
        return this.storedRecord.containsValue(value);
    }

    public Object get(Object key) {
        if (this.storedRecord == null) {
            this.fetchStoredRecord();
        }
        return this.storedRecord.get(key);
    }

    public Object put(Object key, Object value) {
        if (this.storedRecord == null) {
            this.fetchStoredRecord();
        }
        return this.storedRecord.put(key, value);
    }

    public Object remove(Object key) {
        if (this.storedRecord == null) {
            this.fetchStoredRecord();
        }
        return this.storedRecord.remove(key);
    }

    public void putAll(Map m) {
        if (this.storedRecord == null) {
            this.fetchStoredRecord();
        }
        this.storedRecord.putAll(m);
    }

    @Override
    public void clear() {
        if (this.storedRecord == null) {
            this.fetchStoredRecord();
        }
        this.storedRecord.clear();
    }

    public Set keySet() {
        if (this.storedRecord == null) {
            this.fetchStoredRecord();
        }
        return this.storedRecord.keySet();
    }

    public Collection values() {
        if (this.storedRecord == null) {
            this.fetchStoredRecord();
        }
        return this.storedRecord.values();
    }

    public Set entrySet() {
        if (this.storedRecord == null) {
            this.fetchStoredRecord();
        }
        return this.storedRecord.entrySet();
    }
}

