/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.jpa;

import com.isomorphic.base.Config;
import com.isomorphic.jpa.EMFProviderInterface;
import com.isomorphic.log.Logger;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Persistence;
import jakarta.persistence.PersistenceException;
import java.util.Properties;

public class EMFProviderLMT
implements EMFProviderInterface {
    private static final String CLASS_NAME = EMFProviderLMT.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    protected EntityManagerFactory emf;

    public EMFProviderLMT() {
        this(Config.getGlobal().getString((Object)"jpa.persistenceUnitName", null));
    }

    public EMFProviderLMT(Properties config) {
        this(config.getProperty("persistenceUnitName"));
    }

    public EMFProviderLMT(String persistenceUnitName) {
        this.emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
    }

    @Override
    public EntityManagerFactory get() {
        return this.emf;
    }

    @Override
    public EntityManager getEntityManager() throws PersistenceException {
        return this.emf.createEntityManager();
    }

    @Override
    public void returnEntityManager(EntityManager em) {
        if (em != null) {
            try {
                if (em.isOpen()) {
                    em.close();
                }
            }
            catch (PersistenceException ex) {
                log.warn((Object)"Failed to close EntityManager.", (Throwable)ex);
            }
        }
    }

    @Override
    public Object getTransaction(EntityManager em) throws Exception {
        if (em != null) {
            EntityTransaction tx = em.getTransaction();
            if (!tx.isActive()) {
                tx.begin();
            }
            return tx;
        }
        throw new PersistenceException("Entity manager not provided.");
    }

    @Override
    public void commitTransaction(Object tx) throws Exception {
        if (tx != null && ((EntityTransaction)tx).isActive()) {
            ((EntityTransaction)tx).commit();
        }
    }

    @Override
    public void rollbackTransaction(Object tx) {
        if (tx != null && ((EntityTransaction)tx).isActive()) {
            try {
                ((EntityTransaction)tx).rollback();
            }
            catch (Exception ex) {
                log.warn((Object)"Unexpected exception while rolling back transaction", (Throwable)ex);
            }
        }
    }
}

