/*

  SmartClient Ajax RIA system
  Version v14.0p_2026-02-16/LGPL Deployment (2026-02-16)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
isc.defineClass("LRUCache", null, null, true);

isc.LRUCache.addProperties({

    // @attr LRUCache.maxSize (integer : 10 : IR)
    // The maximum number of entries. Must be greater than 0.
    maxSize: 10,

    // @attr LRUCache.size (integer : 0 : R)
    // The number of entries in the cache.
    //size: 0,

    init : function () {
        if (!this.maxSize || !(this.maxSize >= 1)) this.maxSize = 1;
        this.size = 0;
        this.entryForKey = {};
        this.youngest = null;
        this.oldest = null;
    },

    hasKey : function (key) {
        
        return (key in this.entryForKey);
    },

    __getEntry : function (key) {
        key = String(key);

        

        var entry = this.entryForKey[key];
        if (entry == null) return;

        
        if (entry != this.youngest) {
            // Remove the entry from the list.
            entry.younger.older = entry.older;
            if (entry.older == null) {
                this.oldest = entry.younger;
            } else {
                entry.older.younger = entry.younger;
            }

            // Add the entry to the head of the list.
            this.youngest.younger = entry;
            entry.younger = null;
            entry.older = this.youngest;
            this.youngest = entry;
        }

        
        return entry;
    },

    get : function (key) {
        var entry = this.__getEntry(key);
        return entry && entry.value;
    },

    put : function (key, value) {
        key = String(key);

        var entry = this.__getEntry(key);
        if (entry) {
            entry.value = value;
            return;
        }

        

        entry = {
            key: key,
            value: value,
            younger: null,
            older: this.youngest
        };

        this.entryForKey[key] = entry;
        ++this.size;

        if (this.size == 1) {
            this.youngest = this.oldest = entry;
        } else {
            // Make `entry` the youngest entry.
            this.youngest.younger = entry;
            this.youngest = entry;

            // If the cache is now over the `maxSize` then remove the oldest entry.
            while (this.size > this.maxSize) {
                
                var oldest = this.oldest,
                    secondOldest = oldest.younger;

                this.oldest = secondOldest;
                secondOldest.older = null;

                delete this.entryForKey[oldest.key];
                --this.size;

                this.fireCallback(this.keyEvicted, "key", [oldest.key]);
            }
        }

        
    }

    
});
