/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.callbacks;

import com.smartgwt.client.ai.BuildUIViaAIContext;
import com.smartgwt.client.callbacks.BuildUIViaAICustomValidationResultCallback;

public interface BuildUIViaAICustomValidator {

    /** 
     * When CUSTOM is included among the {@link com.smartgwt.client.ai.BuildUIViaAIRequest#getValidationTypes
     * BuildUIViaAIRequest.validationTypes}, this is a callback that will be called to continue validating and/or correcting
     * the response from the AI to the build-UI-via-AI request. This callback will not be called if the build-UI process fails
     * before reaching custom validation. <p> The {@link com.smartgwt.client.ai.BuildViaAIRequest#getMaxRetries
     * BuildUIViaAIRequest.maxRetries} limit is not applied during the running of the custom validator; any AI requests that
     * the custom validator makes will not be affected by this setting of the build-UI-via-AI request. <p> An implementation of
     * this function must always call the provided callback with the working response, possibly modified according to the
     * result of custom validation.
     *
     * @param buildContext Read-only context for the ongoing build-UI-via-AI operation.
     * @param validationContext The validationContext object supplied by a previous try of the validator.
     * @param callback The callback to call with the result of custom validation.
     */
	public void execute(BuildUIViaAIContext buildContext, Object validationContext, BuildUIViaAICustomValidationResultCallback callback);
} 
