package com.smartgwt.sample.showcase.client.dataintegration.java.serversummaries;

import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.grid.HeaderSpan;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class AggregationAndJoinSample extends ShowcasePanel {

    private static final String DESCRIPTION =
        "If you have a one-to-many relationship between dataSources, where one one \r" +
        "main record has many related detail records, the \r" +
        "<code>includeSummaryFunction</code> feature allows you to show\r" +
        "computed summaries from the related records.\r" +
        "<p>\r" +
        "Use <code>field.includeFrom</code> to point to the detail DataSource, and\r" +
        "<code>includeSummaryFunction</code> to declare how to aggregate data. When\r" +
        "<code>field.includeFrom</code> is specified and multiple records exist in the related DataSource\r" +
        "per record in the including DataSource, <code>includeSummaryFunction</code> indicates which\r" +
        "<code>SummaryFunction</code> is used to produce the field value.\r" +
        "<p>\r" +
        "In the sample below we have a fetch against the <code>orders</code> DataSource including\r" +
        "aggregated data from the related <code>orderItem</code> DataSource:\r" +
        "<ul>\r" +
        "<li/><code>orderItems</code> count per order\r" +
        "<li/>Concatenation of all <code>orderItem.itemDescription</code> values per order\r" +
        "</ul>";
    
    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
        	AggregationAndJoinSample panel = new AggregationAndJoinSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {

    	final ListGrid orderList = new ListGrid();
    	orderList.setDataSource(DataSource.get("aggregationJoin_order"));
    	orderList.setWidth(720);
    	orderList.setHeight(300);
    	orderList.setShowFilterEditor(true);
    	orderList.setAlternateRecordStyles(true);
    	orderList.setAutoFetchData(true);
    	orderList.setCanEdit(false);
    	orderList.setCanRemoveRecords(false);
    	orderList.setWrapHeaderTitles(true);
    	orderList.setWrapCells(true);
    	orderList.setCellHeight(40);
    	orderList.setHeaderHeight(65);
    	
    	ListGridField trackingNumber = new ListGridField("trackingNumber");
    	trackingNumber.setType(ListGridFieldType.INTEGER);
    	trackingNumber.setWidth(90);
    	trackingNumber.setTitle("Number");
    	ListGridField orderDate = new ListGridField("orderDate");
    	orderDate.setType(ListGridFieldType.DATE);
    	orderDate.setWidth(100);
    	orderDate.setTitle("Date");    	
    	ListGridField customerName = new ListGridField("customerName");
    	customerName.setWidth(180);
    	customerName.setTitle("Customer");
    	ListGridField itemCount = new ListGridField("itemCount");
    	itemCount.setType(ListGridFieldType.INTEGER);
    	itemCount.setTitle("Count");
    	itemCount.setWidth(80);
    	ListGridField items = new ListGridField("items");
    	items.setWidth("*");
    	items.setTitle("Description");
    	
    	orderList.setFields(trackingNumber,orderDate,customerName,itemCount,items);    	
    	
    	orderList.setHeaderSpans(new HeaderSpan[] {
    			new HeaderSpan("Items", new String[] {"itemCount", "items"})
        });
    	
        return orderList;
    }


    public String getIntro() {
        return DESCRIPTION;
    }

    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[] {
            new SourceEntity("aggregationJoin_orderItem.ds.xml", XML, "source/aggregationJoin_orderItem.ds.xml.html", true)
        };
    }
}
