/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.PoolableDataSourceFactory;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.pool.PoolManager;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DataSourceManager
extends Base {
    private static Logger log = new Logger(DataSourceManager.class.getName());
    public static PoolManager poolManager = new PoolManager("datasources", new PoolableDataSourceFactory());
    private static boolean poolDynamicDataSources = Config.getGlobal().getBoolean((Object)"datasources.poolDynamicDataSources", false);
    private static long count = 0L;
    private static long millis = 0L;

    public static void restartPoolManager() throws Exception {
        poolManager.close();
        poolManager = new PoolManager("datasources", new PoolableDataSourceFactory());
    }

    public static void clearPooledInstances(String dsName) throws Exception {
        poolManager.clearPool(dsName);
    }

    public static void clearAllDataSourceCaches() throws Exception {
    }

    public static DataSource getDataSource(String name) throws Exception {
        return DataSourceManager.getDataSource(name, null);
    }

    public static DataSource getDataSource(String name, DSRequest request) throws Exception {
        return DataSourceManager.getDataSource(name, request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSource getDataSource(String name, DSRequest dsRequest, DataTypeMap flags) throws Exception {
        DataTypeMap passedFlags;
        long start = 0L;
        if (log.isDebugEnabled()) {
            ++count;
            start = System.currentTimeMillis();
        }
        if ((flags = (passedFlags = flags) != null ? (DataTypeMap)((Object)DataTools.cascadeMaps(new Map[]{DataSource.getLoadFlags(), passedFlags, new DataTypeMap()})) : DataSource.getLoadFlags()) != null && flags.getBoolean((Object)"forComponentXML", false) && (DataSource.getBuiltinType(name) != null || "field".equals(name))) {
            return null;
        }
        if (passedFlags != null) {
            DataSource.pushLoadFlags(flags);
        }
        try {
            DataSource ds = null;
            ds = !poolDynamicDataSources && DataSource.isDynamic(name) || flags.getBoolean((Object)"forceUnpooled", false) || config.threadLocalInEffect() ? (DataSource)poolManager.borrowUnpooledObject(name, dsRequest) : (DataSource)poolManager.borrowObject(name, dsRequest);
            DataSource dataSource = ds;
            return dataSource;
        }
        finally {
            if (passedFlags != null) {
                DataTypeMap dataTypeMap = DataSource.popLoadFlags();
            }
        }
    }

    public static DataSource get(String name) throws Exception {
        return DataSourceManager.getDataSource(name);
    }

    public static DataSource get(String name, DSRequest dsRequest) throws Exception {
        return DataSourceManager.getDataSource(name, dsRequest);
    }

    public static DataSource get(String name, DSRequest dsRequest, DataTypeMap flags) throws Exception {
        return DataSourceManager.getDataSource(name, dsRequest, flags);
    }

    public static void freeDataSource(DataSource ds) {
        DataSourceManager.free(ds);
    }

    public static void free(DataSource ds) {
        BasicDataSource superDS;
        if (ds == null) {
            return;
        }
        if (!ds.belongsToThread(Thread.currentThread())) {
            if (!"Finalizer".equals(Thread.currentThread().getName())) {
                return;
            }
            log.warn("Allowing the Finalizer thread to passivate instance " + ds.getInstanceId() + " of DataSource '" + ds.getID() + "'");
        }
        if (ds instanceof BasicDataSource && (superDS = ((BasicDataSource)ds).superDS) != null) {
            ((BasicDataSource)ds).superDS = null;
            DataSourceManager.free(superDS);
        }
        ds.clearState();
        if (poolManager == null || poolManager.isClosed() || !poolDynamicDataSources && DataSource.isDynamic(ds.getID())) {
            ds = null;
        } else if (DataTools.getBoolean(ds.getConfig(), "doNotPool")) {
            poolManager.invalidateObject(ds.getName(), ds);
        } else {
            poolManager.returnObject(ds.getName(), ds);
        }
    }

    public static List getFullDSList(List dataSources) {
        ArrayList<String> fullDSList = new ArrayList<String>();
        for (String dsName : dataSources) {
            if (dsName.indexOf("/") != -1) {
                try {
                    ISCFile location = ISCFile.newInstance(dsName);
                    DataTypeMap criteria = DataTools.buildMap("fileType", "ds", "fileFormat", "xml");
                    List<Map<String, Object>> children = location.findChildAttributes((Object)criteria, null);
                    for (Map map : children) {
                        dsName = map.get("fileName").toString();
                        if (fullDSList.contains(dsName)) continue;
                        fullDSList.add(dsName);
                    }
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (fullDSList.contains(dsName)) continue;
            fullDSList.add(dsName);
        }
        return fullDSList;
    }

    public static Set<String> getDefinedDataSourceIdentifiers() {
        List dsList = DataSourceManager.getFullDSList(Config.getGlobal().getCommaSeparatedList("project.datasources", new ArrayList<String>()));
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(dsList);
        return result;
    }
}

