/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.chart;

import com.smartgwt.client.data.Record;

public class RegressionLinesChartData extends Record {

    private RegressionLinesChartData(int seconds, double measurement) {
        setAttribute("time", seconds);
        setAttribute("value", (float) measurement);
    }

    public static Record[] getData() {
        return new Record[] {
            new RegressionLinesChartData(   0,   50.946),
            new RegressionLinesChartData(   1,   62.544),
            new RegressionLinesChartData(   2,   50.456),
            new RegressionLinesChartData(   3,    70.03),
            new RegressionLinesChartData(   4,   86.885),
            new RegressionLinesChartData(   5,   75.987),
            new RegressionLinesChartData(   6,   85.668),
            new RegressionLinesChartData(   7,  115.721),
            new RegressionLinesChartData(   8,  146.745),
            new RegressionLinesChartData(   9,  139.255),
            new RegressionLinesChartData(  10,   88.063),
            new RegressionLinesChartData(  11,   91.356),
            new RegressionLinesChartData(  12,  123.342),
            new RegressionLinesChartData(  13,    83.71),
            new RegressionLinesChartData(  14,  116.391),
            new RegressionLinesChartData(  15,  116.466),
            new RegressionLinesChartData(  16,  118.405),
            new RegressionLinesChartData(  17,  108.053),
            new RegressionLinesChartData(  18,   49.787),
            new RegressionLinesChartData(  19,   99.652),
            new RegressionLinesChartData(  20,  117.136),
            new RegressionLinesChartData(  21,  103.006),
            new RegressionLinesChartData(  22,  161.445),
            new RegressionLinesChartData(  23,  130.932),
            new RegressionLinesChartData(  24,  121.054),
            new RegressionLinesChartData(  25,      101),
            new RegressionLinesChartData(  26,   92.111),
            new RegressionLinesChartData(  27,  113.217),
            new RegressionLinesChartData(  28,   87.579),
            new RegressionLinesChartData(  29,   69.009),
            new RegressionLinesChartData(  30,   78.862),
            new RegressionLinesChartData(  31,   125.02),
            new RegressionLinesChartData(  32,   62.803),
            new RegressionLinesChartData(  33,   75.175),
            new RegressionLinesChartData(  34,   68.199),
            new RegressionLinesChartData(  35,    6.682),
            new RegressionLinesChartData(  36,   74.135),
            new RegressionLinesChartData(  37,   49.713),
            new RegressionLinesChartData(  38,   36.408),
            new RegressionLinesChartData(  39,   72.511),
            new RegressionLinesChartData(  40,   67.526),
            new RegressionLinesChartData(  41,   90.387),
            new RegressionLinesChartData(  42,  132.304),
            new RegressionLinesChartData(  43,   -6.353),
            new RegressionLinesChartData(  44,   94.964),
            new RegressionLinesChartData(  45,   24.186),
            new RegressionLinesChartData(  46,   36.053),
            new RegressionLinesChartData(  47,   17.861),
            new RegressionLinesChartData(  48,   87.076),
            new RegressionLinesChartData(  49,   66.341),
            new RegressionLinesChartData(  50,  -67.926),
            new RegressionLinesChartData(  51,   -16.69),
            new RegressionLinesChartData(  52,   18.377),
            new RegressionLinesChartData(  53,   21.568),
            new RegressionLinesChartData(  54,   -0.617),
            new RegressionLinesChartData(  55,   63.388),
            new RegressionLinesChartData(  56,   19.392),
            new RegressionLinesChartData(  57,   51.275),
            new RegressionLinesChartData(  58,    5.073),
            new RegressionLinesChartData(  59,   32.559),
            new RegressionLinesChartData(  60,   64.111),
            new RegressionLinesChartData(  61,   70.294),
            new RegressionLinesChartData(  62,   17.982),
            new RegressionLinesChartData(  63,    8.482),
            new RegressionLinesChartData(  64,    8.886),
            new RegressionLinesChartData(  65,   35.134),
            new RegressionLinesChartData(  66,    7.272),
            new RegressionLinesChartData(  67,  -19.783),
            new RegressionLinesChartData(  68,     5.54),
            new RegressionLinesChartData(  69,  -20.871),
            new RegressionLinesChartData(  70,   12.892),
            new RegressionLinesChartData(  71,  -59.146),
            new RegressionLinesChartData(  72,    6.768),
            new RegressionLinesChartData(  73,    8.667),
            new RegressionLinesChartData(  74,   32.765),
            new RegressionLinesChartData(  75,   22.658),
            new RegressionLinesChartData(  76,    5.017),
            new RegressionLinesChartData(  77,    6.131),
            new RegressionLinesChartData(  78,  -19.935),
            new RegressionLinesChartData(  79,   35.189),
            new RegressionLinesChartData(  80,    8.099),
            new RegressionLinesChartData(  81,   -1.411),
            new RegressionLinesChartData(  82,   26.419),
            new RegressionLinesChartData(  83,   -3.264),
            new RegressionLinesChartData(  84,   18.663),
            new RegressionLinesChartData(  85,   -0.409),
            new RegressionLinesChartData(  86,  -10.051),
            new RegressionLinesChartData(  87,   16.232),
            new RegressionLinesChartData(  88,   18.545),
            new RegressionLinesChartData(  89,   67.103),
            new RegressionLinesChartData(  90,   20.267),
            new RegressionLinesChartData(  91,   32.747),
            new RegressionLinesChartData(  92,    17.72),
            new RegressionLinesChartData(  93,    -2.96),
            new RegressionLinesChartData(  94,  106.244),
            new RegressionLinesChartData(  95,   50.582),
            new RegressionLinesChartData(  96,   11.309),
            new RegressionLinesChartData(  97,   21.955),
            new RegressionLinesChartData(  98,   10.543),
            new RegressionLinesChartData(  99,   25.291),
            new RegressionLinesChartData( 100,   19.467),
            new RegressionLinesChartData( 101,  113.248),
            new RegressionLinesChartData( 102,  -11.541),
            new RegressionLinesChartData( 103,   64.764),
            new RegressionLinesChartData( 104,   20.025),
            new RegressionLinesChartData( 105,   47.116),
            new RegressionLinesChartData( 106,  127.637),
            new RegressionLinesChartData( 107,   69.623),
            new RegressionLinesChartData( 108,   10.325),
            new RegressionLinesChartData( 109,   24.296),
            new RegressionLinesChartData( 110,   76.235),
            new RegressionLinesChartData( 111,   82.936),
            new RegressionLinesChartData( 112,  117.011),
            new RegressionLinesChartData( 113,  122.199),
            new RegressionLinesChartData( 114,   92.476),
            new RegressionLinesChartData( 115,   49.542),
            new RegressionLinesChartData( 116,   87.275),
            new RegressionLinesChartData( 117,    -1.76),
            new RegressionLinesChartData( 118,  113.271),
            new RegressionLinesChartData( 119,   43.854),
            new RegressionLinesChartData( 120,  177.503),
            new RegressionLinesChartData( 121,  139.488),
            new RegressionLinesChartData( 122,  128.226),
            new RegressionLinesChartData( 123,  138.834),
            new RegressionLinesChartData( 124,  171.518),
            new RegressionLinesChartData( 125,   48.818),
            new RegressionLinesChartData( 126,  156.977),
            new RegressionLinesChartData( 127,  186.456),
            new RegressionLinesChartData( 128,  132.923),
            new RegressionLinesChartData( 129,   32.531),
            new RegressionLinesChartData( 130,  144.116),
            new RegressionLinesChartData( 131,   76.287),
            new RegressionLinesChartData( 132,   92.764),
            new RegressionLinesChartData( 133,  127.686),
            new RegressionLinesChartData( 134,  138.969),
            new RegressionLinesChartData( 135,  141.198),
            new RegressionLinesChartData( 136,   144.94),
            new RegressionLinesChartData( 137,  108.516),
            new RegressionLinesChartData( 138,  136.875),
            new RegressionLinesChartData( 139,  183.533),
            new RegressionLinesChartData( 140,  116.436),
            new RegressionLinesChartData( 141,   114.19),
            new RegressionLinesChartData( 142,  179.841),
            new RegressionLinesChartData( 143,  135.828),
            new RegressionLinesChartData( 144,  125.272),
            new RegressionLinesChartData( 145,  150.179),
            new RegressionLinesChartData( 146,  144.586),
            new RegressionLinesChartData( 147,  133.862),
            new RegressionLinesChartData( 148,  133.566),
            new RegressionLinesChartData( 149,  135.863),
            new RegressionLinesChartData( 150,  232.857),
            new RegressionLinesChartData( 151,  133.586),
            new RegressionLinesChartData( 152,  164.635),
            new RegressionLinesChartData( 153,  113.745),
            new RegressionLinesChartData( 154,  124.458),
            new RegressionLinesChartData( 155,  108.725),
            new RegressionLinesChartData( 156,  130.797),
            new RegressionLinesChartData( 157,  132.311),
            new RegressionLinesChartData( 158,  128.864),
            new RegressionLinesChartData( 159,  155.064),
            new RegressionLinesChartData( 160,  128.222),
            new RegressionLinesChartData( 161,  116.734),
            new RegressionLinesChartData( 162,  135.163),
            new RegressionLinesChartData( 163,  195.442),
            new RegressionLinesChartData( 164,  120.697),
            new RegressionLinesChartData( 165,  123.006),
            new RegressionLinesChartData( 166,  143.924),
            new RegressionLinesChartData( 167,  158.569),
            new RegressionLinesChartData( 168,  185.498),
            new RegressionLinesChartData( 169,  130.396),
            new RegressionLinesChartData( 170,  142.615),
            new RegressionLinesChartData( 171,  134.389),
            new RegressionLinesChartData( 172,   123.61),
            new RegressionLinesChartData( 173,   90.871),
            new RegressionLinesChartData( 174,  119.347),
            new RegressionLinesChartData( 175,  119.404),
            new RegressionLinesChartData( 176,   79.069),
            new RegressionLinesChartData( 177,  136.508),
            new RegressionLinesChartData( 178,  107.554),
            new RegressionLinesChartData( 179,  109.108),
            new RegressionLinesChartData( 180,  124.385),
            new RegressionLinesChartData( 181,    152.8),
            new RegressionLinesChartData( 182,  107.196),
            new RegressionLinesChartData( 183,   70.563),
            new RegressionLinesChartData( 184,  171.208),
            new RegressionLinesChartData( 185,  108.405),
            new RegressionLinesChartData( 186,   82.864),
            new RegressionLinesChartData( 187,  131.686),
            new RegressionLinesChartData( 188,  100.476),
            new RegressionLinesChartData( 189,   93.948),
            new RegressionLinesChartData( 190,   93.797),
            new RegressionLinesChartData( 191,  151.537),
            new RegressionLinesChartData( 192,    90.92),
            new RegressionLinesChartData( 193,  126.823),
            new RegressionLinesChartData( 194,   52.166),
            new RegressionLinesChartData( 195,   79.562),
            new RegressionLinesChartData( 196,  111.465),
            new RegressionLinesChartData( 197,  107.818),
            new RegressionLinesChartData( 198,  109.584),
            new RegressionLinesChartData( 199,  128.689),
            new RegressionLinesChartData( 200,   124.78),
        };
    }
}
