/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public abstract class BatchWritingMechanism {
    protected DatabaseAccessor databaseAccessor;
    protected int queryTimeoutCache = 0;
    protected int executionCount;
    protected int statementCount;
    protected int maxBatchSize;

    protected void cacheQueryTimeout(AbstractSession session, DatabaseCall dbCall) {
        int callTimeout = dbCall.getQueryTimeout();
        if (callTimeout == -1 || callTimeout == 0) {
            return;
        }
        if (callTimeout > this.queryTimeoutCache) {
            this.queryTimeoutCache = callTimeout;
        }
    }

    protected void clearCacheQueryTimeout() {
        this.queryTimeoutCache = 0;
    }

    public void setAccessor(DatabaseAccessor accessor) {
        this.databaseAccessor = accessor;
    }

    public abstract void appendCall(AbstractSession var1, DatabaseCall var2);

    public abstract void clear();

    public abstract void executeBatchedStatements(AbstractSession var1);
}

