/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.DOMImpl;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtml;

public class Element
extends Node {
    public static final String DRAGGABLE_AUTO = "auto";
    public static final String DRAGGABLE_FALSE = "false";
    public static final String DRAGGABLE_TRUE = "true";

    private static native int toInt32(double var0);

    public static Element as(JavaScriptObject o) {
        assert (Element.is(o));
        return (Element)o;
    }

    public static Element as(Node node) {
        assert (Element.is(node));
        return (Element)node;
    }

    public static boolean is(JavaScriptObject o) {
        if (Node.is(o)) {
            return Element.is((Node)o);
        }
        return false;
    }

    public static boolean is(Node node) {
        return node != null && node.getNodeType() == 1;
    }

    protected Element() {
    }

    public final boolean addClassName(String className) {
        className = Element.trimClassName(className);
        String oldClassName = this.getClassName();
        int idx = Element.indexOfName(oldClassName, className);
        if (idx == -1) {
            if (oldClassName.length() > 0) {
                this.setClassName(oldClassName + " " + className);
            } else {
                this.setClassName(className);
            }
            return true;
        }
        return false;
    }

    public final native void blur();

    public final void dispatchEvent(NativeEvent evt) {
        DOMImpl.impl.dispatchEvent(this, evt);
    }

    public final native void focus();

    public final int getAbsoluteBottom() {
        return this.getAbsoluteTop() + this.getOffsetHeight();
    }

    public final int getAbsoluteLeft() {
        return DOMImpl.impl.getAbsoluteLeft(this);
    }

    public final int getAbsoluteRight() {
        return this.getAbsoluteLeft() + this.getOffsetWidth();
    }

    public final int getAbsoluteTop() {
        return DOMImpl.impl.getAbsoluteTop(this);
    }

    public final String getAttribute(String name) {
        return DOMImpl.impl.getAttribute(this, name);
    }

    public final native String getClassName();

    public final int getClientHeight() {
        return Element.toInt32(this.getSubPixelClientHeight());
    }

    public final int getClientWidth() {
        return Element.toInt32(this.getSubPixelClientWidth());
    }

    public final native String getDir();

    public final native String getDraggable();

    public final native NodeList<Element> getElementsByTagName(String var1);

    public final Element getFirstChildElement() {
        return DOMImpl.impl.getFirstChildElement(this);
    }

    public final native String getId();

    public final String getInnerHTML() {
        return DOMImpl.impl.getInnerHTML(this);
    }

    public final String getInnerText() {
        return DOMImpl.impl.getInnerText(this);
    }

    public final native String getLang();

    public final Element getNextSiblingElement() {
        return DOMImpl.impl.getNextSiblingElement(this);
    }

    public final int getOffsetHeight() {
        return Element.toInt32(this.getSubPixelOffsetHeight());
    }

    public final int getOffsetLeft() {
        return Element.toInt32(this.getSubPixelOffsetLeft());
    }

    public final native Element getOffsetParent();

    public final int getOffsetTop() {
        return Element.toInt32(this.getSubPixelOffsetTop());
    }

    public final int getOffsetWidth() {
        return Element.toInt32(this.getSubPixelOffsetWidth());
    }

    public final Element getPreviousSiblingElement() {
        return DOMImpl.impl.getPreviousSiblingElement(this);
    }

    public final native boolean getPropertyBoolean(String var1);

    public final native double getPropertyDouble(String var1);

    public final native int getPropertyInt(String var1);

    public final native JavaScriptObject getPropertyJSO(String var1);

    public final native Object getPropertyObject(String var1);

    public final native String getPropertyString(String var1);

    public final int getScrollHeight() {
        return Element.toInt32(this.getSubPixelScrollHeight());
    }

    public final int getScrollLeft() {
        return DOMImpl.impl.getScrollLeft(this);
    }

    public final int getScrollTop() {
        return Element.toInt32(this.getSubPixelScrollTop());
    }

    public final int getScrollWidth() {
        return Element.toInt32(this.getSubPixelScrollWidth());
    }

    public final String getString() {
        return DOMImpl.impl.toString(this);
    }

    public final native Style getStyle();

    public final int getTabIndex() {
        return DOMImpl.impl.getTabIndex(this);
    }

    public final String getTagName() {
        return DOMImpl.impl.getTagName(this);
    }

    public final native String getTitle();

    public final boolean hasAttribute(String name) {
        return DOMImpl.impl.hasAttribute(this, name);
    }

    public final boolean hasClassName(String className) {
        className = Element.trimClassName(className);
        int idx = Element.indexOfName(this.getClassName(), className);
        return idx != -1;
    }

    public final boolean hasTagName(String tagName) {
        assert (tagName != null) : "tagName must not be null";
        return tagName.equalsIgnoreCase(this.getTagName());
    }

    public final native void removeAttribute(String var1);

    public final boolean removeClassName(String className) {
        className = Element.trimClassName(className);
        String oldStyle = this.getClassName();
        int idx = Element.indexOfName(oldStyle, className);
        if (idx != -1) {
            String begin = oldStyle.substring(0, idx).trim();
            String end = oldStyle.substring(idx + className.length()).trim();
            String newClassName = begin.length() == 0 ? end : (end.length() == 0 ? begin : begin + " " + end);
            this.setClassName(newClassName);
            return true;
        }
        return false;
    }

    static int indexOfName(String nameList, String name) {
        int lastPos;
        int last;
        int idx = nameList.indexOf(name);
        while (idx != -1 && (idx != 0 && nameList.charAt(idx - 1) != ' ' || (last = idx + name.length()) != (lastPos = nameList.length()) && (last >= lastPos || nameList.charAt(last) != ' '))) {
            idx = nameList.indexOf(name, idx + 1);
        }
        return idx;
    }

    private static String trimClassName(String className) {
        assert (className != null) : "Unexpectedly null class name";
        className = className.trim();
        assert (!className.isEmpty()) : "Unexpectedly empty class name";
        return className;
    }

    public final void toggleClassName(String className) {
        boolean added = this.addClassName(className);
        if (!added) {
            this.removeClassName(className);
        }
    }

    public final void replaceClassName(String oldClassName, String newClassName) {
        this.removeClassName(oldClassName);
        this.addClassName(newClassName);
    }

    public final void scrollIntoView() {
        DOMImpl.impl.scrollIntoView(this);
    }

    public final native void setAttribute(String var1, String var2);

    public final native void setClassName(String var1);

    public final native void setDir(String var1);

    public final void setDraggable(String draggable) {
        DOMImpl.impl.setDraggable(this, draggable);
    }

    public final native void setId(String var1);

    public final native void setInnerHTML(String var1);

    public final void setInnerSafeHtml(SafeHtml html) {
        this.setInnerHTML(html.asString());
    }

    public final void setInnerText(String text) {
        DOMImpl.impl.setInnerText(this, text);
    }

    public final native void setLang(String var1);

    public final native void setPropertyBoolean(String var1, boolean var2);

    public final native void setPropertyDouble(String var1, double var2);

    public final native void setPropertyInt(String var1, int var2);

    public final native void setPropertyJSO(String var1, JavaScriptObject var2);

    public final native void setPropertyObject(String var1, Object var2);

    public final native void setPropertyString(String var1, String var2);

    public final void setScrollLeft(int scrollLeft) {
        DOMImpl.impl.setScrollLeft(this, scrollLeft);
    }

    public final native void setScrollTop(int var1);

    public final native void setTabIndex(int var1);

    public final native void setTitle(String var1);

    private final native double getSubPixelClientHeight();

    private final native double getSubPixelClientWidth();

    private final native double getSubPixelOffsetHeight();

    private final native double getSubPixelOffsetLeft();

    private final native double getSubPixelOffsetTop();

    private final native double getSubPixelOffsetWidth();

    private final native double getSubPixelScrollHeight();

    private final native double getSubPixelScrollTop();

    private final native double getSubPixelScrollWidth();
}

