/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.velocity;

import com.isomorphic.log.Logger;
import com.isomorphic.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;

public class IOWrapper {
    private static Logger log = new Logger(IOWrapper.class.getName());
    private Object data;
    private String stringData;
    private Map context;
    private Map record;
    private Object key;

    private IOWrapper(Object data, Map context, Map record, Object key) {
        this.data = data;
        this.context = context;
        this.record = record;
        this.key = key;
    }

    public String toString() {
        if (this.stringData == null) {
            if (this.data instanceof InputStream) {
                try {
                    this.stringData = IOUtil.inputStreamToString((InputStream)this.data);
                }
                catch (IOException ex) {
                    log.warn((Object)"Error attempting to handle InputStream", ex);
                }
            }
            if (this.data instanceof Reader) {
                try {
                    this.stringData = IOUtil.readerToString((Reader)this.data);
                }
                catch (IOException ex) {
                    log.warn((Object)"Error attempting to handle Reader", ex);
                }
            }
            if (this.stringData != null) {
                this.context.put(this.key, this.stringData);
                this.record.put(this.key, this.stringData);
            }
        }
        return this.stringData != null ? this.stringData : this.data.toString();
    }

    public static void installWrappersToContext(Map context, Map record) {
        if (context != null) {
            for (Object key : context.keySet()) {
                Object value = context.get(key);
                if (!(value instanceof Reader) && !(value instanceof InputStream) || !record.containsKey(key)) continue;
                context.put(key, new IOWrapper(value, context, record, key));
            }
        }
    }
}

