package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * What event / user interaction type caused cell editing to complete.
 */
public enum EditCompletionEvent implements ValueEnum {
    /**
     * User clicked outside editor during edit.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "click_outside".
     */
    CLICK_OUTSIDE("click_outside"),
    /**
     * User started editing another row by clicking on it
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "click".
     */
    CLICK("click"),
    /**
     * User started editing another row by double clicking
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "doubleClick".
     */
    DOUBLE_CLICK("doubleClick"),
    /**
     * Enter pressed.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "enter".
     */
    ENTER_KEYPRESS("enter"),
    /**
     * User pressed Escape.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "escape".
     */
    ESCAPE_KEYPRESS("escape"),
    /**
     * Up arrow key pressed.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "arrow_up".
     */
    UP_ARROW_KEYPRESS("arrow_up"),
    /**
     * down arrow key.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "arrow_down".
     */
    DOWN_ARROW_KEYPRESS("arrow_down"),
    /**
     * User pressed Tab.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "tab".
     */
    TAB_KEYPRESS("tab"),
    /**
     * User pressed Shift+Tab.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "shift_tab".
     */
    SHIFT_TAB_KEYPRESS("shift_tab"),
    /**
     * Edit moved to a different field (same row)
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "field_change".
     */
    EDIT_FIELD_CHANGE("field_change"),
    /**
     * Edit completed via explicit function call
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "programmatic".
     */
    PROGRAMMATIC("programmatic");
    private String value;

    EditCompletionEvent(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
