/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LogLevelMapping;
import org.openqa.selenium.logging.LoggingPreferences;

public class DesiredCapabilities
extends MutableCapabilities {
    public DesiredCapabilities(String browser, String version, Platform platform) {
        this.setCapability("browserName", browser);
        this.setCapability("version", version);
        this.setCapability("platform", platform);
    }

    public DesiredCapabilities() {
    }

    public DesiredCapabilities(Map<String, ?> rawMap) {
        if (rawMap == null) {
            return;
        }
        rawMap.forEach(this::setCapability);
    }

    public DesiredCapabilities(Capabilities other) {
        this.merge(other);
    }

    public DesiredCapabilities(Capabilities ... others) {
        for (Capabilities caps : others) {
            this.merge(caps);
        }
    }

    public void setBrowserName(String browserName) {
        this.setCapability("browserName", browserName);
    }

    public void setVersion(String version) {
        this.setCapability("version", version);
    }

    public void setPlatform(Platform platform) {
        this.setCapability("platform", platform);
    }

    public void setJavascriptEnabled(boolean javascriptEnabled) {
        this.setCapability("javascriptEnabled", javascriptEnabled);
    }

    public boolean acceptInsecureCerts() {
        if (this.getCapability("acceptInsecureCerts") != null) {
            Object raw = this.getCapability("acceptInsecureCerts");
            if (raw instanceof String) {
                return Boolean.parseBoolean((String)raw);
            }
            if (raw instanceof Boolean) {
                return (Boolean)raw;
            }
        }
        return true;
    }

    public void setAcceptInsecureCerts(boolean acceptInsecureCerts) {
        this.setCapability("acceptInsecureCerts", acceptInsecureCerts);
    }

    @Override
    public DesiredCapabilities merge(Capabilities extraCapabilities) {
        super.merge(extraCapabilities);
        return this;
    }

    @Override
    public void setCapability(String key, Object value) {
        if ("loggingPrefs".equals(key) && value instanceof Map) {
            LoggingPreferences prefs = new LoggingPreferences();
            Map prefsMap = (Map)value;
            for (String logType : prefsMap.keySet()) {
                prefs.enable(logType, LogLevelMapping.toLevel((String)prefsMap.get(logType)));
            }
            super.setCapability("loggingPrefs", prefs);
        } else if ("platform".equals(key) && value instanceof String) {
            try {
                super.setCapability(key, Platform.fromString((String)value));
            }
            catch (WebDriverException e) {
                super.setCapability(key, value);
            }
        } else if ("unexpectedAlertBehaviour".equals(key)) {
            super.setCapability("unexpectedAlertBehaviour", value);
            super.setCapability("unhandledPromptBehavior", value);
        } else {
            super.setCapability(key, value);
        }
    }

    public static DesiredCapabilities android() {
        return new DesiredCapabilities("android", "", Platform.ANDROID);
    }

    public static DesiredCapabilities chrome() {
        return new DesiredCapabilities("chrome", "", Platform.ANY);
    }

    public static DesiredCapabilities firefox() {
        DesiredCapabilities capabilities = new DesiredCapabilities("firefox", "", Platform.ANY);
        capabilities.setCapability("acceptInsecureCerts", true);
        return capabilities;
    }

    public static DesiredCapabilities htmlUnit() {
        return new DesiredCapabilities("htmlunit", "", Platform.ANY);
    }

    public static DesiredCapabilities edge() {
        return new DesiredCapabilities("MicrosoftEdge", "", Platform.WINDOWS);
    }

    public static DesiredCapabilities internetExplorer() {
        DesiredCapabilities capabilities = new DesiredCapabilities("internet explorer", "", Platform.WINDOWS);
        capabilities.setCapability("ensureCleanSession", true);
        return capabilities;
    }

    public static DesiredCapabilities iphone() {
        return new DesiredCapabilities("iPhone", "", Platform.MAC);
    }

    public static DesiredCapabilities ipad() {
        return new DesiredCapabilities("iPad", "", Platform.MAC);
    }

    @Deprecated
    public static DesiredCapabilities opera() {
        return new DesiredCapabilities("opera", "", Platform.ANY);
    }

    public static DesiredCapabilities operaBlink() {
        return new DesiredCapabilities("operablink", "", Platform.ANY);
    }

    public static DesiredCapabilities safari() {
        return new DesiredCapabilities("safari", "", Platform.MAC);
    }

    public static DesiredCapabilities phantomjs() {
        return new DesiredCapabilities("phantomjs", "", Platform.ANY);
    }

    public String toString() {
        return String.format("Capabilities [%s]", this.shortenMapValues(this.asMap()));
    }

    private Map<String, ?> shortenMapValues(Map<String, ?> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                newMap.put(entry.getKey(), this.shortenMapValues((Map)entry.getValue()));
                continue;
            }
            String value = String.valueOf(entry.getValue());
            if (value.length() > 1024) {
                value = value.substring(0, 29) + "...";
            }
            newMap.put(entry.getKey(), value);
        }
        return newMap;
    }
}

