/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util.date;

import com.isomorphic.log.Logger;
import com.isomorphic.util.date.Period;
import com.isomorphic.util.date.RelativeDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class DateUtil {
    private static final Logger log = new Logger(DateUtil.class);

    private DateUtil() {
        throw new UnsupportedOperationException();
    }

    public static GregorianCalendar dateAdd(GregorianCalendar date, String unit, int amount, int multiplier, boolean isLogicalDate) {
        boolean boundary;
        Period period = Period.parse(unit, Period.DAY);
        date.add(period.getCalendarField(), period.getModifier() * amount * multiplier);
        boolean bl = boundary = unit.length() < 3 && StringUtils.isAllUpperCase((String)unit);
        if (boundary) {
            if (multiplier > 0) {
                return DateUtil.getEndOf(date, period, isLogicalDate);
            }
            return DateUtil.getStartOf(date, period, isLogicalDate);
        }
        GregorianCalendar calendar = new GregorianCalendar(date.getTimeZone());
        calendar.setTimeInMillis(date.getTimeInMillis());
        return calendar;
    }

    public static GregorianCalendar getStartOf(GregorianCalendar date, Period period, boolean logicalDate) {
        return DateUtil.getStartOf(date, period, logicalDate, Calendar.getInstance().getFirstDayOfWeek());
    }

    public static GregorianCalendar getStartOf(GregorianCalendar date, Period period, boolean logicalDate, int firstDayOfWeek) {
        GregorianCalendar adjusted;
        if (logicalDate && period.isDateTimePeriod()) {
            log.info("DateUtil.getStartOf() passed period:" + (Object)((Object)period) + " for logical date. Ignoring");
            GregorianCalendar newDate = new GregorianCalendar();
            newDate.setTime(date.getTime());
            return newDate;
        }
        int month = date.get(2);
        int dateVal = date.get(5);
        int year = date.get(1);
        int hours = date.get(11);
        int minutes = date.get(12);
        int seconds = date.get(13);
        int dayOfWeek = date.get(7);
        TimeZone tz = date.getTimeZone();
        switch (period) {
            case SECOND: {
                adjusted = DateUtil.getGregorianCalendar(year, month, dateVal, hours, minutes, seconds, tz);
                break;
            }
            case MINUTE: {
                adjusted = DateUtil.getGregorianCalendar(year, month, dateVal, hours, minutes, 0, tz);
                break;
            }
            case HOUR: {
                adjusted = DateUtil.getGregorianCalendar(year, month, dateVal, hours, 0, 0, tz);
                break;
            }
            case DAY: {
                if (logicalDate) {
                    adjusted = DateUtil.getGregorianCalendar(year, month, dateVal, tz);
                    break;
                }
                adjusted = DateUtil.getGregorianCalendar(year, month, dateVal, 0, 0, 0, tz);
                break;
            }
            case WEEK: {
                if (logicalDate) {
                    adjusted = DateUtil.getGregorianCalendar(year, month, dateVal, tz);
                    break;
                }
                int delta = firstDayOfWeek - dayOfWeek;
                adjusted = DateUtil.getGregorianCalendar(year, month, dateVal, 0, 0, 0, tz);
                adjusted.setTimeInMillis(adjusted.getTimeInMillis() + (long)(delta * 86400000));
                break;
            }
            case MONTH: {
                if (logicalDate) {
                    adjusted = DateUtil.getGregorianCalendar(year, month, 1, tz);
                    break;
                }
                adjusted = DateUtil.getGregorianCalendar(year, month, 1, 0, 0, 0, tz);
                break;
            }
            case QUARTER: {
                int quarterStart = month - month % 3;
                if (logicalDate) {
                    adjusted = DateUtil.getGregorianCalendar(year, quarterStart, 1, tz);
                    break;
                }
                adjusted = DateUtil.getGregorianCalendar(year, quarterStart, 1, 0, 0, 0, tz);
                break;
            }
            case YEAR: {
                if (logicalDate) {
                    adjusted = DateUtil.getGregorianCalendar(year, 0, 1, tz);
                    break;
                }
                adjusted = DateUtil.getGregorianCalendar(year, 0, 1, 0, 0, 0, tz);
                break;
            }
            case DECADE: {
                int decade = year - year % 10;
                if (logicalDate) {
                    adjusted = DateUtil.getGregorianCalendar(decade, 0, 1, tz);
                    break;
                }
                adjusted = DateUtil.getGregorianCalendar(decade, 0, 1, 0, 0, 0, tz);
                break;
            }
            case CENTURY: {
                int century = year - year % 100;
                if (logicalDate) {
                    adjusted = DateUtil.getGregorianCalendar(century, 0, 1, tz);
                    break;
                }
                adjusted = DateUtil.getGregorianCalendar(century, 0, 1, 0, 0, 0, tz);
                break;
            }
            default: {
                adjusted = new GregorianCalendar(tz);
                adjusted.setTime(date.getTime());
            }
        }
        return adjusted;
    }

    public static GregorianCalendar getEndOf(GregorianCalendar date, Period period, boolean logicalDate) {
        return DateUtil.getEndOf(date, period, logicalDate, Calendar.getInstance().getFirstDayOfWeek());
    }

    public static GregorianCalendar getEndOf(GregorianCalendar date, Period period, boolean logicalDate, int firstDayOfWeek) {
        if (logicalDate && period.isDateTimePeriod()) {
            log.info("DateUtil.getEndOf() passed period:" + (Object)((Object)period) + " for logical date. Ignoring");
            GregorianCalendar newDate = new GregorianCalendar();
            newDate.setTime(date.getTime());
            return newDate;
        }
        int month = date.get(2);
        int dateVal = date.get(5);
        int year = date.get(1);
        int hours = date.get(11);
        int minutes = date.get(12);
        int seconds = date.get(13);
        int dayOfWeek = date.get(7);
        TimeZone tz = date.getTimeZone();
        GregorianCalendar adjusted = new GregorianCalendar();
        switch (period) {
            case SECOND: {
                adjusted = DateUtil.getGregorianCalendar(year, month, dateVal, hours, minutes, seconds, tz);
                break;
            }
            case MINUTE: {
                adjusted = DateUtil.getGregorianCalendar(year, month, dateVal, hours, minutes, 59, tz);
                break;
            }
            case HOUR: {
                adjusted = DateUtil.getGregorianCalendar(year, month, dateVal, hours, 59, 59, tz);
                adjusted.set(14, 999);
                break;
            }
            case DAY: {
                if (logicalDate) {
                    adjusted = DateUtil.getGregorianCalendar(year, month, dateVal, tz);
                    break;
                }
                adjusted = DateUtil.getGregorianCalendar(year, month, dateVal, 23, 59, 59, tz);
                break;
            }
            case WEEK: {
                int delta = 6 - (dayOfWeek - firstDayOfWeek);
                if (delta >= 7) {
                    delta -= 7;
                }
                int endDate = dateVal + delta;
                if (logicalDate) {
                    adjusted = DateUtil.getGregorianCalendar(year, month, endDate, tz);
                    break;
                }
                adjusted = DateUtil.getGregorianCalendar(year, month, endDate, 23, 59, 59, tz);
                break;
            }
            case MONTH: {
                if (logicalDate) {
                    adjusted = DateUtil.getGregorianCalendar(year, month + 1, 1, tz);
                    adjusted.add(5, -1);
                    break;
                }
                adjusted = DateUtil.getGregorianCalendar(year, month + 1, 1, 0, 0, 0, tz);
                adjusted.add(14, -1);
                break;
            }
            case QUARTER: {
                int nextQ = month + 3 - month % 3;
                if (logicalDate) {
                    adjusted = DateUtil.getGregorianCalendar(year, nextQ, 1, tz);
                    adjusted.add(5, -1);
                    break;
                }
                adjusted = DateUtil.getGregorianCalendar(year, nextQ, 1, tz);
                adjusted.add(14, -1);
                break;
            }
            case YEAR: {
                if (logicalDate) {
                    adjusted = DateUtil.getGregorianCalendar(year, 11, 31, tz);
                    break;
                }
                adjusted = DateUtil.getGregorianCalendar(year, 11, 31, 23, 59, 59, tz);
                break;
            }
            case DECADE: {
                int decade = year + 10 - year % 10;
                if (logicalDate) {
                    adjusted = DateUtil.getGregorianCalendar(decade, 11, 31, tz);
                    break;
                }
                adjusted = DateUtil.getGregorianCalendar(decade, 11, 31, 23, 59, 59, tz);
                break;
            }
            case CENTURY: {
                int century = year + 100 - year % 100;
                if (logicalDate) {
                    adjusted = DateUtil.getGregorianCalendar(century, 11, 31, tz);
                    break;
                }
                adjusted = DateUtil.getGregorianCalendar(century, 11, 31, 23, 59, 59, tz);
                break;
            }
            default: {
                adjusted = new GregorianCalendar(tz);
                adjusted.setTime(date.getTime());
            }
        }
        adjusted.set(14, 999);
        return adjusted;
    }

    public static GregorianCalendar getGregorianCalendar(int year, int month, int day, TimeZone tz) {
        return DateUtil.getGregorianCalendar(year, month, day, 0, 0, 0, tz);
    }

    public static GregorianCalendar getGregorianCalendar(int year, int month, int day, int hour, int minute, int second, TimeZone tz) {
        GregorianCalendar cal = tz == null ? new GregorianCalendar() : new GregorianCalendar(tz);
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        return cal;
    }

    public static GregorianCalendar getAbsoluteDate(RelativeDate relativeDate, boolean isLogicalDate) {
        return DateUtil.getAbsoluteDate(relativeDate, null, isLogicalDate);
    }

    public static GregorianCalendar getAbsoluteDate(RelativeDate relativeDate, Date baseDate, boolean isLogicalDate) {
        return relativeDate.getAbsoluteDate(baseDate, isLogicalDate);
    }

    public static boolean isRelativeDate(Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return "RelativeDate".equals(map.get("_constructor"));
        }
        return false;
    }

    public static GregorianCalendar createLogicalDate(int year, int month, int day) {
        return DateUtil.createLogicalDate(year, month, day, Locale.getDefault());
    }

    public static GregorianCalendar createLogicalDate(int year, int month, int day, Locale locale) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        gregorianCalendar.set(1, year);
        gregorianCalendar.set(2, month);
        gregorianCalendar.set(5, day);
        gregorianCalendar.set(11, 12);
        return gregorianCalendar;
    }

    public static GregorianCalendar createLogicalDate(long millisecondsTimeStamp) {
        return DateUtil.createLogicalDate(millisecondsTimeStamp, Locale.getDefault());
    }

    public static GregorianCalendar createLogicalDate(long millisecondsTimeStamp, Locale locale) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        gregorianCalendar.setTimeInMillis(millisecondsTimeStamp);
        return gregorianCalendar;
    }
}

