/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.beust.jcommander.Parameter;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openqa.grid.common.JSONConfigurationUtils;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.utils.configuration.GridConfiguration;
import org.openqa.grid.internal.utils.configuration.converters.BrowserDesiredCapabilityConverter;
import org.openqa.grid.internal.utils.configuration.converters.NoOpParameterSplitter;
import org.openqa.grid.internal.utils.configuration.validators.FileExistsValueValidator;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.JsonToBeanConverter;

public class GridNodeConfiguration
extends GridConfiguration {
    public static final String DEFAULT_NODE_CONFIG_FILE = "defaults/DefaultNodeWebDriver.json";
    static final String DEFAULT_ROLE = "node";
    static final Integer DEFAULT_PORT = 5555;
    static final Integer DEFAULT_POLLING_INTERVAL = 5000;
    static final Integer DEFAULT_MAX_SESSION = 5;
    static final Integer DEFAULT_REGISTER_CYCLE = 5000;
    static final Boolean DEFAULT_REGISTER_TOGGLE = true;
    static final String DEFAULT_HUB = "http://localhost:4444";
    static final Integer DEFAULT_NODE_STATUS_CHECK_TIMEOUT = 5000;
    static final Integer DEFAULT_UNREGISTER_DELAY = 60000;
    static final Integer DEFAULT_DOWN_POLLING_LIMIT = 2;
    static final String DEFAULT_PROXY = "org.openqa.grid.selenium.proxy.DefaultRemoteProxy";
    @Parameter(names={"-nodeConfig"}, description="<String> filename : JSON configuration file for the node. Overrides default values", validateValueWith=FileExistsValueValidator.class)
    public String nodeConfigFile;
    @Expose(serialize=false)
    String remoteHost;
    @Expose(serialize=false)
    @Deprecated
    private Object configuration;
    @Expose
    @Parameter(names={"-hubHost"}, description="<String> IP or hostname : the host address of the hub we're attempting to register with. If -hub is specified the -hubHost is determined from it.")
    String hubHost;
    @Expose
    @Parameter(names={"-hubPort"}, description="<Integer> : the port of the hub we're attempting to register with. If -hub is specified the -hubPort is determined from it.")
    Integer hubPort;
    @Expose
    @Parameter(names={"-id"}, description="<String> : optional unique identifier for the node. Defaults to the url of the remoteHost, when not specified.")
    public String id;
    @Expose
    @Parameter(names={"-capabilities", "-browser"}, description="<String> : comma separated Capability values. Example: -capabilities browserName=firefox,platform=linux -capabilities browserName=chrome,platform=linux", listConverter=BrowserDesiredCapabilityConverter.class, converter=BrowserDesiredCapabilityConverter.class, splitter=NoOpParameterSplitter.class)
    public List<DesiredCapabilities> capabilities = DefaultDesiredCapabilitiesBuilder.getCapabilities();
    @Expose
    @Parameter(names={"-downPollingLimit"}, description="<Integer> : node is marked as \"down\" if the node hasn't responded after the number of checks specified in [downPollingLimit].")
    public Integer downPollingLimit = DEFAULT_DOWN_POLLING_LIMIT;
    @Expose
    @Parameter(names={"-hub"}, description="<String> : the url that will be used to post the registration request. This option takes precedence over -hubHost and -hubPort options.")
    public String hub = "http://localhost:4444";
    @Expose
    @Parameter(names={"-nodePolling"}, description="<Integer> in ms : specifies how often the hub will poll to see if the node is still responding.")
    public Integer nodePolling = DEFAULT_POLLING_INTERVAL;
    @Expose
    @Parameter(names={"-nodeStatusCheckTimeout"}, description="<Integer> in ms : connection/socket timeout, used for node \"nodePolling\" check.")
    public Integer nodeStatusCheckTimeout = DEFAULT_NODE_STATUS_CHECK_TIMEOUT;
    @Expose
    @Parameter(names={"-proxy"}, description="<String> : the class used to represent the node proxy. Default is [org.openqa.grid.selenium.proxy.DefaultRemoteProxy].")
    public String proxy = "org.openqa.grid.selenium.proxy.DefaultRemoteProxy";
    @Expose
    @Parameter(names={"-register"}, description="if specified, node will attempt to re-register itself automatically with its known grid hub if the hub becomes unavailable.", arity=1)
    public Boolean register = DEFAULT_REGISTER_TOGGLE;
    @Expose
    @Parameter(names={"-registerCycle"}, description="<Integer> in ms : specifies how often the node will try to register itself again. Allows administrator to restart the hub without restarting (or risk orphaning) registered nodes. Must be specified with the \"-register\" option.")
    public Integer registerCycle = DEFAULT_REGISTER_CYCLE;
    @Expose
    @Parameter(names={"-unregisterIfStillDownAfter"}, description="<Integer> in ms : if the node remains down for more than [unregisterIfStillDownAfter] ms, it will stop attempting to re-register from the hub.")
    public Integer unregisterIfStillDownAfter = DEFAULT_UNREGISTER_DELAY;

    public GridNodeConfiguration() {
        this.role = DEFAULT_ROLE;
        this.port = DEFAULT_PORT;
        this.maxSession = DEFAULT_MAX_SESSION;
    }

    public String getHubHost() {
        if (this.hubHost == null) {
            if (this.hub == null) {
                throw new RuntimeException("You must specify either a hubHost or hub parameter.");
            }
            this.parseHubUrl();
        }
        return this.hubHost;
    }

    public Integer getHubPort() {
        if (this.hubPort == null) {
            if (this.hub == null) {
                throw new RuntimeException("You must specify either a hubPort or hub parameter.");
            }
            this.parseHubUrl();
        }
        return this.hubPort;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (this.host == null) {
                this.host = "localhost";
            }
            if (this.port == null) {
                this.port = 5555;
            }
            this.remoteHost = "http://" + this.host + ":" + this.port;
        }
        return this.remoteHost;
    }

    private void parseHubUrl() {
        try {
            URL u = new URL(this.hub);
            this.hubHost = u.getHost();
            this.hubPort = u.getPort();
        }
        catch (MalformedURLException mURLe) {
            throw new RuntimeException("-hub must be a valid url: " + this.hub, mURLe);
        }
    }

    public void merge(GridNodeConfiguration other) {
        if (other == null) {
            return;
        }
        super.merge(other);
        if (this.isMergeAble(other.capabilities, this.capabilities)) {
            this.capabilities = other.capabilities;
        }
        if (this.isMergeAble(other.downPollingLimit, this.downPollingLimit)) {
            this.downPollingLimit = other.downPollingLimit;
        }
        if (this.isMergeAble(other.hub, this.hub)) {
            this.hub = other.hub;
        }
        if (this.isMergeAble(other.hubHost, this.hubHost)) {
            this.hubHost = other.hubHost;
        }
        if (this.isMergeAble(other.hubPort, this.hubPort)) {
            this.hubPort = other.hubPort;
        }
        if (this.isMergeAble(other.id, this.id)) {
            this.id = other.id;
        }
        if (this.isMergeAble(other.nodePolling, this.nodePolling)) {
            this.nodePolling = other.nodePolling;
        }
        if (this.isMergeAble(other.nodeStatusCheckTimeout, this.nodeStatusCheckTimeout)) {
            this.nodeStatusCheckTimeout = other.nodeStatusCheckTimeout;
        }
        if (this.isMergeAble(other.proxy, this.proxy)) {
            this.proxy = other.proxy;
        }
        if (this.isMergeAble(other.register, this.register)) {
            this.register = other.register;
        }
        if (this.isMergeAble(other.registerCycle, this.registerCycle)) {
            this.registerCycle = other.registerCycle;
        }
        if (this.isMergeAble(other.remoteHost, this.remoteHost)) {
            this.remoteHost = other.remoteHost;
        }
        if (this.isMergeAble(other.unregisterIfStillDownAfter, this.unregisterIfStillDownAfter)) {
            this.unregisterIfStillDownAfter = other.unregisterIfStillDownAfter;
        }
    }

    @Override
    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(format));
        sb.append((CharSequence)this.toString(format, "capabilities", this.capabilities));
        sb.append((CharSequence)this.toString(format, "downPollingLimit", this.downPollingLimit));
        sb.append((CharSequence)this.toString(format, "hub", this.hub));
        sb.append((CharSequence)this.toString(format, "id", this.id));
        sb.append((CharSequence)this.toString(format, "hubHost", this.hubHost));
        sb.append((CharSequence)this.toString(format, "hubPort", this.hubPort));
        sb.append((CharSequence)this.toString(format, "nodeConfigFile", this.nodeConfigFile));
        sb.append((CharSequence)this.toString(format, "nodePolling", this.nodePolling));
        sb.append((CharSequence)this.toString(format, "nodeStatusCheckTimeout", this.nodeStatusCheckTimeout));
        sb.append((CharSequence)this.toString(format, "proxy", this.proxy));
        sb.append((CharSequence)this.toString(format, "register", this.register));
        sb.append((CharSequence)this.toString(format, "registerCycle", this.registerCycle));
        sb.append((CharSequence)this.toString(format, "remoteHost", this.remoteHost));
        sb.append((CharSequence)this.toString(format, "unregisterIfStillDownAfter", this.unregisterIfStillDownAfter));
        return sb.toString();
    }

    public static GridNodeConfiguration loadFromJSON(String filePath) {
        return GridNodeConfiguration.loadFromJSON(JSONConfigurationUtils.loadJSON(filePath));
    }

    public static GridNodeConfiguration loadFromJSON(JsonObject json) {
        try {
            GsonBuilder builder = new GsonBuilder();
            GridNodeConfiguration.staticAddJsonTypeAdapter(builder);
            GridNodeConfiguration config = (GridNodeConfiguration)builder.excludeFieldsWithoutExposeAnnotation().create().fromJson((JsonElement)json, GridNodeConfiguration.class);
            if (config.configuration != null) {
                throw new GridConfigurationException("Deprecated -nodeConfig file encountered. Please update the file to work with Selenium 3. See https://github.com/SeleniumHQ/selenium/wiki/Grid2#configuring-the-nodes-by-json for more details.");
            }
            return config;
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error with the JSON of the config : " + e.getMessage(), e);
        }
    }

    @Override
    protected void addJsonTypeAdapter(GsonBuilder builder) {
        super.addJsonTypeAdapter(builder);
        GridNodeConfiguration.staticAddJsonTypeAdapter(builder);
    }

    protected static void staticAddJsonTypeAdapter(GsonBuilder builder) {
        builder.registerTypeAdapter(new TypeToken<List<DesiredCapabilities>>(){}.getType(), (Object)new CollectionOfDesiredCapabilitiesSerializer());
        builder.registerTypeAdapter(new TypeToken<List<DesiredCapabilities>>(){}.getType(), (Object)new CollectionOfDesiredCapabilitiesDeSerializer());
    }

    public static class CollectionOfDesiredCapabilitiesDeSerializer
    implements JsonDeserializer<List<DesiredCapabilities>> {
        public List<DesiredCapabilities> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement.isJsonArray()) {
                ArrayList<DesiredCapabilities> desiredCapabilities = new ArrayList<DesiredCapabilities>();
                JsonToBeanConverter converter = new JsonToBeanConverter();
                for (JsonElement arrayElement : jsonElement.getAsJsonArray()) {
                    desiredCapabilities.add(converter.convert(DesiredCapabilities.class, arrayElement));
                }
                return desiredCapabilities;
            }
            throw new JsonParseException("capabilities should be expressed as an array of objects.");
        }
    }

    public static class CollectionOfDesiredCapabilitiesSerializer
    implements JsonSerializer<List<DesiredCapabilities>> {
        public JsonElement serialize(List<DesiredCapabilities> desiredCapabilities, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonArray capabilities = new JsonArray();
            BeanToJsonConverter converter = new BeanToJsonConverter();
            for (DesiredCapabilities dc : desiredCapabilities) {
                capabilities.add(converter.convertObject(dc));
            }
            return capabilities;
        }
    }

    static final class DefaultDesiredCapabilitiesBuilder {
        DefaultDesiredCapabilitiesBuilder() {
        }

        static final List<DesiredCapabilities> getCapabilities() {
            DesiredCapabilities chrome = new DesiredCapabilities();
            chrome.setBrowserName("chrome");
            chrome.setCapability("maxInstances", 5);
            chrome.setCapability("seleniumProtocol", "WebDriver");
            DesiredCapabilities firefox = new DesiredCapabilities();
            firefox.setBrowserName("firefox");
            firefox.setCapability("maxInstances", 5);
            firefox.setCapability("seleniumProtocol", "WebDriver");
            DesiredCapabilities ie = new DesiredCapabilities();
            ie.setBrowserName("internet explorer");
            ie.setCapability("maxInstances", 1);
            ie.setCapability("seleniumProtocol", "WebDriver");
            return Lists.newArrayList((Object[])new DesiredCapabilities[]{chrome, firefox, ie});
        }
    }
}

