/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.animation.client;

import com.google.gwt.animation.client.AnimationScheduler;
import com.google.gwt.core.client.Duration;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.Timer;
import java.util.ArrayList;
import java.util.List;

class AnimationSchedulerImplTimer
extends AnimationScheduler {
    private static final int DEFAULT_FRAME_DELAY = 16;
    private static final int MIN_FRAME_DELAY = 5;
    private final List<AnimationHandleImpl> animationRequests = new ArrayList<AnimationHandleImpl>();
    private final Timer timer = new Timer(){

        @Override
        public void run() {
            AnimationSchedulerImplTimer.this.updateAnimations();
        }
    };

    AnimationSchedulerImplTimer() {
    }

    @Override
    public AnimationScheduler.AnimationHandle requestAnimationFrame(AnimationScheduler.AnimationCallback callback, Element element) {
        AnimationHandleImpl requestId = new AnimationHandleImpl(callback);
        this.animationRequests.add(requestId);
        if (this.animationRequests.size() == 1) {
            this.timer.schedule(16);
        }
        return requestId;
    }

    private void cancelAnimationFrame(AnimationScheduler.AnimationHandle requestId) {
        this.animationRequests.remove(requestId);
        if (this.animationRequests.size() == 0) {
            this.timer.cancel();
        }
    }

    private void updateAnimations() {
        AnimationHandleImpl[] curAnimations = new AnimationHandleImpl[this.animationRequests.size()];
        curAnimations = this.animationRequests.toArray(curAnimations);
        Duration duration = new Duration();
        for (AnimationHandleImpl requestId : curAnimations) {
            this.animationRequests.remove(requestId);
            requestId.getCallback().execute(duration.getStartMillis());
        }
        if (this.animationRequests.size() > 0) {
            this.timer.schedule(Math.max(5, 16 - duration.elapsedMillis()));
        }
    }

    private class AnimationHandleImpl
    extends AnimationScheduler.AnimationHandle {
        private final AnimationScheduler.AnimationCallback callback;

        public AnimationHandleImpl(AnimationScheduler.AnimationCallback callback) {
            this.callback = callback;
        }

        @Override
        public void cancel() {
            AnimationSchedulerImplTimer.this.cancelAnimationFrame(this);
        }

        public AnimationScheduler.AnimationCallback getCallback() {
            return this.callback;
        }
    }
}

