/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.Authentication;
import com.isomorphic.auth.AuthenticatorHandledResponse;
import com.isomorphic.auth.ConfigAuthenticator;
import com.isomorphic.auth.IAuthenticator;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.ISCHttpServletRequest;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.servlet.URIRegexFilter;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.RegexRule;
import com.isomorphic.xml.XML;
import java.io.IOException;
import java.io.StringReader;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationFilter
extends URIRegexFilter {
    public String loginPage = "/isomorphic/login/iscAuth/login.html";
    public String logoutPage = "/isomorphic/login/iscAuth/logout.html";
    public String maxLoginAttemptsExceededPage = "/isomorphic/login/iscAuth/maxLoginAttemptsExceeded.html";
    public String defaultLoginRedirect = "/";
    public String initialTargetParam = "initialTarget";
    public int maxTries = -1;
    public String realm;
    public String username;
    public String password;
    public String superuserRole;
    public List<String> roles;
    protected IAuthenticator authenticator = null;
    protected String authenticatorName = null;
    protected Logger log;
    protected boolean enabled = Authentication.enabled;
    protected String filterName;

    public void setLoginPage(String value) {
        this.loginPage = value;
    }

    public void setLogoutPage(String value) {
        this.logoutPage = value;
    }

    public void setMaxLoginAttemptsExceededPage(String value) {
        this.maxLoginAttemptsExceededPage = value;
    }

    public void setDefaultLoginRedirect(String value) {
        this.defaultLoginRedirect = value;
    }

    public void setInitialTargetParam(String value) {
        this.initialTargetParam = value;
    }

    public void setMaxTries(String value) {
        this.maxTries = Integer.valueOf(value);
    }

    public void setRealm(String value) {
        this.realm = value;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public void setSuperUserRole(String value) {
        this.superuserRole = value;
    }

    public void setRoles(String value) {
        if (value == null) {
            this.roles = null;
        }
        this.setRoles(DataTools.commaSeparatedStringToList(value));
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setAuthenticator(String value) throws Exception {
        this.authenticatorName = value;
        String authenticatorImpl = config.getString("authenticator." + this.authenticatorName);
        if (authenticatorImpl == null) {
            throw new Exception("Can't find config block for authenticator: " + this.authenticatorName + " - looking for authenticator." + this.authenticatorName + " block in server.properties");
        }
        try {
            Reflection.classForName(authenticatorImpl);
        }
        catch (ClassNotFoundException e) {
            throw new Exception("authenticator." + this.authenticatorName + " defines: " + authenticatorImpl + " as its implementor, but no such class exists in the runtime (class.forName())");
        }
        this.authenticator = (IAuthenticator)config.getClassInstance("authenticator." + this.authenticatorName);
        if (this.superuserRole == null) {
            this.superuserRole = config.getString("authenticator." + this.authenticatorName + ".superuserRole", null);
        }
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (this.username != null && this.password != null && ServletTools.servletOrFilterParametersToMap(filterConfig).get("authenticator") == null) {
            try {
                this.setAuthenticator("simpleConfig");
            }
            catch (Exception e) {
                this.log.error((Object)"can't auto-initialize simpleConfig authenticator - check your configuration", e);
                throw new ServletException(e.toString());
            }
        }
        if (this.authenticator instanceof ConfigAuthenticator) {
            if (this.username != null) {
                ((ConfigAuthenticator)this.authenticator).username = this.username;
            }
            if (this.password != null) {
                ((ConfigAuthenticator)this.authenticator).password = this.password;
            }
        }
        if (this.realm == null) {
            this.realm = filterConfig.getFilterName();
        }
        this.log = new Logger(this.getClass().getName(), filterConfig.getFilterName() + "(" + this.authenticatorName + ", realm: " + this.realm + ")");
        try {
            if (!this.enabled) {
                this.log.warn("AuthenticationFilter present in web.xml, but authentication globally disabled in config via authentication.enabled: false.  Not initializing, will allow all requests without any checks.");
                return;
            }
            if (this.defaultAction == null) {
                this.setDefaultAction("match");
            }
            if (this.rules == null) {
                this.log.info("No rules file defined, treating all intercepted resources as private");
            } else {
                try {
                    this.rules.add(0, new RegexRule("match:^/isomorphic/login/loginSuccessMarker.html", "authFilter default"));
                }
                catch (Exception e) {
                    this.log.error((Object)"Error initializing known good regex rule", e);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to initialize AuthenticationFilter.", e);
            throw new ServletException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void _doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        this.applyResponseHeaders(response);
        RequestContext context = null;
        boolean pushedLogContext = false;
        try {
            if (!this.enabled) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            request.setAttribute("_isc_authenticationEnabled", (Object)new Boolean(true));
            context = RequestContext.instance(this.servletContext, (ServletRequest)request, (ServletResponse)response);
            context.session = request.getSession(true);
            context.request.setAttribute(Authentication.authenticatorKey, this.authenticator);
            this.authenticator.setRealm(context, this.realm);
            String comparePath = ServletTools.getInitialRequestURI(request);
            String initialTarget = context.request.getQueryParameter(this.initialTargetParam);
            if (comparePath.equals(this.loginPage) && initialTarget != null) {
                this.authenticator.setInitialTarget(context, initialTarget);
            }
            if (initialTarget == null) {
                initialTarget = this.authenticator.getInitialTarget(context);
            }
            if (this.authenticator.containsCredentials(context)) {
                int loginCounter = this.authenticator.getLoginCounter(context);
                if (this.maxTries > 0 && loginCounter < this.maxTries || this.maxTries < 0) {
                    Principal user = this.authenticator.authenticate(context);
                    if (user != null) {
                        this.authenticator.setUser(context, user);
                        this.log.info("Authentication attempt succeeded");
                        this.authenticator.setLoginCounter(context, 0);
                        this.authenticator.setInitialTarget(context, null);
                        ServletTools.clearCookie("loginRedirect", context, this.loginPage, null);
                        if (comparePath.equals(this.loginPage)) {
                            if (initialTarget == null) {
                                initialTarget = ServletTools.adjustForContextPath(this.defaultLoginRedirect, request);
                            }
                            this.log.debug("Sending to initial target: " + initialTarget);
                            response.sendRedirect(initialTarget);
                            return;
                        }
                    } else {
                        if (this.maxTries > 0) {
                            this.authenticator.setLoginCounter(context, ++loginCounter);
                        }
                        this.log.info("Authentication failed, try # " + loginCounter);
                        if ("NONE".equals(this.loginPage)) {
                            response.sendError(401);
                            return;
                        }
                    }
                }
                if (this.maxTries > 0 && loginCounter >= this.maxTries) {
                    this.log.debug("Attempt to authenticate, but maxTries (" + this.maxTries + ") has been reached");
                    this.maxLoginsExceeded(context, comparePath);
                    return;
                }
            }
            if (comparePath.equals("/favicon.ico")) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (comparePath.equals(this.maxLoginAttemptsExceededPage)) {
                context.setNoCacheHeaders();
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (comparePath.equals(this.logoutPage)) {
                Principal user = this.authenticator.getUser(context);
                if (user != null) {
                    this.log.debug("Logging out (uid: " + user.getName() + ")");
                    this.authenticator.logout(context);
                }
                context.setNoCacheHeaders();
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (comparePath.equals(this.loginPage)) {
                String currentRedirect;
                String loginRedirect = this.authenticator.getInitialTarget(context);
                if (loginRedirect == null) {
                    loginRedirect = ServletTools.adjustForContextPath(this.defaultLoginRedirect, request);
                }
                if ((currentRedirect = ServletTools.getCookieValue("loginRedirect", (HttpServletRequest)context.request)) == null) {
                    ServletTools.setCookie(context, "loginRedirect", loginRedirect, this.loginPage);
                }
                if (this.authenticator.getInitialTargetJsCallback(context) != null) {
                    RPCManager.writeIframePrefix(response.getWriter(), null, context, this.authenticator.getInitialTargetJsCallback(context));
                }
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                if (this.authenticator.getInitialTargetJsCallback(context) == null) return;
                RPCManager.writeIframePostfix(response.getWriter());
                this.authenticator.setInitialTargetJsCallback(context, null);
                return;
            }
            RegexRule matchedRule = this.applyRules(comparePath);
            String action = matchedRule.getAction();
            List<String> requiresRoles = null;
            if (action.contains(";")) {
                List<String> actionDecode = DataTools.simpleSplit(action, ";");
                action = actionDecode.get(0);
                requiresRoles = DataTools.simpleSplit(actionDecode.get(1), ",");
            }
            if ("block".equals(action)) {
                context.response.sendError(404);
                this.log.warn("DENIED access to blocked resource: " + comparePath + " (matched by rule: " + matchedRule.toString() + ")");
                return;
            }
            Object userId = this.authenticator.getUserId(context);
            if (userId == null && !"match".equals(action)) {
                String referrer = request.getHeader("referer");
                String origin = request.getHeader("origin");
                if (referrer != null && origin != null) {
                    String referrerPath = referrer.substring(origin.length());
                    RegexRule referrerMatchedRule = this.applyRules(referrerPath);
                    String referrerAction = referrerMatchedRule.getAction();
                    if (referrerAction.contains(";")) {
                        List<String> actionDecode = DataTools.simpleSplit(referrerAction, ";");
                        referrerAction = actionDecode.get(0);
                    }
                    if ("match".equals(referrerAction)) {
                        this.log.info("Unauthenticated access from protected referrer - forcing auth on to present relogin (assuming i.e. IDACall case)");
                        action = "match";
                    }
                }
            }
            if ("match".equals(action)) {
                if (userId == null) {
                    Map reqProps;
                    String t;
                    context.setNoCacheHeaders();
                    if ("NONE".equals(this.loginPage) && !this.authenticator.containsCredentials(context)) {
                        response.sendError(401);
                        return;
                    }
                    int loginCounter = this.authenticator.getLoginCounter(context);
                    if (this.maxTries > 0 && loginCounter >= this.maxTries) {
                        this.maxLoginsExceeded(context, comparePath);
                        return;
                    }
                    this.authenticator.setInitialTarget(context, this.getInitialTarget(context));
                    if (context.request.isMultipart() && (t = (String)(reqProps = context.request.getStringParams()).get("_transaction")) != null) {
                        ValidationContext vc = new ValidationContext();
                        vc.setRestrictedXMLMode(true);
                        Object to = XML.toDSRecords(new StringReader(t), vc);
                        vc.freeResources();
                        this.authenticator.setInitialTargetJsCallback(context, (String)((Map)to).get("jscallback"));
                    }
                    response.sendRedirect(ServletTools.adjustForContextPath(this.loginPage, request));
                    String why = "not authenticated for realm: " + this.realm;
                    this.log.debug("REDIRECTING user to login page: " + this.loginPage + " for access to private resource: " + comparePath + " (" + why + ")");
                    return;
                }
                if (requiresRoles != null) {
                    boolean isAuthorized = false;
                    List<String> userRoles = this.roles != null ? this.roles : this.authenticator.getUserRoles(context);
                    if (this.superuserRole != null && userRoles.contains(this.superuserRole)) {
                        isAuthorized = true;
                    } else if (requiresRoles.contains("devenv") && config.getBoolean((Object)"devenv", false)) {
                        isAuthorized = true;
                    } else {
                        for (String requiresRole : requiresRoles) {
                            if (!userRoles.contains(requiresRole)) continue;
                            isAuthorized = true;
                            break;
                        }
                    }
                    if (!isAuthorized) {
                        this.log.warn("DENIED access to resource: " + comparePath + " (matched by rule: " + matchedRule.toString() + ") user does not have required role. Required role(s): " + requiresRoles + ", User role(s): " + userRoles);
                        return;
                    }
                }
                if (request.getAttribute("isc_auth_uid") == null) {
                    pushedLogContext = Logger.pushUniqueContext("user: " + userId.toString());
                    request.setAttribute("isc_auth_uid", userId);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ALLOWED authenticated access (uid: " + userId.toString() + ") to private resource: " + comparePath);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("ALLOWED access to public resource: " + comparePath + " (matched by rule: " + matchedRule.toString() + ")");
            }
            ISCHttpServletRequest wrappedRequest = new ISCHttpServletRequest(request);
            wrappedRequest.setPrincipalContext(context, this.authenticator);
            this.authenticator.track(context);
            chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)response);
            return;
        }
        catch (ServletException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (AuthenticatorHandledResponse ahr) {
            return;
        }
        catch (Exception e) {
            this.log.error("Caught exception in doFilter() - for URI: " + request.getRequestURI() + "\n" + DataTools.getStackTrace(e));
            throw new ServletException("Auth failure - see server logs for details");
        }
        finally {
            if (pushedLogContext) {
                Logger.popContext();
            }
            if (context != null) {
                try {
                    context.completeResponse();
                }
                catch (Exception exception) {}
                try {
                    response.flushBuffer();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getInitialTarget(RequestContext context) {
        String queryString = context.request.getQueryString();
        String initialTarget = context.requestPath;
        if (queryString != null && queryString.length() > 0) {
            if (!queryString.startsWith("?")) {
                initialTarget = initialTarget + "?";
            }
            initialTarget = initialTarget + queryString;
        }
        return initialTarget;
    }

    private void maxLoginsExceeded(RequestContext context, String comparePath) throws Exception {
        context.request.setAttribute("isc.TOO_MANY_LOGIN_ATTEMPTS", new Integer(this.maxTries));
        String maxTriesURL = this.maxLoginAttemptsExceededPage;
        if (maxTriesURL == null) {
            this.log.warn("maxTries is set, but maxLoginAttemptsExceededPage is not defined, defaulting to loginPage");
            maxTriesURL = this.loginPage;
        }
        this.log.debug("REDIRECTING user to: " + maxTriesURL + " for access to private resource: " + comparePath + " (user exceeded maximum login attempts limit of " + this.maxTries + ")");
        context.response.sendRedirect(ServletTools.adjustForContextPath(maxTriesURL, (HttpServletRequest)context.request));
    }
}

