/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Base;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IExecutable;
import com.isomorphic.util.ISCSystem;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class AutoConfigurableExecutable
extends Base
implements IExecutable {
    protected static Logger log;
    public String command = null;
    public Map<String, String> env = null;
    public String[] _env = null;
    public Map<String, String> addEnv = null;
    public int timeout = 0;
    public String dir = null;
    protected File _dir = null;

    public AutoConfigurableExecutable() {
        log = new Logger(this.getClass().getName());
    }

    public static void main(String[] args) {
        DefaultParser parser = new DefaultParser();
        String cmdLineSyntax = "configExec [options] <configName>";
        Options options = new Options();
        options.addOption("h", "help", false, "Show usage message and exit");
        OptionBuilder.withLongOpt((String)"timeout");
        OptionBuilder.withDescription((String)"Timeout, in millseconds (default is wait forever)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"timeout");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"dir");
        OptionBuilder.withDescription((String)"Timeout, in millseconds (default is wait forever)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create());
        try {
            String stderr;
            List remainingArgs;
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("h")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(cmdLineSyntax, "", options, "\nUtility to exec() a command provisioned in .properties config");
                System.exit(2);
            }
            if ((remainingArgs = line.getArgList()).size() == 0) {
                throw new Exception("Must specify a configName");
            }
            String configName = (String)remainingArgs.get(0);
            String className = config.getString(configName);
            if (className == null) {
                throw new Exception("Unable to find specified configName: " + configName);
            }
            AutoConfigurableExecutable ace = (AutoConfigurableExecutable)config.getClassInstance(configName);
            if (line.hasOption("timeout")) {
                String s = line.getOptionValue("timeout");
                ace.setTimeout(Integer.parseInt(s));
            }
            if (line.hasOption("dir")) {
                ace.setDir(line.getOptionValue("dir"));
            }
            ISCSystem iscSystem = ace.execute().waitFor();
            int exitValue = iscSystem.exitValue();
            String stdout = iscSystem.getStdout();
            if (stdout != null) {
                System.out.print(stdout);
            }
            if ((stderr = iscSystem.getStderr()) != null) {
                System.err.print(stderr);
            }
            System.exit(exitValue);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public void clearEnv() {
        this.addEnv = null;
        this.env = null;
        this._env = null;
    }

    public void setEnv(Map env) {
        this.clearEnv();
        this.env = env;
    }

    public void setEnv(String[] env) {
        this.clearEnv();
        this._env = env;
    }

    public void setAddEnv(Map addEnv) {
        this.addEnv(addEnv);
    }

    public void addEnv(Map addEnv) {
        if (this.addEnv == null) {
            this.addEnv = addEnv;
        } else {
            this.addEnv.putAll(addEnv);
        }
    }

    @Override
    public String[] getEnv() {
        if (this._env != null) {
            if (this.addEnv != null) {
                return DataTools.arrayUnion(AutoConfigurableExecutable.convertEnv(this.env), AutoConfigurableExecutable.convertEnv(this.addEnv));
            }
            return this._env;
        }
        if (this.env != null) {
            if (this.addEnv != null) {
                return AutoConfigurableExecutable.convertEnv(DataTools.mapMerge(this.env, this.addEnv));
            }
            return AutoConfigurableExecutable.convertEnv(this.env);
        }
        Map<String, String> env = System.getenv();
        if (this.addEnv != null) {
            return AutoConfigurableExecutable.convertEnv(DataTools.mapMerge(env, this.addEnv));
        }
        return AutoConfigurableExecutable.convertEnv(env);
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setDir(String dir) {
        this.dir = dir;
        this._dir = null;
    }

    public void setDir(File dir) {
        this._dir = dir;
        this.dir = null;
    }

    @Override
    public File getDir() {
        if (this._dir != null) {
            return this._dir;
        }
        if (this.dir != null) {
            return new File(this.dir);
        }
        return null;
    }

    public static Map<String, String> convertEnv(String[] envp) {
        if (envp == null) {
            return null;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        for (int i = 0; i < envp.length; ++i) {
            String s = envp[i];
            int equalsIndex = s.indexOf("=");
            if (equalsIndex == -1) continue;
            String key = s.substring(0, equalsIndex);
            String value = s.substring(equalsIndex + 1);
            env.put(key, value);
        }
        return env;
    }

    public static String[] convertEnv(Map env) {
        if (env == null) {
            return null;
        }
        String[] envp = new String[env.size()];
        int ii = 0;
        for (String key : env.keySet()) {
            Object value = env.get(key);
            if (value == null) continue;
            envp[ii++] = key + "=" + value.toString();
        }
        return envp;
    }

    public ISCSystem execute() throws Exception {
        return ISCSystem.execute(this);
    }
}

