/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.pool;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.PoolableDataSourceFactory;
import com.isomorphic.log.Logger;
import com.isomorphic.pool.IPoolableObjectFactory;
import com.isomorphic.pool.ISCKeyedObjectPool;
import com.isomorphic.pool.ISCKeyedPoolableObjectFactory;
import com.isomorphic.pool.ISCObjectPool;
import com.isomorphic.pool.ISCPoolableObjectFactory;
import com.isomorphic.util.DataTools;
import java.util.HashMap;
import java.util.Map;

public class PoolManager
extends Base {
    private Logger log = new Logger(PoolManager.class.getName());
    protected String name;
    protected String symbolicName;
    protected IPoolableObjectFactory factory;
    protected Object source;
    protected Map sources = new HashMap();

    public IPoolableObjectFactory getFactory() {
        return this.factory;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public PoolManager(String name, IPoolableObjectFactory factory) {
        this.name = name;
        this.factory = factory;
        this.symbolicName = this.getClass().getName();
    }

    public Object borrowObject(Object key, DSRequest dsRequest) throws Exception {
        return this.borrowObject(key, dsRequest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object borrowObject(Object key, DSRequest dsRequest, boolean isSchemaless) throws Exception {
        Object objectSource = this.getObjectSource(key);
        if (objectSource instanceof ISCKeyedObjectPool) {
            ISCKeyedPoolableObjectFactory factory = ((ISCKeyedObjectPool)((Object)objectSource)).getObjectFactory();
            if (factory instanceof PoolableDataSourceFactory) {
                ((PoolableDataSourceFactory)factory).setDSRequest(dsRequest);
                ((PoolableDataSourceFactory)factory).setIsSchemaless(isSchemaless);
            }
            Object object = null;
            try {
                object = ((ISCKeyedObjectPool)((Object)objectSource)).borrowObject(key);
            }
            finally {
                if (factory instanceof PoolableDataSourceFactory) {
                    ((PoolableDataSourceFactory)factory).removeDSRequest();
                    ((PoolableDataSourceFactory)factory).removeIsSchemaless();
                }
            }
            return object;
        }
        if (objectSource instanceof ISCObjectPool) {
            return ((ISCObjectPool)((Object)objectSource)).borrowObject();
        }
        if (objectSource instanceof ISCPoolableObjectFactory) {
            return ((ISCPoolableObjectFactory)objectSource).makeObject();
        }
        if (objectSource instanceof ISCKeyedPoolableObjectFactory) {
            ISCKeyedPoolableObjectFactory source = (ISCKeyedPoolableObjectFactory)objectSource;
            if (source instanceof PoolableDataSourceFactory) {
                ((PoolableDataSourceFactory)source).setDSRequest(dsRequest);
                ((PoolableDataSourceFactory)source).setIsSchemaless(isSchemaless);
            }
            try {
                Object object = source.makeObject(key);
                return object;
            }
            finally {
                if (this.factory instanceof PoolableDataSourceFactory) {
                    ((PoolableDataSourceFactory)this.factory).removeDSRequest();
                    ((PoolableDataSourceFactory)this.factory).removeIsSchemaless();
                }
            }
        }
        throw new Exception("Invalid objectSource type: " + objectSource.getClass().getName());
    }

    public Object borrowUnpooledObject(Object key) throws Exception {
        return this.borrowUnpooledObject(key, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object borrowUnpooledObject(Object key, DSRequest dsRequest, boolean isSchemaless) throws Exception {
        Object objectSource = this.getObjectSource(key);
        if (objectSource instanceof ISCKeyedObjectPool) {
            ISCKeyedPoolableObjectFactory factory = ((ISCKeyedObjectPool)((Object)objectSource)).getObjectFactory();
            if (factory instanceof PoolableDataSourceFactory) {
                ((PoolableDataSourceFactory)factory).setDSRequest(dsRequest);
                ((PoolableDataSourceFactory)factory).setIsSchemaless(isSchemaless);
            }
            Object object = null;
            try {
                object = ((ISCKeyedObjectPool)((Object)objectSource)).getObjectFactory().makeUnpooledObject(key);
            }
            finally {
                if (factory instanceof PoolableDataSourceFactory) {
                    ((PoolableDataSourceFactory)factory).removeDSRequest();
                    ((PoolableDataSourceFactory)factory).removeIsSchemaless();
                }
            }
            return object;
        }
        if (objectSource instanceof ISCObjectPool) {
            return ((ISCObjectPool)((Object)objectSource)).getObjectFactory().makeUnpooledObject();
        }
        if (objectSource instanceof ISCPoolableObjectFactory) {
            return ((ISCPoolableObjectFactory)objectSource).makeUnpooledObject();
        }
        if (objectSource instanceof ISCKeyedPoolableObjectFactory) {
            ISCKeyedPoolableObjectFactory source = (ISCKeyedPoolableObjectFactory)objectSource;
            if (source instanceof PoolableDataSourceFactory) {
                ((PoolableDataSourceFactory)source).setDSRequest(dsRequest);
                ((PoolableDataSourceFactory)source).setIsSchemaless(isSchemaless);
            }
            try {
                Object object = ((ISCKeyedPoolableObjectFactory)objectSource).makeUnpooledObject(key);
                return object;
            }
            finally {
                if (this.factory instanceof PoolableDataSourceFactory) {
                    ((PoolableDataSourceFactory)this.factory).removeDSRequest();
                    ((PoolableDataSourceFactory)this.factory).removeIsSchemaless();
                }
            }
        }
        throw new Exception("Invalid objectSource type: " + objectSource.getClass().getName());
    }

    public Object borrowNewObject(Object key) throws Exception {
        Object objectSource = this.getObjectSource(key);
        if (objectSource instanceof ISCKeyedObjectPool) {
            return ((ISCKeyedObjectPool)((Object)objectSource)).getObjectFactory().makeObject(key);
        }
        if (objectSource instanceof ISCObjectPool) {
            return ((ISCObjectPool)((Object)objectSource)).getObjectFactory().makeObject();
        }
        if (objectSource instanceof ISCPoolableObjectFactory) {
            return ((ISCPoolableObjectFactory)objectSource).makeObject();
        }
        if (objectSource instanceof ISCKeyedPoolableObjectFactory) {
            return ((ISCKeyedPoolableObjectFactory)objectSource).makeObject(key);
        }
        throw new Exception("Invalid objectSource type: " + objectSource.getClass().getName());
    }

    public void returnObject(Object key, Object obj) {
        try {
            Object objectSource = this.getObjectSource(key);
            if (objectSource instanceof ISCObjectPool) {
                ((ISCObjectPool)((Object)objectSource)).returnObject(obj);
            } else if (objectSource instanceof ISCKeyedObjectPool) {
                if (!(obj instanceof DataSource) || ((DataSource)obj).getID().startsWith("world")) {
                    // empty if block
                }
                ((ISCKeyedObjectPool)((Object)objectSource)).returnObject(key, obj);
            } else if (objectSource instanceof ISCPoolableObjectFactory) {
                ((ISCPoolableObjectFactory)objectSource).destroyObject(obj);
            } else if (objectSource instanceof ISCKeyedPoolableObjectFactory) {
                ((ISCKeyedPoolableObjectFactory)objectSource).destroyObject(key, obj);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while freeing object - ignored.", e);
        }
    }

    public void invalidateObject(Object key, Object obj) {
        try {
            Object objectSource = this.getObjectSource(key);
            if (objectSource instanceof ISCObjectPool) {
                ((ISCObjectPool)((Object)objectSource)).invalidateObject(obj);
            } else if (objectSource instanceof ISCKeyedObjectPool) {
                ((ISCKeyedObjectPool)((Object)objectSource)).invalidateObject(key, obj);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while invalidating object - ignored.", e);
        }
    }

    public void clearPool(Object key) throws Exception {
        Object objectSource = this.getObjectSource(key);
        if (objectSource instanceof ISCObjectPool) {
            ((ISCObjectPool)((Object)objectSource)).clear();
        } else if (objectSource instanceof ISCKeyedObjectPool) {
            ((ISCKeyedObjectPool)((Object)objectSource)).clear(key);
        }
    }

    public void close() throws Exception {
        for (Object key : this.sources.keySet()) {
            this.closePool(key);
        }
    }

    public void closePool(Object key) throws Exception {
        Object objectSource = this.getObjectSource(key);
        if (objectSource instanceof ISCObjectPool) {
            ((ISCObjectPool)((Object)objectSource)).close();
        } else if (objectSource instanceof ISCKeyedObjectPool) {
            ((ISCKeyedObjectPool)((Object)objectSource)).close();
        }
    }

    public synchronized Object getObjectSource(Object key) throws Exception {
        if (this.factory instanceof ISCKeyedPoolableObjectFactory) {
            if (this.source == null) {
                this.source = this.makeSource(key);
            }
            return this.source;
        }
        Object source = this.sources.get(key);
        if (source == null) {
            source = this.makeSource(key);
            this.sources.put(key, source);
        }
        return source;
    }

    public Object makeSource(Object key) throws Exception {
        Config globalPoolConfig = config.getSubtree("pooling.default");
        Config objectConfig = config.getSubtree(this.name + ".pool");
        Config thisPoolConfig = config.getSubtree(this.name + "." + key.toString() + ".pool");
        Config mergedConfig = new Config();
        DataTools.mapMerge((Map)((Object)globalPoolConfig), (Map)((Object)mergedConfig));
        DataTools.mapMerge((Map)((Object)objectConfig), (Map)((Object)mergedConfig));
        DataTools.mapMerge((Map)((Object)thisPoolConfig), (Map)((Object)mergedConfig));
        IPoolableObjectFactory factory = this.factory.newInstance(key);
        this.source = factory;
        ISCPoolableObjectFactory iscFactory = null;
        if (factory instanceof ISCPoolableObjectFactory) {
            iscFactory = (ISCPoolableObjectFactory)factory;
        }
        if (iscFactory != null && Boolean.FALSE.equals(iscFactory.poolDisabled) || mergedConfig.getBoolean((Object)"enabled", false) && (iscFactory == null || !Boolean.TRUE.equals(iscFactory.poolDisabled))) {
            mergedConfig.remove("enabled");
            Object pool = factory instanceof ISCKeyedPoolableObjectFactory ? new ISCKeyedObjectPool((ISCKeyedPoolableObjectFactory)factory, (Map)((Object)mergedConfig)) : new ISCObjectPool((ISCPoolableObjectFactory)factory, (Map)((Object)mergedConfig));
            factory.setPool(pool);
            this.source = pool;
            this.log.info("SmartClient pooling started for '" + key.toString() + "' objects");
        } else {
            this.log.info("SmartClient pooling disabled for '" + key.toString() + "' objects");
        }
        if (this.source == null) {
            throw new Exception("Unable to bind objectSource for key: " + key.toString());
        }
        return this.source;
    }
}

