/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.naming.JNDI;
import com.isomorphic.rpc.Scripting;
import com.isomorphic.util.DataTools;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.naming.NoInitialContextException;

public class ISCInit {
    private static Config config;
    private static boolean initialized;
    public static boolean webRootSet;
    private static String webRoot;
    public static final String AUTODETECT = "__AUTODETECT__";
    protected static boolean reentrant;
    static ExecutorService serviceExecutor;
    private static Logger log;

    public static void go() {
        ISCInit.go("[No class name provided]");
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static synchronized void go(Class callingClass) {
        ISCInit.go(callingClass.getName());
    }

    public static void main(String[] args) {
        ISCInit.go("CommandLine");
        if (serviceExecutor != null) {
            while (true) {
                try {
                    while (true) {
                        serviceExecutor.shutdown();
                        serviceExecutor.awaitTermination(1L, TimeUnit.DAYS);
                    }
                }
                catch (Exception e) {
                    ISCInit.logInfo("Interrupted - exiting");
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void go(String callingClassName) {
        if (reentrant) {
            return;
        }
        reentrant = true;
        try {
            if (callingClassName != null) {
                ISCInit.logDebug("Isomorphic SmartClient/SmartGWT Framework initialization called from " + callingClassName);
            }
            if (initialized && webRootSet) {
                if (callingClassName != null) {
                    ISCInit.logDebug("Isomorphic SmartClient/SmartGWT Framework is already initialized");
                }
                return;
            }
            boolean initBlockExecuted = false;
            if (!initialized) {
                ISCInit.logInfo("Isomorphic SmartClient/SmartGWT Framework - Initializing");
                config = Config.getGlobal();
                if (config == null) {
                    config = Config.initGlobalConfig();
                }
                Logger.initialize();
                initialized = true;
                initBlockExecuted = true;
                ISCInit.bindJDBCViaJNDI();
            }
            if (!webRootSet) {
                if (webRoot == null) {
                    webRoot = config.getPath("webRoot");
                }
                if (!AUTODETECT.equals(webRoot) && (ISCInit.verifyWebRoot(webRoot) || ISCFile.isContainerIOPath(webRoot))) {
                    ISCInit.logInfo("Using Configured webRoot: " + webRoot);
                    webRootSet = true;
                } else {
                    if (!AUTODETECT.equals(webRoot)) {
                        throw new Exception("Configured webRoot path is invalid please check your server.properties setting.  Current value is: " + webRoot);
                    }
                    if (ISCFile.servletContext == null) {
                        ISCInit.logInfo("No ServletContext available yet - using container IO for now");
                        config.put("webRoot", "__USE_CONTAINER__");
                    } else {
                        String realPath = ISCFile.servletContext.getRealPath("/");
                        String autoWebRoot = ISCInit.fixRealPath(realPath);
                        if (autoWebRoot == null) {
                            ISCInit.logInfo("Container refusing to provide getRealPath() - assuming WAR context and using container IO");
                            config.put("webRoot", "__USE_CONTAINER__");
                        } else if (ISCInit.verifyWebRoot(autoWebRoot)) {
                            config.put("webRoot", autoWebRoot);
                            ISCInit.logInfo("Auto-detected webRoot - using: " + autoWebRoot);
                        } else {
                            config.put("webRoot", "__USE_CONTAINER__");
                            ISCInit.logInfo("WebRoot auto-detection failed - using container IO");
                        }
                        webRootSet = true;
                    }
                }
            }
            if (initBlockExecuted) {
                String initScript = config.getString("init.script");
                if (initScript != null) {
                    String initScriptLanguage = config.getString("init.script.language");
                    if (initScriptLanguage == null) {
                        ISCInit.logWarn("init.script is defined, but init.script.language is not. Please define it (in server.properties) if you want your init script to run");
                    } else {
                        DataTypeMap<String, Object> params = new DataTypeMap<String, Object>();
                        HashMap<String, Logger> bindings = new HashMap<String, Logger>();
                        params.put("bindings", bindings);
                        bindings.put("log", log);
                        params.put("engineName", initScriptLanguage);
                        ISCFile scriptFile = ISCFile.newInstance(initScript);
                        if (scriptFile.exists()) {
                            String script = scriptFile.getAsString();
                            params.put("script", script);
                            ISCInit.logInfo("Executing init script: " + initScript);
                            Scripting.evalServerScript(params);
                        } else {
                            ISCInit.logWarn("init.script explicitly defined in config, but is missing on disk: " + initScript);
                        }
                    }
                }
                String version = config.getString("iscVersion");
                String packageDate = config.getString("iscPackageDate");
                ISCInit.logInfo("Isomorphic SmartClient/SmartGWT Framework (" + version + " " + packageDate + ") - Initialization Complete");
            }
            if (config.getBoolean((Object)"datasource.stream.routing.enabled", false)) {
                try {
                    if (InterfaceProvider.exists("StreamDataSource")) {
                        ISCInit.logInfo("Initilizing DataSource Stream Routing");
                        Reflection.invokeStaticMethod("com.isomorphic.messaging.StreamDataSource", "initStreamRouting");
                    } else {
                        ISCInit.logError("Unable to initialize DataSource Stream Routing: Realtime Messaging module not present");
                    }
                }
                catch (Exception e) {
                    ISCInit.logError("Error during DataSource Stream Routing init", e);
                }
            }
            ISCInit.initServiceThreads();
        }
        catch (Throwable e) {
            System.err.println("Isomorphic Init: Exception in Init.go()");
            e.printStackTrace(System.err);
        }
        finally {
            reentrant = false;
        }
    }

    public static void initServiceThreads() throws Exception {
        Object serviceInstance;
        List serviceNames = config.getList("services.start");
        if (serviceNames == null || serviceNames.size() == 0) {
            return;
        }
        HashMap<String, Runnable> serviceInstances = new HashMap<String, Runnable>();
        for (String serviceName : serviceNames) {
            try {
                serviceInstance = config.getClassInstance("service." + serviceName);
                if (serviceInstance == null) {
                    throw new Exception("Resulting instance is null");
                }
                if (!(serviceInstance instanceof Runnable)) {
                    throw new Exception("Does not implement the Runnable interface class is type: " + serviceInstance.getClass().getName());
                }
                serviceInstances.put(serviceName, (Runnable)serviceInstance);
            }
            catch (Exception e) {
                ISCInit.logError("Unable to init service " + serviceName + " - skipping", e);
            }
        }
        serviceExecutor = Executors.newFixedThreadPool(serviceInstances.size());
        for (String serviceName : serviceInstances.keySet()) {
            serviceInstance = (Runnable)serviceInstances.get(serviceName);
            ISCInit.logInfo("Starting Service Thread: " + serviceName);
            serviceExecutor.execute((Runnable)serviceInstance);
        }
    }

    private static String fixRealPath(String path) {
        if (path == null) {
            return null;
        }
        try {
            path = new File(path).getCanonicalPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    private static boolean verifyWebRoot(String webRoot) {
        ISCInit.logDebug("Verifying webroot: " + webRoot);
        webRoot = ISCFile.canonicalizePath(webRoot);
        File webRootDir = new File(webRoot);
        if (!webRootDir.exists() || !webRootDir.isDirectory()) {
            return false;
        }
        String markerFileName = ISCFile.canonicalizePath(webRoot + "/" + config.getPath("isomorphicPathRootRelative"));
        File markerFile = new File(markerFileName);
        try {
            markerFile = markerFile.getAbsoluteFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!markerFile.exists()) {
            ISCInit.logError("Can't find marker file for webRoot: " + markerFileName + " for configured/autodetected webRoot - if you moved the 'isomorphic' directory, please set isomorphicPathRootRelative in server.properties to the new location and restart the servlet engine.");
            return false;
        }
        return true;
    }

    public static boolean canRestartContainer() {
        String containerClassName = System.getProperty("com.isomorphic.embedded_tomcat.className");
        return containerClassName != null;
    }

    public static void restartContainer() throws Exception {
        if (!ISCInit.canRestartContainer()) {
            throw new Exception("Unable to respond to container restart command - not running in embedded Tomcat mode - ignoring.");
        }
        ISCInit.logInfo("Container restart requested");
        System.exit(5);
    }

    public static void shutdownContainer() {
        ISCInit.logInfo("Container shutdown requested");
        System.exit(0);
    }

    private static void bindJDBCViaJNDI() {
        String defaultPublishPath;
        String initialContextFactory;
        if (!config.getBoolean((Object)"sql.jndi.publish", false)) {
            ISCInit.logInfo("SQL JNDI publishing disabled");
            return;
        }
        String className = "com.isomorphic.sql.DBDataSource";
        Class<?> c = null;
        try {
            c = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            try {
                c = Class.forName(className);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (c == null) {
            ISCInit.logInfo("SQL JNDI publishing is enabled, but isomorphic_sql.jar is not present - proceeding without publishing isomorphic SQL databases to JNDI");
            return;
        }
        if (config.getBoolean((Object)"devenv", false) && (initialContextFactory = System.getProperty("java.naming.factory.initial")) == null) {
            try {
                System.setProperty("java.naming.factory.initial", "com.isomorphic.naming.MockInitialContextFactory");
            }
            catch (Exception e) {
                ISCInit.logWarn("Error binding MockInitialContext", e);
            }
        }
        if ("".equals(defaultPublishPath = config.getString("sql.jndi.publish.path"))) {
            defaultPublishPath = null;
        }
        ArrayList<String> dbNames = new ArrayList<String>();
        Config dbConfig = config.getSubtree("sql");
        for (String key : dbConfig.keySet()) {
            String dbName;
            int index = key.indexOf(".database.type");
            if (index == -1 || dbNames.contains(dbName = key.substring(0, index))) continue;
            dbNames.add(dbName);
        }
        if (dbNames.size() > 1) {
            dbNames.add("defaultDatabase");
            try {
                for (String dbName : dbNames) {
                    String publishPath = config.getString("sql." + dbName + ".jndi.publish.path", null);
                    if (publishPath == null && (publishPath = defaultPublishPath) != null) {
                        publishPath = publishPath + "/" + dbName;
                    }
                    Context ctx = null;
                    if (publishPath == null) continue;
                    try {
                        ctx = JNDI.createSubcontextPath(publishPath, true);
                    }
                    catch (NoInitialContextException nic) {
                        ISCInit.logInfo("No default JNDI initial context factory present. Attempting to use MockInitialContextFactory.");
                        System.setProperty("java.naming.factory.initial", "com.isomorphic.naming.MockInitialContextFactory");
                        ctx = JNDI.createSubcontextPath(publishPath, true);
                    }
                    Object iscDS = c.newInstance();
                    String dbNameForLookup = dbName;
                    if ("defaultDatabase".equals(dbName)) {
                        dbNameForLookup = "config:sql.defaultDatabase";
                    }
                    DataTools.setProperties((Map)((Object)DataTools.buildMap("dbName", dbNameForLookup)), iscDS);
                    ctx.bind(publishPath, iscDS);
                    ISCInit.logInfo("Bound DB " + dbName + " via JNDI at: " + publishPath);
                }
            }
            catch (Throwable t) {
                log.warn((Object)("Failed to populate JNDI context with JDBC connections configured in server.properties -  impacted databases: " + ((Object)dbNames).toString()), t);
            }
        }
    }

    protected static void logDebug(String message) {
        ISCInit.logDebug(message, null);
    }

    protected static void logDebug(String message, Throwable t) {
        if (log != null) {
            if (t != null) {
                log.debug((Object)message, t);
            }
            log.debug(message);
        } else {
            System.out.println("DEBUG: " + message);
            if (t != null) {
                ISCInit.getRealTargetException(t).printStackTrace();
            }
        }
    }

    protected static void logInfo(String message) {
        ISCInit.logInfo(message, null);
    }

    protected static void logInfo(String message, Throwable t) {
        if (log != null) {
            if (t != null) {
                log.info((Object)message, t);
            }
            log.info(message);
        } else {
            System.out.println("INFO: " + message);
            if (t != null) {
                ISCInit.getRealTargetException(t).printStackTrace();
            }
        }
    }

    protected static void logWarn(String message) {
        ISCInit.logWarn(message, null);
    }

    protected static void logWarn(String message, Throwable t) {
        if (log != null) {
            if (t != null) {
                log.warn((Object)message, t);
            }
            log.warn(message);
        } else {
            System.out.println("WARN: " + message);
            if (t != null) {
                ISCInit.getRealTargetException(t).printStackTrace();
            }
        }
    }

    protected static void logError(String message) {
        ISCInit.logError(message, null);
    }

    protected static void logError(String message, Throwable t) {
        if (log != null) {
            if (t != null) {
                log.error((Object)message, t);
            }
            log.error(message);
        } else {
            System.out.println("ERROR: " + message);
            if (t != null) {
                ISCInit.getRealTargetException(t).printStackTrace();
            }
        }
    }

    public static Throwable getRealTargetException(Throwable ite) {
        if (ite instanceof InvocationTargetException) {
            return ISCInit.getRealTargetException(((InvocationTargetException)ite).getTargetException());
        }
        return ite;
    }

    static {
        initialized = false;
        webRootSet = false;
        reentrant = false;
        log = new Logger(ISCInit.class.getName());
    }
}

