/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class FirebirdDriver
extends SQLDriver {
    private static Logger log = new Logger(FirebirdDriver.class.getName());

    public FirebirdDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
    }

    @Override
    public boolean supportsNativeReplace() {
        return false;
    }

    @Override
    public boolean supportsSQLLimit() {
        return true;
    }

    @Override
    public boolean limitRequiresSQLOrderClause() {
        return false;
    }

    @Override
    public String limitQuery(String query, long startRow, long batchSize, List outputColumns) {
        String token = "SELECT ";
        int insertPoint = query.indexOf(token);
        if (insertPoint == -1) {
            return query;
        }
        return query.substring(0, insertPoint += token.length()) + "FIRST " + batchSize + " SKIP " + startRow + " " + query.substring(insertPoint);
    }

    @Override
    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        if (this.dbConnection == null && req == null) {
            throw new Exception("No existing db connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        for (String sequenceName : sequencesNotPresent) {
            String sequence = this.getCurrentSequenceValue(sequenceName, ds);
            if (sequence == null) continue;
            Object obj = FirebirdDriver.getScalarResult("SELECT " + sequence + " FROM RDB$DATABASE", this.dbConnection, this.dbName, this, req);
            BigDecimal value = new BigDecimal(obj.toString());
            primaryKeys.put(sequenceName, value.toString());
        }
        return primaryKeys;
    }

    public String getCurrentSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        String sequenceName = this.getSequenceName(columnName);
        if (sequenceName == null) {
            return null;
        }
        return "GEN_ID(" + sequenceName + ", 0)";
    }

    @Override
    public String getNextSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        String sequenceName = this.getSequenceName(columnName, dataSource);
        if (sequenceName == null) {
            return null;
        }
        return "NEXT VALUE FOR " + sequenceName;
    }

    @Override
    public String formatValue(Object value) {
        return value.toString();
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    @Override
    public String escapeValueForFilter(Object value, String filterStyle) {
        if (value == null) {
            return null;
        }
        String rtn = "'";
        if (!"startsWith".equals(filterStyle)) {
            rtn = rtn + "%";
        }
        return rtn + this.escapeValueUnquoted(value, true) + "%'";
    }

    @Override
    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = this.matcher.reset(value.toString()).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
        if (escapeForFilter) {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(PERCENT_PATTERN).replaceAll(PERCENT_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(UNDERSCORE_PATTERN).replaceAll(UNDERSCORE_ESCAPE);
        }
        return escaped;
    }

    @Override
    public String escapeClause() {
        return " {ESCAPE '\\'}";
    }

    @Override
    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        if (this.sqlConfig.getBoolean((Object)"useCaseForSortBy", false)) {
            return column;
        }
        String expr = "CASE " + column;
        for (String actualValue : valueMap.keySet()) {
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(actualValue), request);
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN '" + actualValue + "' THEN " + displayValue;
        }
        expr = expr + " ELSE " + column + " END";
        return expr;
    }

    @Override
    public int caseInsensitiveStrategy() {
        return 2;
    }

    @Override
    public Timestamp getUTCTimestamp(ResultSet rs, int index) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(index);
        long millis = timestamp.getTime();
        TimeZone tz = TimeZone.getDefault();
        int offset = tz.getOffset(millis);
        return new Timestamp(millis + (long)offset);
    }

    @Override
    public InputStream handleInputStream(InputStream in) throws Exception {
        return super.handleInputStream(in);
    }

    @Override
    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName == null ? null : objectName.toUpperCase();
    }

    @Override
    public String getDummyQuery() {
        return "SELECT 1 FROM RDB$DATABASE";
    }
}

