/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.deferred;

import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLBinaryAttachmentHandler;
import org.eclipse.persistence.internal.oxm.XMLInlineBinaryHandler;
import org.eclipse.persistence.internal.oxm.record.deferred.DeferredContentHandler;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.xml.sax.SAXException;

public class BinaryMappingContentHandler
extends DeferredContentHandler {
    private DatabaseMapping mapping;
    private NodeValue nodeValue;
    private Converter converter;
    private boolean isCollection;
    private UnmarshalRecord workingUnmarshalRecord;
    private boolean finished;

    public BinaryMappingContentHandler(UnmarshalRecord parentRecord, NodeValue nodeValue, XMLBinaryDataMapping mapping) {
        super(parentRecord);
        this.mapping = mapping;
        this.converter = mapping.getConverter();
        this.nodeValue = nodeValue;
        this.isCollection = false;
        this.finished = false;
    }

    public BinaryMappingContentHandler(UnmarshalRecord parentRecord, NodeValue nodeValue, XMLBinaryDataCollectionMapping mapping) {
        super(parentRecord);
        this.mapping = mapping;
        this.converter = mapping.getValueConverter();
        this.nodeValue = nodeValue;
        this.isCollection = true;
    }

    @Override
    public void processComplexElement() throws SAXException {
        this.getEvents().remove(0);
        this.workingUnmarshalRecord = new XMLBinaryAttachmentHandler(this.getParent(), this.nodeValue, this.mapping, this.converter, this.isCollection);
        this.executeEvents(this.workingUnmarshalRecord);
    }

    @Override
    public void processSimpleElement() throws SAXException {
        this.getEvents().remove(0);
        this.workingUnmarshalRecord = new XMLInlineBinaryHandler(this.getParent(), this.nodeValue, this.mapping, this.converter, this.isCollection);
        this.executeEvents(this.workingUnmarshalRecord);
    }

    @Override
    public void processEmptyElement() throws SAXException {
        this.processSimpleElement();
    }

    @Override
    protected void executeEvents(UnmarshalRecord unmarshalRecord) throws SAXException {
        super.executeEvents(unmarshalRecord);
        this.finished = true;
    }

    public UnmarshalRecord getWorkingUnmarshalRecord() {
        return this.workingUnmarshalRecord;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

